/*
 * Decompiled with CFR 0.152.
 */
package SocialSteeringsBeta;

import SocialSteeringsBeta.IAnimationEngine;
import SocialSteeringsBeta.ISocialSteering;
import SocialSteeringsBeta.RefLocation;
import SocialSteeringsBeta.SOC_STEER_LOG;
import SocialSteeringsBeta.SteeringResult;
import SteeringStuff.ISteering;
import SteeringStuff.RefBoolean;
import SteeringStuff.SteeringManager;
import SteeringStuff.SteeringTools;
import SteeringStuff.SteeringType;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetWalk;
import javax.vecmath.Vector3d;

public class SocialSteeringManager
extends SteeringManager {
    protected IAnimationEngine animationEngine;
    private int lastWS = 0;

    public SocialSteeringManager(UT2004Bot bot, Raycasting raycasting, AdvancedLocomotion locomotion, IAnimationEngine engine, double multiplier) {
        super(bot, raycasting, locomotion, multiplier);
        this.animationEngine = engine;
    }

    public SocialSteeringManager(UT2004Bot bot, Raycasting raycasting, AdvancedLocomotion locomotion, IAnimationEngine engine) {
        this(bot, raycasting, locomotion, engine, 1.0);
    }

    @Override
    public void moveTheBot(Vector3d nextVelocity, boolean everyoneWantsToGoFaster, Location focusLocation) {
        double precision;
        if (nextVelocity instanceof SteeringResult && nextVelocity.length() > 0.001) {
            precision = ((SteeringResult)nextVelocity).getAccurancyMultiplier();
        } else {
            if (nextVelocity.length() > 0.001) {
                if (this.animationEngine.canBeInterupt(this.botself)) {
                    if (SOC_STEER_LOG.DEBUG) {
                        SOC_STEER_LOG.AddLogLine("basic steering manager", SOC_STEER_LOG.KSync + this.botself.getName());
                    }
                    this.animationEngine.playAnimation(2, this.botself, true, 0);
                    super.moveTheBot(nextVelocity, everyoneWantsToGoFaster, focusLocation);
                    return;
                }
                if (SOC_STEER_LOG.DEBUG) {
                    SOC_STEER_LOG.AddLogLine("basic steering manager, wait for anim", SOC_STEER_LOG.KSync + this.botself.getName());
                }
                this.stopMovement(focusLocation);
                return;
            }
            precision = 0.0;
        }
        double nextVelocityLength = nextVelocity.length() * this.multiplier;
        int walkType = precision == 0.0 ? 0 : (precision < 3.0 ? 1 : (nextVelocityLength < 22000.0 ? 2 : 3));
        double nextVelMult = nextVelocityLength / 220.0;
        nextVelocityLength = nextVelMult * 220.0;
        nextVelocity.normalize();
        nextVelocity.scale(nextVelocityLength);
        this.myNextVelocity = new Vector3d(nextVelocity.x, nextVelocity.y, nextVelocity.z);
        this.botself.getAct().act(new Configuration().setSpeedMultiplier(nextVelocityLength / 220.0).setAutoTrace(true).setDrawTraceLines(this.drawRaycasting));
        if (this.animationEngine.canBeInterupt(this.botself)) {
            switch (walkType) {
                case 0: {
                    if (SOC_STEER_LOG.DEBUG) {
                        SOC_STEER_LOG.AddLogLine("correct place, idling", SOC_STEER_LOG.KSync + this.botself.getName());
                    }
                    this.stopMovement(focusLocation);
                    break;
                }
                case 1: {
                    Location tLoc = new Location(this.botself.getLocation().x + nextVelocity.x, this.botself.getLocation().y + nextVelocity.y, this.botself.getLocation().z);
                    Move m = new Move();
                    double angle = SteeringTools.getAngle(this.botself.getLocation(), this.botself.getRotation(), tLoc);
                    int direction = angle < 0.7853981633974483 ? 0 : (angle > 2.356194490192345 ? 2 : (SteeringTools.pointIsLeftFromTheVector(focusLocation.sub(this.botself.getLocation()).asVector3d(), tLoc.asVector3d()) ? 3 : 1));
                    m.setFirstLocation(tLoc);
                    m.setFocusLocation(focusLocation);
                    Configuration c = new Configuration();
                    c.setSpeedMultiplier(0.4);
                    this.botself.getAct().act(c);
                    this.botself.getAct().act(m);
                    if (this.lastWS == walkType) break;
                    String s = "";
                    if (this.myNextVelocity.length() > 20.0) {
                        s = this.animationEngine.playAnimation(1, this.botself, true, direction);
                    } else if (SOC_STEER_LOG.DEBUG) {
                        SOC_STEER_LOG.AddLogLine("slowMove not anim", SOC_STEER_LOG.KSync + this.botself.getName());
                    }
                    if (!SOC_STEER_LOG.DEBUG) break;
                    SOC_STEER_LOG.AddLogLine("slowMove " + angle + " angle " + s, SOC_STEER_LOG.KSync + this.botself.getName());
                    break;
                }
                case 2: {
                    Location tLoc = new Location(this.botself.getLocation().x + nextVelocity.x, this.botself.getLocation().y + nextVelocity.y, this.botself.getLocation().z);
                    Move mm = new Move();
                    mm.setFirstLocation(tLoc);
                    mm.setFocusLocation(tLoc);
                    Configuration cc = new Configuration();
                    cc.setSpeedMultiplier(0.8);
                    this.botself.getAct().act(cc);
                    this.botself.getAct().act(mm);
                    if (this.lastWS == walkType) break;
                    String s2 = this.animationEngine.playAnimation(2, this.botself, true, 0);
                    if (SOC_STEER_LOG.DEBUG) {
                        SOC_STEER_LOG.AddLogLine("Walk" + s2, SOC_STEER_LOG.KSync + this.botself.getName());
                    }
                    this.botself.getAct().act(new SetWalk().setWalk(true).setWalkAnim(s2));
                    break;
                }
            }
        } else {
            if (SOC_STEER_LOG.DEBUG) {
                SOC_STEER_LOG.AddLogLine("Wait for animation unineruptible animation", SOC_STEER_LOG.KSync + this.botself.getName());
            }
            this.stopMovement(focusLocation);
        }
        this.lastWS = walkType;
    }

    private void stopMovement(Location focusLocation) {
        this.myNextVelocity = new Vector3d(0.0, 0.0, 0.0);
        this.locomotion.setSpeed(0.0);
        this.locomotion.stopMovement();
        if (!focusLocation.equals(new Location(0.0, 0.0, 0.0))) {
            this.locomotion.turnTo(focusLocation);
        }
        if (this.animationEngine.canBeInterupt(this.botself)) {
            this.animationEngine.playAnimation("ambi_stand_normal01", this.botself, false);
        }
    }

    @Override
    protected Location setFocusSpecific(SteeringType steeringType, boolean wantsToStop, Location newFocus, Location focusLoc) {
        if (steeringType == SteeringType.TRIANGLE) {
            return newFocus;
        }
        return super.setFocusSpecific(steeringType, wantsToStop, newFocus, focusLoc);
    }

    @Override
    protected Vector3d setVelocitySpecific(ISteering steering, RefBoolean wantsToGoFaster, RefBoolean wantsToStop, RefLocation newFocus) {
        if (steering instanceof ISocialSteering) {
            return ((ISocialSteering)steering).runSocial(this.myNextVelocity, wantsToGoFaster, wantsToStop, newFocus);
        }
        return super.setVelocitySpecific(steering, wantsToGoFaster, wantsToStop, newFocus);
    }
}

