/*
 * Decompiled with CFR 0.152.
 */
package SteeringProperties;

import SteeringProperties.SteeringProperties;
import SteeringStuff.SteeringType;
import XMLSteeringProperties.XMLLeaderFollowingProperties;

public class LeaderFollowingProperties
extends SteeringProperties {
    private int leaderForce;
    private String leaderName;
    private int distance;
    private int forceDistance;
    private LFtype myLFtype;
    private boolean deceleration;
    private double angleFromTheLeader;
    private boolean velocityMemory;
    private int sizeOfMemory;
    private boolean circumvention;

    public LeaderFollowingProperties() {
        super(SteeringType.LEADER_FOLLOWING);
        this.leaderForce = 200;
        this.leaderName = "Leader";
        this.distance = 300;
        this.forceDistance = 50;
        this.myLFtype = LFtype.BASIC;
        this.deceleration = true;
        this.angleFromTheLeader = Math.PI;
        this.velocityMemory = true;
        this.sizeOfMemory = 5;
        this.circumvention = true;
    }

    public LeaderFollowingProperties(SteeringProperties.BehaviorType behaviorType) {
        super(SteeringType.LEADER_FOLLOWING, behaviorType);
        this.leaderForce = 200;
        this.leaderName = "Leader";
        this.distance = 300;
        this.forceDistance = 50;
        this.myLFtype = LFtype.BASIC;
        this.deceleration = true;
        this.angleFromTheLeader = Math.PI;
        this.velocityMemory = true;
        this.sizeOfMemory = 5;
        this.circumvention = true;
        this.setNewBehaviorType(behaviorType);
    }

    public LeaderFollowingProperties(XMLLeaderFollowingProperties xml) {
        super(SteeringType.LEADER_FOLLOWING, xml.active, xml.weight, xml.behavior);
        this.leaderForce = xml.leaderForce;
        this.leaderName = xml.leaderName;
        this.distance = xml.distance;
        this.forceDistance = xml.forceDistance;
        this.myLFtype = xml.myLFtype;
        this.deceleration = xml.deceleration;
        this.angleFromTheLeader = xml.angle;
        this.velocityMemory = xml.velocityMemory;
        this.sizeOfMemory = xml.sizeOfMemory;
        this.circumvention = xml.circumvention;
    }

    public LeaderFollowingProperties(int leaderForce, String leaderName, int distanceFromTheLeader, int forceDistance, LFtype myLFtype, boolean deceleration, double angleFromTheLeader, boolean velocityMemory, int sizeOfMemory, boolean goRound) {
        super(SteeringType.LEADER_FOLLOWING);
        this.leaderForce = leaderForce;
        this.leaderName = leaderName;
        this.distance = distanceFromTheLeader;
        this.forceDistance = forceDistance;
        this.myLFtype = myLFtype;
        this.deceleration = deceleration;
        this.angleFromTheLeader = angleFromTheLeader;
        this.velocityMemory = velocityMemory;
        this.sizeOfMemory = sizeOfMemory;
        this.circumvention = goRound;
    }

    @Override
    protected void setNewBehaviorType(SteeringProperties.BehaviorType behaviorType) {
        if (behaviorType.equals((Object)SteeringProperties.BehaviorType.BASIC)) {
            this.myLFtype = LFtype.BASIC;
            this.sizeOfMemory = 0;
            this.deceleration = false;
            this.velocityMemory = false;
            this.circumvention = false;
        } else if (behaviorType.equals((Object)SteeringProperties.BehaviorType.ADVANCED)) {
            this.myLFtype = LFtype.FORMATION;
            this.sizeOfMemory = 5;
            this.deceleration = true;
            this.velocityMemory = true;
            this.circumvention = true;
        }
    }

    public double getAngleFromTheLeader() {
        return this.angleFromTheLeader;
    }

    public void setAngleFromTheLeader(double angleFromTheLeader) {
        this.angleFromTheLeader = angleFromTheLeader;
    }

    public int getDistanceFromTheLeader() {
        return this.distance;
    }

    public void setDistanceFromTheLeader(int distanceFromTheLeader) {
        this.distance = distanceFromTheLeader;
    }

    public int getForceDistance() {
        return this.forceDistance;
    }

    public void setForceDistance(int forceDistance) {
        this.forceDistance = forceDistance;
    }

    public String getLeaderName() {
        return this.leaderName;
    }

    public void setLeaderName(String leaderName) {
        this.leaderName = leaderName;
    }

    public int getSizeOfMemory() {
        return this.sizeOfMemory;
    }

    public void setSizeOfMemory(int sizeOfMemory) {
        this.sizeOfMemory = sizeOfMemory;
    }

    public boolean isVelocityMemory() {
        return this.velocityMemory;
    }

    public void setVelocityMemory(boolean velocityMemory) {
        this.velocityMemory = velocityMemory;
    }

    public boolean isDeceleration() {
        return this.deceleration;
    }

    public void setDeceleration(boolean deceleration) {
        this.deceleration = deceleration;
    }

    public boolean isCircumvention() {
        return this.circumvention;
    }

    public void setCircumvention(boolean circumvention) {
        this.circumvention = circumvention;
    }

    public int getLeaderForce() {
        return this.leaderForce;
    }

    public void setLeaderForce(int leaderForce) {
        this.leaderForce = leaderForce;
    }

    public LFtype getMyLFtype() {
        return this.myLFtype;
    }

    public void setMyLFtype(LFtype myLFtype) {
        this.myLFtype = myLFtype;
    }

    @Override
    public String getSpecialText() {
        String text = "";
        text = text + "  * Leader Force: " + this.leaderName + "\n";
        text = text + "  * Leader: " + this.leaderName + "\n";
        text = text + "  * Distance: " + this.distance + "\n";
        text = text + "  * Force Distance: " + this.forceDistance + "\n";
        text = text + "  * LF type: " + (Object)((Object)this.myLFtype) + "\n";
        if (this.myLFtype.equals((Object)LFtype.BASIC)) {
            text = text + "  * Deceleration: " + this.deceleration + "\n";
        } else {
            text = text + "  * Angle: " + this.angleFromTheLeader + "\n";
            text = text + "  * Memory: " + this.velocityMemory + "\n";
            if (this.velocityMemory) {
                text = text + "  * Memory size: " + this.sizeOfMemory + "\n";
            }
            text = text + "  * Circumvention: " + this.circumvention + "\n";
        }
        return text;
    }

    @Override
    public void setProperties(SteeringProperties newProperties) {
        this.leaderForce = ((LeaderFollowingProperties)newProperties).getLeaderForce();
        this.leaderName = ((LeaderFollowingProperties)newProperties).getLeaderName();
        this.distance = ((LeaderFollowingProperties)newProperties).getDistanceFromTheLeader();
        this.forceDistance = ((LeaderFollowingProperties)newProperties).getForceDistance();
        this.myLFtype = ((LeaderFollowingProperties)newProperties).getMyLFtype();
        this.deceleration = ((LeaderFollowingProperties)newProperties).isDeceleration();
        this.angleFromTheLeader = ((LeaderFollowingProperties)newProperties).getAngleFromTheLeader();
        this.velocityMemory = ((LeaderFollowingProperties)newProperties).isVelocityMemory();
        this.sizeOfMemory = ((LeaderFollowingProperties)newProperties).getSizeOfMemory();
        this.circumvention = ((LeaderFollowingProperties)newProperties).isCircumvention();
    }

    public XMLLeaderFollowingProperties getXMLProperties() {
        XMLLeaderFollowingProperties xmlProp = new XMLLeaderFollowingProperties();
        xmlProp.leaderForce = this.leaderForce;
        xmlProp.leaderName = this.leaderName;
        xmlProp.distance = this.distance;
        xmlProp.forceDistance = this.forceDistance;
        xmlProp.myLFtype = this.myLFtype;
        xmlProp.deceleration = this.deceleration;
        xmlProp.angle = this.angleFromTheLeader;
        xmlProp.sizeOfMemory = this.sizeOfMemory;
        xmlProp.velocityMemory = this.velocityMemory;
        xmlProp.circumvention = this.circumvention;
        xmlProp.active = this.active;
        xmlProp.weight = this.weight;
        xmlProp.behavior = this.behaviorType;
        return xmlProp;
    }

    public static enum LFtype {
        BASIC,
        FORMATION;

    }
}

