/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.engine;

import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.engine.DriveNodeExecutor;
import cz.cuni.amis.pogamut.sposh.engine.EngineLog;
import cz.cuni.amis.pogamut.sposh.engine.FireResult;
import cz.cuni.amis.pogamut.sposh.engine.INodeExecutor;
import cz.cuni.amis.pogamut.sposh.engine.NodeExecutor;
import cz.cuni.amis.pogamut.sposh.engine.NodeResult;
import cz.cuni.amis.pogamut.sposh.engine.PoshEngine;
import cz.cuni.amis.pogamut.sposh.engine.SenseListExecutor;
import cz.cuni.amis.pogamut.sposh.engine.TriggerResult;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.engine.timer.ITimer;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.amis.pogamut.sposh.executor.IWorkExecutor;
import java.util.ArrayList;
import java.util.List;

class DCNodeExecutor
extends NodeExecutor<DriveCollection> {
    private final ITimer timer;
    private final SenseListExecutor<DriveCollection> goalExecutor;
    private List<DriveNodeExecutor> driveExecutors = new ArrayList<DriveNodeExecutor>();
    private DriveNodeExecutor lastTriggeredDrive = null;

    DCNodeExecutor(PoshPlan plan, LapPath path, VariableContext ctx, EngineLog engineLog, ITimer timer) {
        super(plan, path, ctx, engineLog);
        DriveCollection dc = plan.getDriveCollection();
        assert (path.traversePath(plan) == dc);
        this.timer = timer;
        this.goalExecutor = new SenseListExecutor<DriveCollection>(dc.getGoal(), this.path, ctx, engineLog);
        int driveId = 0;
        for (DriveElement drive : dc.getDrives()) {
            assert (drive.getId() == driveId);
            LapPath drivePath = path.concat(LapType.DRIVE_ELEMENT, driveId++);
            this.driveExecutors.add(new DriveNodeExecutor(plan, drivePath, ctx, engineLog, timer));
        }
    }

    public synchronized PoshEngine.EvaluationResultInfo fire(IWorkExecutor workExecuter) {
        TriggerResult triggerResult = this.goalExecutor.fire(workExecuter, false);
        if (triggerResult.wasSuccess()) {
            return new PoshEngine.EvaluationResultInfo(PoshEngine.EvaluationResult.GOAL_SATISFIED, FireResult.Type.FULFILLED);
        }
        for (DriveNodeExecutor driveExecutor : this.driveExecutors) {
            NodeResult result;
            if (!driveExecutor.isElegible(workExecuter, this.timer.getTime())) continue;
            if (this.lastTriggeredDrive != null && this.lastTriggeredDrive != driveExecutor) {
                this.lastTriggeredDrive.interrupt();
            }
            this.lastTriggeredDrive = driveExecutor;
            if (driveExecutor.stack.isEmpty()) {
                result = driveExecutor.evaluate(workExecuter);
            } else {
                INodeExecutor stackTop = driveExecutor.stack.peek();
                result = stackTop.evaluate(workExecuter);
            }
            switch (result.state) {
                case CONTINUE: {
                    driveExecutor.stack.pop();
                    break;
                }
                case DONE: {
                    driveExecutor.stack.pop();
                    break;
                }
                case FAILED: {
                    driveExecutor.stack.pop();
                    break;
                }
                case FOLLOW: {
                    driveExecutor.stack.push(result.executor);
                    break;
                }
                default: {
                    throw new FubarException("Wrong type " + (Object)((Object)result.state));
                }
            }
            switch (result.state) {
                case CONTINUE: {
                    throw new UnsupportedOperationException("TODO: implement");
                }
                case DONE: {
                    throw new UnsupportedOperationException("TODO: implement");
                }
                case FAILED: {
                    throw new UnsupportedOperationException("TODO: implement");
                }
                case FOLLOW: {
                    throw new UnsupportedOperationException("TODO: implement");
                }
            }
            throw new FubarException("Wrong type " + (Object)((Object)result.state));
        }
        return new PoshEngine.EvaluationResultInfo(PoshEngine.EvaluationResult.NO_ELEMENT_FIRED, FireResult.Type.FAILED);
    }
}

