/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.BSPRayInfoContainer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.LevelGeometryBSPNode;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DrawStayingDebugLines;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRayMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import math.geom2d.line.StraightLine2D;
import math.geom3d.Point3D;
import math.geom3d.Vector3D;
import math.geom3d.line.StraightLine3D;
import math.geom3d.plane.Plane3D;

public class LevelGeometry
implements Serializable {
    public ArrayList<double[]> verts = new ArrayList();
    public ArrayList<int[]> triangles = new ArrayList();
    private LevelGeometryBSPNode bspTree;
    private LevelGeometryBSPNode biggestLeafInTree;
    public int leafCount = 0;
    public double minX = Double.MAX_VALUE;
    public double maxX = Double.MIN_VALUE;
    public double minY = Double.MAX_VALUE;
    public double maxY = Double.MIN_VALUE;
    public double minZ = Double.MAX_VALUE;
    public double maxZ = Double.MIN_VALUE;
    public Random random = new Random();

    public LevelGeometry(String mapName) throws FileNotFoundException, IOException, Exception {
        this.verts.add(new double[0]);
        String fileName = NavMeshConstants.pureLevelGeometryReadDir + "\\" + mapName + ".scale";
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        String line = br.readLine();
        double scale = Double.parseDouble(line);
        fileName = NavMeshConstants.pureLevelGeometryReadDir + "\\" + mapName + ".centre";
        br = new BufferedReader(new FileReader(fileName));
        line = br.readLine();
        String[] sc = line.split("[ \\t]");
        double[] centre = new double[3];
        for (int i = 0; i < 3; ++i) {
            centre[i] = Double.parseDouble(sc[i]);
        }
        fileName = NavMeshConstants.pureLevelGeometryReadDir + "\\" + mapName + ".obj";
        br = new BufferedReader(new FileReader(fileName));
        while ((line = br.readLine()) != null) {
            String[] words = line.split("[ \\t]");
            if (words[0].equals("v")) {
                double[] v = new double[]{Double.parseDouble(words[1]) * scale + centre[0], Double.parseDouble(words[3]) * scale + centre[1], Double.parseDouble(words[2]) * scale + centre[2]};
                this.verts.add(v);
                if (v[0] < this.minX) {
                    this.minX = v[0];
                }
                if (v[0] > this.maxX) {
                    this.maxX = v[0];
                }
                if (v[1] < this.minY) {
                    this.minY = v[1];
                }
                if (v[1] > this.maxY) {
                    this.maxY = v[1];
                }
                if (v[2] < this.minZ) {
                    this.minZ = v[2];
                }
                if (v[2] > this.maxZ) {
                    this.maxZ = v[2];
                }
            }
            if (!words[0].equals("f")) continue;
            int[] t = new int[]{Integer.parseInt(words[1]), Integer.parseInt(words[2]), Integer.parseInt(words[3])};
            this.triangles.add(t);
        }
        this.resetBSPTree();
    }

    public void draw(UT2004Server server, Location color) {
        for (int tId = 0; tId < this.triangles.size(); ++tId) {
            DrawStayingDebugLines d = new DrawStayingDebugLines();
            String lines = this.triangleToDebugString(tId);
            d.setVectors(lines);
            d.setColor(new Location(255.0, 255.0, 255.0));
            d.setClearAll(tId == 0);
            server.getAct().act(d);
        }
    }

    public void drawOneTriangle(UT2004Server server, int tId, Location color) {
        DrawStayingDebugLines d = new DrawStayingDebugLines();
        String lines = this.triangleToDebugString(tId);
        d.setVectors(lines);
        d.setColor(color);
        d.setClearAll(false);
        server.getAct().act(d);
    }

    private String triangleToDebugString(int tId) {
        StringBuilder result = new StringBuilder("");
        int[] t = this.triangles.get(tId);
        for (int j = 0; j < t.length; ++j) {
            if (result.length() > 0) {
                result.append(";");
            }
            double[] v1 = this.verts.get(t[j]);
            double[] v2 = j == t.length - 1 ? this.verts.get(t[0]) : this.verts.get(t[j + 1]);
            result.append(v1[0] + "," + v1[1] + "," + v1[2] + ";" + v2[0] + "," + v2[1] + "," + v2[2]);
        }
        return result.toString();
    }

    private void resetBSPTree() throws Exception {
        System.out.println("Creating BSP tree...");
        this.bspTree = new LevelGeometryBSPNode(this, null, this.minX, this.maxX, this.minY, this.maxY, this.minZ, this.maxZ);
        for (int i = 0; i < this.triangles.size(); ++i) {
            this.bspTree.triangles.add(i);
        }
        this.biggestLeafInTree = null;
        this.bspTree.build();
        System.out.println("BSP tree is done building.");
        System.out.println("Biggest leaf has " + this.biggestLeafInTree.triangles.size() + " triangles.");
        System.out.println("BSP tree has " + this.leafCount + " leaves");
        this.bspTree.cleanInnerNodes();
    }

    void setBiggestLeafInTree(LevelGeometryBSPNode node) {
        this.biggestLeafInTree = node;
    }

    int getNumberOfTrianglesInBiggestLeaf() {
        if (this.biggestLeafInTree == null) {
            return 0;
        }
        return this.biggestLeafInTree.triangles.size();
    }

    private LevelGeometryBSPNode getBSPLeaf(Location location) {
        double x = location.x;
        double y = location.y;
        double z = location.z;
        LevelGeometryBSPNode node = this.bspTree;
        if (x > node.maxX || x < node.minX) {
            return null;
        }
        if (y > node.maxY || y < node.minY) {
            return null;
        }
        if (z > node.maxZ || z < node.minZ) {
            return null;
        }
        block5: while (node.left != null) {
            switch (node.sepDim) {
                case 0: {
                    if (x < node.sepVal) {
                        node = node.left;
                        continue block5;
                    }
                    node = node.right;
                    continue block5;
                }
                case 1: {
                    if (y < node.sepVal) {
                        node = node.left;
                        continue block5;
                    }
                    node = node.right;
                    continue block5;
                }
                case 2: {
                    if (z < node.sepVal) {
                        node = node.left;
                        continue block5;
                    }
                    node = node.right;
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("This should not happen!");
        }
        return node;
    }

    public AutoTraceRay getAutoTraceRayMessage(Self self, BSPRayInfoContainer rayInfo) {
        Vector3d direction = rayInfo.direction;
        direction.normalize();
        double upDownAngle = Math.asin(direction.getZ() / 1.0);
        double UTFullAngle = 65536.0;
        double UTHalfAngle = UTFullAngle / 2.0;
        double UTQuarterAngle = UTHalfAngle / 2.0;
        double x = rayInfo.direction.x;
        double y = rayInfo.direction.y;
        if (x == 0.0 && y == 0.0) {
            direction = new Vector3d(0.0, 0.0, 1.0);
        } else {
            double rayYaw = NavMeshConstants.transform2DVectorToRotation(new Vector2d(x, y));
            double Yaw = rayYaw + self.getRotation().getYaw();
            Vector2d vector2d = NavMeshConstants.transformRotationTo2DVector(Yaw);
            direction.x = vector2d.x;
            direction.y = vector2d.y;
            direction.normalize();
            direction.z = Math.tan(upDownAngle);
        }
        direction.normalize();
        direction.x *= (double)rayInfo.length;
        direction.y *= (double)rayInfo.length;
        direction.z *= (double)rayInfo.length;
        Location from = self.getLocation();
        Location to = new Location(from.x + direction.x, from.y + direction.y, from.z + direction.z);
        return this.getAutoTraceRayMessage(from, to, rayInfo);
    }

    private AutoTraceRay getAutoTraceRayMessage(Location from, Location to, BSPRayInfoContainer rayInfo) {
        StraightLine3D ray = new StraightLine3D(from.asPoint3D(), to.asPoint3D());
        boolean collisionFound = false;
        double collisionDistance = Double.MAX_VALUE;
        Location hitLocation = null;
        Vector3d normalVector = null;
        LevelGeometryBSPNode leaf = this.getBSPLeaf(from);
        for (Integer tId : leaf.triangles) {
            double distance;
            double[] v3;
            Vector3D vector2;
            double[] v2;
            Vector3D vector1;
            int[] triangle = this.triangles.get(tId);
            double[] v1 = this.verts.get(triangle[0]);
            Point3D p1 = new Point3D(v1[0], v1[1], v1[2]);
            Plane3D plane = new Plane3D(p1, vector1 = new Vector3D((v2 = this.verts.get(triangle[1]))[0] - v1[0], v2[1] - v1[1], v2[2] - v1[2]), vector2 = new Vector3D((v3 = this.verts.get(triangle[2]))[0] - v1[0], v3[1] - v1[1], v3[2] - v1[2]));
            Point3D intersection = plane.getLineIntersection(ray);
            boolean collision = this.isPointInsideTriangle(intersection, tId);
            if (!collision || !((distance = intersection.getDistance(from.asPoint3D())) < collisionDistance)) continue;
            collision = true;
            collisionDistance = distance;
            hitLocation = new Location(intersection.getX(), intersection.getY(), intersection.getZ());
            Vector3D normalVector3D = plane.getNormalVector();
            normalVector = new Vector3d(normalVector3D.getX(), normalVector3D.getY(), normalVector3D.getZ());
        }
        if (collisionFound) {
            return new AutoTraceRayMessage(rayInfo.unrealId, from, to, false, rayInfo.floorCorrection, true, normalVector, hitLocation, false, null);
        }
        boolean out = false;
        if (to.x > leaf.maxX) {
            out = true;
        }
        if (to.x < leaf.minX) {
            out = true;
        }
        if (to.y > leaf.maxY) {
            out = true;
        }
        if (to.y < leaf.minY) {
            out = true;
        }
        if (to.z > leaf.maxZ) {
            out = true;
        }
        if (to.z < leaf.minZ) {
            out = true;
        }
        if (out) {
            double distance;
            Point3D intersection;
            Plane3D plane;
            Vector3D vector2;
            Vector3D vector1;
            Point3D p1;
            collisionDistance = Double.MAX_VALUE;
            Point3D collisionPoint = null;
            if (to.x > from.x) {
                p1 = new Point3D(leaf.maxX, 0.0, 0.0);
                vector1 = new Vector3D(0.0, 1.0, 0.0);
                vector2 = new Vector3D(0.0, 0.0, 1.0);
                plane = new Plane3D(p1, vector1, vector2);
                intersection = plane.getLineIntersection(ray);
                distance = intersection.getDistance(ray.getFirstPoint());
                if (distance < collisionDistance) {
                    collisionPoint = intersection;
                    collisionDistance = distance;
                }
            } else {
                p1 = new Point3D(leaf.minX, 0.0, 0.0);
                vector1 = new Vector3D(0.0, 1.0, 0.0);
                vector2 = new Vector3D(0.0, 0.0, 1.0);
                plane = new Plane3D(p1, vector1, vector2);
                intersection = plane.getLineIntersection(ray);
                distance = intersection.getDistance(ray.getFirstPoint());
                if (distance < collisionDistance) {
                    collisionPoint = intersection;
                    collisionDistance = distance;
                }
            }
            if (to.y > from.y) {
                p1 = new Point3D(0.0, leaf.maxY, 0.0);
                vector1 = new Vector3D(1.0, 0.0, 0.0);
                vector2 = new Vector3D(0.0, 0.0, 1.0);
                plane = new Plane3D(p1, vector1, vector2);
                intersection = plane.getLineIntersection(ray);
                distance = intersection.getDistance(ray.getFirstPoint());
                if (distance < collisionDistance) {
                    collisionPoint = intersection;
                    collisionDistance = distance;
                }
            } else {
                p1 = new Point3D(0.0, leaf.minY, 0.0);
                vector1 = new Vector3D(1.0, 0.0, 0.0);
                vector2 = new Vector3D(0.0, 0.0, 1.0);
                plane = new Plane3D(p1, vector1, vector2);
                intersection = plane.getLineIntersection(ray);
                distance = intersection.getDistance(ray.getFirstPoint());
                if (distance < collisionDistance) {
                    collisionPoint = intersection;
                    collisionDistance = distance;
                }
            }
            if (to.z > from.z) {
                p1 = new Point3D(0.0, 0.0, leaf.maxZ);
                vector1 = new Vector3D(1.0, 0.0, 0.0);
                vector2 = new Vector3D(0.0, 1.0, 0.0);
                plane = new Plane3D(p1, vector1, vector2);
                intersection = plane.getLineIntersection(ray);
                distance = intersection.getDistance(ray.getFirstPoint());
                if (distance < collisionDistance) {
                    collisionPoint = intersection;
                    collisionDistance = distance;
                }
            } else {
                p1 = new Point3D(0.0, 0.0, leaf.minZ);
                vector1 = new Vector3D(1.0, 0.0, 0.0);
                vector2 = new Vector3D(0.0, 1.0, 0.0);
                plane = new Plane3D(p1, vector1, vector2);
                intersection = plane.getLineIntersection(ray);
                distance = intersection.getDistance(ray.getFirstPoint());
                if (distance < collisionDistance) {
                    collisionPoint = intersection;
                    collisionDistance = distance;
                }
            }
            Vector3d direction = (Vector3d)rayInfo.direction.clone();
            direction.normalize();
            Location newPoint = new Location(collisionPoint.getX() + direction.x, collisionPoint.getX() + direction.y, collisionPoint.getX() + direction.z);
            AutoTraceRay falseAnswer = this.getAutoTraceRayMessage(newPoint, to, rayInfo);
            return new AutoTraceRayMessage(rayInfo.unrealId, from, to, false, rayInfo.floorCorrection, falseAnswer.isResult(), falseAnswer.getHitNormal(), falseAnswer.getHitLocation(), false, null);
        }
        return new AutoTraceRayMessage(rayInfo.unrealId, from, to, false, rayInfo.floorCorrection, false, null, null, false, null);
    }

    private boolean isPointInsideTriangle(Point3D point3D, Integer tId) {
        boolean result = true;
        int[] triangle = this.triangles.get(tId);
        math.geom2d.Point2D point2D = new math.geom2d.Point2D(point3D.getX(), point3D.getY());
        double rightSide = 0.0;
        for (int i = 0; i < triangle.length; ++i) {
            double[] v1 = this.verts.get(triangle[i]);
            double[] v2 = i < triangle.length - 1 ? this.verts.get(triangle[i + 1]) : this.verts.get(triangle[0]);
            math.geom2d.Point2D p1 = new math.geom2d.Point2D(v1[0], v1[1]);
            math.geom2d.Point2D p2 = new math.geom2d.Point2D(v2[0], v2[1]);
            StraightLine2D line = new StraightLine2D((Point2D)p1, (Point2D)p2);
            double dist = line.getSignedDistance(point2D);
            if (rightSide == 0.0) {
                rightSide = Math.signum(dist);
                continue;
            }
            if (!(rightSide * dist < 0.0)) continue;
            result = false;
            break;
        }
        return result;
    }
}

