/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.command;

import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weapon;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPref;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPrefs;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ChangeWeapon;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Shoot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.StopShooting;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.translator.itemdescriptor.WeaponDescriptor;
import cz.cuni.amis.utils.NullCheck;
import java.util.logging.Logger;

public class ImprovedShooting
extends AdvancedShooting {
    private Weaponry weaponry;
    private ItemType currentWeapon = null;
    private Self self;
    private IWorldObjectListener<Self> selfListener = new IWorldObjectListener<Self>(){

        @Override
        public void notify(IWorldObjectEvent<Self> event) {
            ImprovedShooting.this.self = event.getObject();
            if (ImprovedShooting.this.weaponry.getCurrentWeapon() == null) {
                ImprovedShooting.this.currentWeapon = null;
            } else {
                ImprovedShooting.this.currentWeapon = ImprovedShooting.this.weaponry.getCurrentWeapon().getType();
            }
        }
    };
    private long lastChangeWeapon = 0L;
    private long changeWeaponCooldown = 1000L;
    private ICommandListener<ChangeWeapon> changeWeaponListener = new ICommandListener<ChangeWeapon>(){

        @Override
        public void notify(ChangeWeapon event) {
            WeaponDescriptor weapon = ImprovedShooting.this.weaponry.getDescriptorForId(UnrealId.get(event.getId()));
            if (weapon == null) {
                ImprovedShooting.this.log.warning("Unknown weapon descriptor for item of inventory ID: " + event.getId());
            }
            ImprovedShooting.this.currentWeapon = weapon.getPickupType();
            ImprovedShooting.this.lastChangeWeapon = System.currentTimeMillis();
        }
    };
    private WeaponPref lastShooting = null;
    private ICommandListener<Shoot> shootListener = new ICommandListener<Shoot>(){

        @Override
        public void notify(Shoot event) {
            if (ImprovedShooting.this.currentWeapon == null) {
                ImprovedShooting.this.lastShooting = null;
            } else {
                ImprovedShooting.this.lastShooting = new WeaponPref(ImprovedShooting.this.currentWeapon, event.isAlt() == null || event.isAlt() == false);
            }
        }
    };
    private ICommandListener<StopShooting> stopShootingListener = new ICommandListener<StopShooting>(){

        @Override
        public void notify(StopShooting event) {
            ImprovedShooting.this.lastShooting = null;
        }
    };

    public ImprovedShooting(Weaponry weaponry, UT2004Bot agent, Logger log) {
        super(agent, log);
        NullCheck.check(weaponry, "weaponry");
        this.weaponry = weaponry;
        agent.getWorldView().addObjectListener(Self.class, this.selfListener);
        agent.getAct().addCommandListener(Shoot.class, this.shootListener);
        agent.getAct().addCommandListener(StopShooting.class, this.stopShootingListener);
        agent.getAct().addCommandListener(ChangeWeapon.class, this.changeWeaponListener);
    }

    public boolean mayChangeWeapon() {
        return System.currentTimeMillis() - this.lastChangeWeapon > this.changeWeaponCooldown;
    }

    public WeaponPref getActualWeaponPref() {
        if (this.lastShooting != null && this.lastShooting.getWeapon() == this.currentWeapon) {
            return this.lastShooting;
        }
        if (this.currentWeapon != null) {
            return new WeaponPref(this.currentWeapon, true);
        }
        return null;
    }

    protected ItemType getActualWeaponType() {
        if (this.currentWeapon != null) {
            return this.currentWeapon;
        }
        return null;
    }

    public boolean changeWeapon(ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        if (this.currentWeapon == weaponType) {
            return true;
        }
        if (!this.mayChangeWeapon()) {
            return false;
        }
        return this.changeWeaponNow(weaponType);
    }

    public boolean changeWeapon(Weapon weapon) {
        if (weapon == null) {
            return false;
        }
        if (this.currentWeapon == weapon.getType()) {
            return true;
        }
        if (!this.mayChangeWeapon()) {
            return false;
        }
        return this.changeWeaponNow(weapon);
    }

    public boolean changeWeapon(WeaponPref pref) {
        if (pref == null) {
            return false;
        }
        if (this.currentWeapon == pref.getWeapon()) {
            return true;
        }
        if (!this.mayChangeWeapon()) {
            return false;
        }
        return this.changeWeaponNow(pref);
    }

    public WeaponPref changeWeapon(WeaponPrefs weaponPrefs, ItemType ... forbiddenWeapons) {
        WeaponPref chosen = weaponPrefs.getWeaponPreference(forbiddenWeapons);
        if (this.changeWeapon(chosen)) {
            return chosen;
        }
        return this.getActualWeaponPref();
    }

    public WeaponPref changeWeapon(WeaponPrefs weaponPrefs, double distance, ItemType ... forbiddenWeapons) {
        WeaponPref chosen = weaponPrefs.getWeaponPreference(distance, forbiddenWeapons);
        if (this.changeWeapon(chosen)) {
            return chosen;
        }
        return this.getActualWeaponPref();
    }

    public WeaponPref changeWeapon(WeaponPrefs weaponPrefs, ILocated target, ItemType ... forbiddenWeapons) {
        WeaponPref chosen = weaponPrefs.getWeaponPreference(target, forbiddenWeapons);
        if (this.changeWeapon(chosen)) {
            return chosen;
        }
        return this.getActualWeaponPref();
    }

    public boolean changeWeaponNow(ItemType weaponType) {
        if (weaponType == null) {
            return false;
        }
        return this.weaponry.changeWeapon(weaponType);
    }

    public boolean changeWeaponNow(Weapon weapon) {
        if (weapon == null) {
            return false;
        }
        return this.weaponry.changeWeapon(weapon);
    }

    public boolean changeWeaponNow(WeaponPref pref) {
        if (pref == null) {
            return false;
        }
        if (pref.isPrimary()) {
            if (this.weaponry.hasPrimaryLoadedWeapon(pref.getWeapon())) {
                return this.changeWeaponNow(pref.getWeapon());
            }
            this.log.info("Can't change to weapon-primary " + pref.getWeapon() + " as we do not have the weapon/or ammo for doing so.");
            return false;
        }
        if (this.weaponry.hasSecondaryLoadedWeapon(pref.getWeapon())) {
            return this.changeWeaponNow(pref.getWeapon());
        }
        this.log.info("Can't change to weapon-secondary " + pref.getWeapon() + " as we do not have the weapon/or ammo for doing so.");
        return false;
    }

    public WeaponPref changeWeaponNow(WeaponPrefs weaponPrefs, ItemType ... forbiddenWeapons) {
        WeaponPref chosen = weaponPrefs.getWeaponPreference(forbiddenWeapons);
        if (this.changeWeaponNow(chosen)) {
            return chosen;
        }
        return this.getActualWeaponPref();
    }

    public WeaponPref changeWeaponNow(WeaponPrefs weaponPrefs, double distance, ItemType ... forbiddenWeapons) {
        WeaponPref chosen = weaponPrefs.getWeaponPreference(distance, forbiddenWeapons);
        if (this.changeWeaponNow(chosen)) {
            return chosen;
        }
        return this.getActualWeaponPref();
    }

    public WeaponPref changeWeaponNow(WeaponPrefs weaponPrefs, ILocated target, ItemType ... forbiddenWeapons) {
        WeaponPref chosen = weaponPrefs.getWeaponPreference(target, forbiddenWeapons);
        if (this.changeWeaponNow(chosen)) {
            return chosen;
        }
        return this.getActualWeaponPref();
    }

    public boolean shoot(WeaponPref pref, UnrealId target) {
        if (pref == null) {
            return false;
        }
        if (this.currentWeapon == pref.getWeapon()) {
            if (pref.isPrimary()) {
                this.shoot(target);
            } else {
                this.shootSecondary(target);
            }
            return true;
        }
        if (!this.mayChangeWeapon()) {
            if (this.lastShooting != null && this.currentWeapon == this.lastShooting.getWeapon()) {
                if (this.lastShooting.isPrimary()) {
                    this.shoot(target);
                } else {
                    this.shootSecondary(target);
                }
            } else {
                this.shoot(target);
            }
            return true;
        }
        return this.shootNow(pref, target);
    }

    public boolean shoot(WeaponPref pref, ILocated target) {
        if (pref == null) {
            return false;
        }
        if (this.currentWeapon == pref.getWeapon()) {
            if (pref.isPrimary()) {
                this.shoot(target);
            } else {
                this.shootSecondary(target);
            }
            return true;
        }
        if (!this.mayChangeWeapon()) {
            if (this.lastShooting != null && this.currentWeapon == this.lastShooting.getWeapon()) {
                if (this.lastShooting.isPrimary()) {
                    this.shoot(target);
                } else {
                    this.shootSecondary(target);
                }
            } else {
                this.shoot(target);
            }
            return true;
        }
        return this.shootNow(pref, target);
    }

    public boolean shoot(Weapon weapon, boolean usePrimaryMode, UnrealId target) {
        if (weapon == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.shoot(new WeaponPref(weapon.getType(), usePrimaryMode), target);
    }

    public boolean shoot(Weapon weapon, boolean usePrimaryMode, ILocated target) {
        if (weapon == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.shoot(new WeaponPref(weapon.getType(), usePrimaryMode), target);
    }

    public WeaponPref shoot(WeaponPrefs prefs, ILocated target, ItemType ... forbiddenWeapon) {
        NullCheck.check(prefs, "prefs");
        if (target == null) {
            return null;
        }
        WeaponPref chosen = prefs.getWeaponPreference(target, forbiddenWeapon);
        if (this.shoot(chosen, target)) {
            return chosen;
        }
        return this.getActualWeaponPref();
    }

    public boolean shootNow(WeaponPref pref, UnrealId target) {
        if (pref == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (this.currentWeapon == pref.getWeapon() || this.changeWeaponNow(pref)) {
            if (pref.isPrimary()) {
                this.shoot(target);
            } else {
                this.shootSecondary(target);
            }
        } else if (this.lastShooting != null && this.currentWeapon == this.lastShooting.getWeapon()) {
            if (this.lastShooting.isPrimary()) {
                this.shoot(target);
            } else {
                this.shootSecondary(target);
            }
        } else {
            this.shoot(target);
        }
        return true;
    }

    public boolean shootNow(WeaponPref pref, ILocated target) {
        if (pref == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        if (this.currentWeapon == pref.getWeapon() || this.changeWeaponNow(pref)) {
            if (pref.isPrimary()) {
                this.shoot(target);
            } else {
                this.shootSecondary(target);
            }
            return true;
        }
        if (this.lastShooting != null && this.currentWeapon == this.lastShooting.getWeapon()) {
            if (this.lastShooting.isPrimary()) {
                this.shoot(target);
            } else {
                this.shootSecondary(target);
            }
            return true;
        }
        this.shoot(target);
        return true;
    }

    public boolean shootNow(Weapon weapon, boolean usePrimaryMode, UnrealId target) {
        if (weapon == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.shootNow(new WeaponPref(weapon.getType(), usePrimaryMode), target);
    }

    public boolean shootNow(Weapon weapon, boolean usePrimaryMode, ILocated target) {
        if (weapon == null) {
            return false;
        }
        if (target == null) {
            return false;
        }
        return this.shootNow(new WeaponPref(weapon.getType(), usePrimaryMode), target);
    }

    public WeaponPref shootNow(WeaponPrefs prefs, ILocated target, ItemType ... forbiddenWeapon) {
        NullCheck.check(prefs, "prefs");
        if (target == null) {
            return null;
        }
        WeaponPref chosen = prefs.getWeaponPreference(target, forbiddenWeapon);
        if (this.shootNow(chosen, target)) {
            return chosen;
        }
        return this.getActualWeaponPref();
    }

    public WeaponPref getLastShooting() {
        return this.lastShooting;
    }

    public long getLastChangeWeapon() {
        return this.lastChangeWeapon;
    }

    public long getChangeWeaponCooldown() {
        return this.changeWeaponCooldown;
    }

    public void setChangeWeaponCooldown(long changeWeaponCooldownMillis) {
        this.changeWeaponCooldown = changeWeaponCooldownMillis;
    }
}

