/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.IStaticWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ICompositeWorldObject;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.GBObjectUpdate;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EntityLocal;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EntityLocalImpl;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EntityMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EntityShared;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EntitySharedImpl;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EntityStatic;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EntityStaticImpl;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.objects.IGBViewable;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.objects.IGBWorldObjectEvent;
import cz.cuni.amis.utils.exception.PogamutException;

public abstract class Entity
extends InfoMessage
implements IWorldEvent,
IWorldChangeEvent,
ICompositeWorldObject,
ILocated,
IGBViewable {
    public static final String PROTOTYPE = "ENT {Id unreal_id}  {Visible False}  {Location 0,0,0}  {Rotation 0,0,0}  {Velocity 0,0,0}  {Type text}  {EntityClass text} ";
    protected long SimTime;

    @Override
    public long getSimTime() {
        return this.SimTime;
    }

    protected void setSimTime(long SimTime) {
        this.SimTime = SimTime;
    }

    @Override
    public abstract UnrealId getId();

    @Override
    public abstract boolean isVisible();

    @Override
    public abstract Location getLocation();

    public abstract Rotation getRotation();

    public abstract Velocity getVelocity();

    public abstract String getType();

    public abstract String getEntityClass();

    @Override
    public IWorldObjectUpdatedEvent createDisappearEvent() {
        return new ObjectDisappeared(this, this.getSimTime());
    }

    @Override
    public String toString() {
        return super.toString() + "[" + "Id = " + String.valueOf(this.getId()) + " | " + "Visible = " + String.valueOf(this.isVisible()) + " | " + "Location = " + String.valueOf(this.getLocation()) + " | " + "Rotation = " + String.valueOf(this.getRotation()) + " | " + "Velocity = " + String.valueOf(this.getVelocity()) + " | " + "Type = " + String.valueOf(this.getType()) + " | " + "EntityClass = " + String.valueOf(this.getEntityClass()) + " | " + "]";
    }

    public String toHtmlString() {
        return super.toString() + "[<br/>" + "<b>Id</b> = " + String.valueOf(this.getId()) + " <br/> " + "<b>Visible</b> = " + String.valueOf(this.isVisible()) + " <br/> " + "<b>Location</b> = " + String.valueOf(this.getLocation()) + " <br/> " + "<b>Rotation</b> = " + String.valueOf(this.getRotation()) + " <br/> " + "<b>Velocity</b> = " + String.valueOf(this.getVelocity()) + " <br/> " + "<b>Type</b> = " + String.valueOf(this.getType()) + " <br/> " + "<b>EntityClass</b> = " + String.valueOf(this.getEntityClass()) + " <br/> " + "<br/>]";
    }

    @Override
    public String toJsonLiteral() {
        return "entity( " + (this.getId() == null ? "null" : "\"" + this.getId().getStringId() + "\"") + ", " + String.valueOf(this.isVisible()) + ", " + (this.getLocation() == null ? "null" : "[" + this.getLocation().getX() + ", " + this.getLocation().getY() + ", " + this.getLocation().getZ() + "]") + ", " + (this.getRotation() == null ? "null" : "[" + this.getRotation().getPitch() + ", " + this.getRotation().getYaw() + ", " + this.getRotation().getRoll() + "]") + ", " + (this.getVelocity() == null ? "null" : "[" + this.getVelocity().getX() + ", " + this.getVelocity().getY() + ", " + this.getVelocity().getZ() + "]") + ", " + (this.getType() == null ? "null" : "\"" + this.getType() + "\"") + ", " + (this.getEntityClass() == null ? "null" : "\"" + this.getEntityClass() + "\"") + ")";
    }

    public static class EntityUpdate
    extends GBObjectUpdate
    implements ICompositeWorldObjectUpdatedEvent,
    IGBWorldObjectEvent {
        private Entity object;
        private long time;
        private ITeamId teamId;

        public EntityUpdate(Entity source, long eventTime, ITeamId teamId) {
            this.object = source;
            this.time = eventTime;
            this.teamId = teamId;
        }

        @Override
        public long getSimTime() {
            return this.time;
        }

        public IWorldObject getObject() {
            return this.object;
        }

        @Override
        public WorldObjectId getId() {
            return this.object.getId();
        }

        @Override
        public ILocalWorldObjectUpdatedEvent getLocalEvent() {
            return new EntityLocalImpl.EntityLocalUpdate((EntityLocal)this.object.getLocal(), this.time);
        }

        @Override
        public ISharedWorldObjectUpdatedEvent getSharedEvent() {
            return new EntitySharedImpl.EntitySharedUpdate((EntityShared)this.object.getShared(), this.time, this.teamId);
        }

        @Override
        public IStaticWorldObjectUpdatedEvent getStaticEvent() {
            return new EntityStaticImpl.EntityStaticUpdate((EntityStatic)this.object.getStatic(), this.time);
        }
    }

    public static class ObjectDisappeared
    implements IWorldObjectUpdatedEvent {
        private Entity obj;
        private long time;

        public ObjectDisappeared(Entity obj, long time2) {
            this.obj = obj;
            this.time = time2;
        }

        @Override
        public WorldObjectId getId() {
            return this.obj.getId();
        }

        @Override
        public long getSimTime() {
            return this.time;
        }

        @Override
        public IWorldObjectUpdateResult<IWorldObject> update(IWorldObject obj) {
            if (obj == null) {
                throw new PogamutException("Can't 'disappear' null!", (Object)this);
            }
            if (!(obj instanceof EntityMessage)) {
                throw new PogamutException("Can't update different class than EntityMessage, got class " + obj.getClass().getSimpleName() + "!", (Object)this);
            }
            EntityMessage toUpdate = (EntityMessage)obj;
            if (toUpdate.Visible) {
                toUpdate.Visible = false;
                return new IWorldObjectUpdateResult.WorldObjectUpdateResult<IWorldObject>(IWorldObjectUpdateResult.Result.UPDATED, obj);
            }
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult<IWorldObject>(IWorldObjectUpdateResult.Result.SAME, obj);
        }
    }
}

