/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import cz.cuni.amis.utils.NullCheck;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamSink
extends Thread {
    protected InputStream os = null;
    protected Logger log;
    protected String logId;
    protected Level logLevel = Level.INFO;

    public StreamSink(String name, InputStream os2) {
        this(name, os2, null);
    }

    public StreamSink(String name, InputStream os2, Logger log) {
        this(name, os2, log, null);
    }

    public StreamSink(String name, InputStream os2, Logger log, String logId) {
        super(name);
        this.log = log;
        this.logId = logId;
        this.os = os2;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public StreamSink setLogLevel(Level logLevel) {
        NullCheck.check(logLevel, "logLevel");
        this.logLevel = logLevel;
        return this;
    }

    public Logger getLog() {
        return this.log;
    }

    protected StreamSink setLog(Logger log) {
        this.log = log;
        return this;
    }

    public String getLogId() {
        return this.logId;
    }

    protected StreamSink setLogId(String logId) {
        this.logId = logId;
        return this;
    }

    protected void handleInput(String str) {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            if (this.logId != null) {
                this.log.info(this.logId + " " + str);
            } else {
                this.log.info(str);
            }
        }
    }

    @Override
    public void run() {
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.os));
        String s = null;
        try {
            while ((s = stdInput.readLine()) != null) {
                this.handleInput(s);
            }
            this.os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

