/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import java.io.OutputStream;
import java.io.Serializable;

public class StringOutputStream
extends OutputStream
implements Serializable {
    private StringBuffer buffer = new StringBuffer();
    private String resultString = null;

    public String getString() {
        if (this.resultString != null) {
            return this.resultString;
        }
        return this.buffer.toString();
    }

    @Override
    public void close() {
        this.resultString = this.buffer.toString();
        this.buffer = null;
    }

    @Override
    public void write(byte[] b) {
        this.buffer.append(this.toCharArray(b));
    }

    private char[] toCharArray(byte[] barr) {
        if (barr == null) {
            return null;
        }
        char[] carr = new char[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            carr[i] = (char)barr[i];
        }
        return carr;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("StringOutputStream.write: Parameters out of bounds.");
        }
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = b[off];
            ++off;
        }
        this.buffer.append(this.toCharArray(bytes));
    }

    @Override
    public void write(int b) {
        this.buffer.append((char)b);
    }
}

