/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.collections;

import cz.cuni.amis.utils.collections.ObservableCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class ObservableList<E>
extends ObservableCollection<E>
implements List<E> {
    protected List<E> l = null;

    public ObservableList(List<E> list) {
        super(list);
        this.l = list;
    }

    public List<E> getList() {
        return this.l;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.notifyPreAdd(c);
        boolean ret = this.l.addAll(index, c);
        this.notifyPostAdd(c);
        return ret;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.l.size(), c);
    }

    @Override
    public void clear() {
        ArrayList copy = new ArrayList(this.col);
        this.notifyPreRemove(copy);
        this.l.clear();
        this.notifyPostRemove(copy);
    }

    @Override
    public E get(int index) {
        return this.l.get(index);
    }

    @Override
    public E set(int index, E element) {
        return this.l.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        Set<E> add = Collections.singleton(element);
        this.notifyPreAdd(add);
        this.l.add(index, element);
        this.notifyPostAdd(add);
    }

    @Override
    public E remove(int index) {
        Set<E> toRem = Collections.singleton(this.l.get(index));
        this.notifyPreRemove(toRem);
        E rem = this.l.remove(index);
        this.notifyPostRemove(Collections.singleton(rem));
        return rem;
    }

    @Override
    public int indexOf(Object o) {
        return this.l.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.l.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.l.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.l.subList(fromIndex, toIndex);
    }
}

