/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Matches;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;

public class Tokenize
extends SystemFunction {
    private RegularExpression regexp;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Expression e = this.simplifyArguments(visitor);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    private void maybePrecompile(ExpressionVisitor visitor) throws XPathException {
        if (this.regexp == null) {
            try {
                this.regexp = Matches.tryToCompile(this.argument, 1, 2, visitor.getStaticContext());
            }
            catch (XPathException err) {
                err.setLocator(this);
                throw err;
            }
            if (this.regexp != null && this.regexp.matches("")) {
                err = new XPathException("The regular expression in tokenize() must not be one that matches a zero-length string");
                err.setErrorCode("FORX0003");
                err.setLocator(this);
                throw err;
            }
        }
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    public RegularExpression getCompiledRegularExpression() {
        return this.regexp;
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        AtomicValue sv = (AtomicValue)this.argument[0].evaluateItem(c);
        if (sv == null) {
            return EmptyIterator.getInstance();
        }
        CharSequence input = sv.getStringValueCS();
        if (input.length() == 0) {
            return EmptyIterator.getInstance();
        }
        RegularExpression re2 = this.regexp;
        if (re2 == null) {
            CharSequence flags;
            sv = (AtomicValue)this.argument[1].evaluateItem(c);
            CharSequence pattern = sv.getStringValueCS();
            if (this.argument.length == 2) {
                flags = "";
            } else {
                sv = (AtomicValue)this.argument[2].evaluateItem(c);
                flags = sv.getStringValueCS();
            }
            try {
                Platform platform = Configuration.getPlatform();
                int xmlVersion = c.getConfiguration().getXMLVersion();
                re2 = platform.compileRegularExpression(pattern, xmlVersion, 0, flags);
            }
            catch (XPathException err) {
                XPathException de = new XPathException(err);
                de.setErrorCode("FORX0002");
                de.setXPathContext(c);
                de.setLocator(this);
                throw de;
            }
            if (re2.matches("")) {
                err = new XPathException("The regular expression in tokenize() must not be one that matches a zero-length string");
                err.setErrorCode("FORX0003");
                err.setLocator(this);
                throw err;
            }
        }
        return re2.tokenize(input);
    }

    public static void main(String[] args) throws Exception {
        String in = args[0];
        String[] out = Pattern.compile(args[1]).split(in, 0);
        System.out.println("results");
        for (int i = 0; i < out.length; ++i) {
            System.out.println('[' + out[i] + ']');
        }
        System.out.println("end results");
    }
}

