/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.emohawk.agent;

import SteeringProperties.ObstacleAvoidanceProperties;
import SteeringProperties.WalkAlongProperties;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.Place;
import cz.cuni.amis.pogamut.emohawk.bot.impl.EmohawkBotController;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.exception.PogamutException;
import eis.eis2java.annotation.AsAction;
import eis.eis2java.annotation.AsPercept;
import eis.eis2java.translation.Filter;
import eis.eis2java.util.AllPerceptsModule;
import eis.eis2java.util.AllPerceptsProvider;
import eis.exceptions.ActException;
import eis.exceptions.EntityException;
import eis.exceptions.PerceiveException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import nl.tudelft.goal.emohawk.messages.Action;
import nl.tudelft.goal.emohawk.messages.Percept;
import nl.tudelft.goal.emohawk.messages.UnrealIdOrLocation;
import nl.tudelft.goal.unreal.messages.BotParameters;

public class EmohawkBotBehavior
extends EmohawkBotController<UT2004Bot>
implements AllPerceptsProvider {
    private Semaphore logic = new Semaphore(0, true);
    private WalkAlongProperties walkAlongProperties;
    private BotParameters parameters;
    protected AllPerceptsModule percepts;
    private BlockingQueue<Action> actions = new LinkedBlockingQueue<Action>(1);

    @Override
    public void initializeController(UT2004Bot bot) {
        super.initializeController(bot);
        IAgentLogger logger = bot.getLogger();
        UT2004BotParameters parameters = bot.getParams();
        if (parameters instanceof BotParameters) {
            this.parameters = (BotParameters)parameters;
        } else {
            this.log.warning("Provided parameters were not a subclass of UnrealGoalParameters, using defaults.");
            this.parameters = new BotParameters();
        }
        BotParameters defaults = BotParameters.getDefaults();
        this.parameters.assignDefaults(defaults);
    }

    @Override
    protected void initializeModules(UT2004Bot bot) {
        super.initializeModules(bot);
        this.steering.addObstacleAvoidanceSteering(new ObstacleAvoidanceProperties());
        this.walkAlongProperties = new WalkAlongProperties();
        this.walkAlongProperties.setDistanceFromThePartner(200);
        this.walkAlongProperties.setGiveWayToPartner(false);
        this.steering.addWalkAlongSteering(new WalkAlongProperties());
        try {
            this.percepts = new AllPerceptsModule((Object)this);
        }
        catch (EntityException e) {
            throw new PogamutException("Could not create percept module", e);
        }
    }

    @Override
    public Initialize getInitializeCommand() {
        assert (this.parameters != null);
        Initialize init = super.getInitializeCommand();
        init.setDesiredSkill(this.parameters.getSkill());
        init.setSkin(this.parameters.getSkin().getUnrealName());
        init.setTeam(this.parameters.getTeam());
        init.setShouldLeadTarget(this.parameters.shouldLeadTarget());
        init.setLocation(this.parameters.getInitialLocation());
        init.setRotation(this.parameters.getInitialRotation());
        this.bot.getLogger().setLevel(this.parameters.getLogLevel());
        return init;
    }

    @Override
    public void logic() throws PogamutException {
        super.logic();
        this.log.fine("--- Logic iteration ---");
        while (!this.actions.isEmpty()) {
            ((Action)this.actions.remove()).execute();
        }
        try {
            this.percepts.updatePercepts();
        }
        catch (PerceiveException e) {
            throw new PogamutException("Could not update percepts", e);
        }
    }

    @Override
    public void botShutdown() {
        super.botShutdown();
        this.logic.release();
    }

    @AsPercept(name="navigation")
    public String navigation() {
        if (this.steering.isNavigating()) {
            return "following";
        }
        if (this.pathExecutor.isExecuting() || this.getBackToNavGraph.isExecuting() || this.runStraight.isExecuting()) {
            return "traveling";
        }
        if (this.pathExecutor.isStuck()) {
            return "stuck";
        }
        if (this.pathExecutor.isPathUnavailable()) {
            return "path_unavailable";
        }
        if (this.pathExecutor.isTargetReached()) {
            return "destination_reached";
        }
        return "waiting";
    }

    @AsPercept(name="navPoint", multiplePercepts=true, filter=Filter.Type.ONCE)
    public List<Percept> perceptNavPoints() {
        Collection<NavPoint> navPoints = this.world.getAll(NavPoint.class).values();
        ArrayList<Percept> percepts = new ArrayList<Percept>(navPoints.size());
        for (NavPoint p : navPoints) {
            percepts.add(new Percept(p.getId(), p.getLocation(), p.getOutgoingEdges().keySet()));
        }
        return percepts;
    }

    @AsPercept(name="person", multiplePercepts=true)
    public Collection<Percept> person() {
        ArrayList<Percept> persons = new ArrayList<Percept>();
        for (Player p : this.getPlayers().getVisiblePlayers().values()) {
            persons.add(new Percept(p.getId(), p.getName(), p.getLocation(), p.getRotation(), p.getEmotLeft(), p.getEmotCenter(), p.getEmotRight()));
        }
        return persons;
    }

    @AsPercept(name="self")
    public Percept self() {
        AgentInfo info = this.getInfo();
        EmoticonType emoteLeft = EmoticonType.get(info.getSelf().getEmotLeft());
        EmoticonType emoteCenter = EmoticonType.get(info.getSelf().getEmotCenter());
        EmoticonType emoteRight = EmoticonType.get(info.getSelf().getEmotRight());
        return new Percept(new Object[]{info.getId(), info.getName(), info.getLocation(), info.getRotation(), emoteLeft, emoteCenter, emoteRight});
    }

    @AsPercept(name="emoticon", multiplePercepts=true, filter=Filter.Type.ONCE)
    public Collection<EmoticonType> emoticon() {
        return Arrays.asList(EmoticonType.values());
    }

    @AsPercept(name="place", multiplePercepts=true, filter=Filter.Type.ONCE)
    public Collection<Place> place() {
        return this.places.getPlaces();
    }

    public Map<Method, Object> getAllPercepts() {
        return this.percepts.getAllPercepts();
    }

    @AsAction(name="stop")
    public void stop() throws InterruptedException {
        this.addAction(new Action(){

            @Override
            public void execute() {
                EmohawkBotBehavior.this.steering.stopNavigation();
                EmohawkBotBehavior.this.navigation.stopNavigation();
            }
        });
    }

    @AsAction(name="runTo")
    public void runTo(UnrealIdOrLocation destination) throws InterruptedException {
        final ILocated location = this.getLocation(destination);
        this.addAction(new Action(){

            @Override
            public void execute() {
                EmohawkBotBehavior.this.steering.stopNavigation();
                if (!EmohawkBotBehavior.this.move.isRunning()) {
                    EmohawkBotBehavior.this.move.setRun();
                }
                EmohawkBotBehavior.this.navigation.navigate(location);
            }
        });
    }

    @AsAction(name="walkTo")
    public void walkTo(UnrealIdOrLocation destination) throws InterruptedException {
        final ILocated location = this.getLocation(destination);
        this.addAction(new Action(){

            @Override
            public void execute() {
                EmohawkBotBehavior.this.steering.stopNavigation();
                if (EmohawkBotBehavior.this.move.isRunning()) {
                    EmohawkBotBehavior.this.move.setWalk();
                }
                EmohawkBotBehavior.this.navigation.navigate(location);
            }
        });
    }

    private ILocated getLocation(UnrealIdOrLocation destination) {
        ILocated location = destination.isLocation() ? destination.getLocation() : (ILocated)((Object)this.world.get(destination.getId()));
        return location;
    }

    @AsAction(name="walkAlong")
    public void walkAlong(final Player partner) throws ActException, InterruptedException {
        this.addAction(new Action(){

            @Override
            public void execute() {
                EmohawkBotBehavior.this.navigation.stopNavigation();
                if (!EmohawkBotBehavior.this.move.isRunning()) {
                    EmohawkBotBehavior.this.move.setRun();
                }
                EmohawkBotBehavior.this.walkAlongProperties.setPartnerName(partner.getName());
                EmohawkBotBehavior.this.steering.setWalkAlongSteering(EmohawkBotBehavior.this.walkAlongProperties);
                EmohawkBotBehavior.this.steering.startNavigation();
            }
        });
    }

    @AsAction(name="emote")
    public void emote(final EmoticonType left, final EmoticonType center, final EmoticonType right) throws ActException, InterruptedException {
        this.addAction(new Action(){

            @Override
            public void execute() {
                EmohawkBotBehavior.this.emoticons.clearEmoticons();
                if (left == EmoticonType.NONE && center == EmoticonType.NONE && right == EmoticonType.NONE) {
                    return;
                }
                if (left == EmoticonType.NONE && center != EmoticonType.NONE && right == EmoticonType.NONE) {
                    EmohawkBotBehavior.this.emoticons.setCenterEmoticonType(center);
                    return;
                }
                if (left != EmoticonType.NONE && center == EmoticonType.NONE && right != EmoticonType.NONE) {
                    EmohawkBotBehavior.this.emoticons.setDoubleEmoticon(left, right);
                    return;
                }
                EmohawkBotBehavior.this.emoticons.setTripleEmoticon(left, center, right);
            }
        });
    }

    @AsAction(name="turn")
    public void turn(final int amount) throws ActException, InterruptedException {
        this.addAction(new Action(){

            @Override
            public void execute() {
                EmohawkBotBehavior.this.move.turnHorizontal(amount);
            }
        });
    }

    @AsAction(name="turnTo")
    public void turnTo(final ILocated location) throws ActException, InterruptedException {
        this.addAction(new Action(){

            @Override
            public void execute() {
                EmohawkBotBehavior.this.move.turnTo(location);
            }
        });
    }

    @AsAction(name="jump")
    public void jump() throws ActException, InterruptedException {
        this.addAction(new Action(){

            @Override
            public void execute() {
                EmohawkBotBehavior.this.move.jump();
            }
        });
    }

    @AsAction(name="skip")
    public void skip() throws ActException {
    }

    public void addAction(Action action) throws InterruptedException {
        this.actions.put(action);
    }
}

