/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.goal.unreal.messages;

import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import java.util.logging.Level;
import nl.tudelft.goal.unreal.messages.Parameters;
import nl.tudelft.goal.ut2004.util.Skin;
import nl.tudelft.goal.ut2004.util.Team;

public class BotParameters
extends Parameters {
    private Level logLevel;
    private Boolean shouldLeadTarget;
    private Integer skill;
    private Skin skin;

    @Override
    public void assignDefaults(IAgentParameters defaults) {
        super.assignDefaults(defaults);
        if (defaults instanceof BotParameters) {
            BotParameters parameters = (BotParameters)defaults;
            if (this.logLevel == null) {
                this.logLevel = parameters.getLogLevel();
            }
            if (this.shouldLeadTarget == null) {
                this.shouldLeadTarget = parameters.shouldLeadTarget();
            }
            if (this.skill == null) {
                this.skill = parameters.getSkill();
            }
            if (this.skin == null) {
                this.skin = parameters.getSkin();
            }
        }
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public int getSkill() {
        return this.skill;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public BotParameters setLogLevel(Level level) {
        assert (level != null);
        this.logLevel = level;
        return this;
    }

    public BotParameters setShouldLeadTarget(boolean shouldLeadTarget) {
        this.shouldLeadTarget = shouldLeadTarget;
        return this;
    }

    public BotParameters setSkill(int skill) {
        this.skill = Math.min(7, Math.max(skill, 0));
        return this;
    }

    public BotParameters setSkin(Skin skin) {
        this.skin = skin;
        return this;
    }

    public BotParameters setTeam(Team team) {
        super.setTeam(team.id());
        return this;
    }

    @Override
    public BotParameters setInitialLocation(Location location) {
        super.setInitialLocation(location);
        return this;
    }

    @Override
    public BotParameters setInitialRotation(Rotation rotation) {
        super.setInitialRotation(rotation);
        return this;
    }

    public Boolean shouldLeadTarget() {
        return this.shouldLeadTarget;
    }

    public String toString() {
        return "BotParameters [logLevel=" + this.logLevel + ", shouldLeadTarget=" + this.shouldLeadTarget + ", skill=" + this.skill + ", skin=" + (Object)((Object)this.skin) + ", getTeam()=" + this.getTeam() + ", getWorldAddress()=" + this.getWorldAddress() + ", getAgentId()=" + this.getAgentId() + "]";
    }

    public UT2004BotParameters setAgentId(String agentName) {
        super.setAgentId(new AgentId(agentName));
        return this;
    }

    public static BotParameters getDefaults() {
        BotParameters parameters = new BotParameters();
        parameters.logLevel = Level.WARNING;
        parameters.shouldLeadTarget = true;
        parameters.skill = 3;
        parameters.skin = Skin.BotB;
        return parameters;
    }
}

