/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.View;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.ViewGapStorage;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyImpl;

class ViewChildren<V extends EditorView>
extends GapList<V> {
    private static final Logger LOG = Logger.getLogger(ViewChildren.class.getName());
    private static final long serialVersionUID = 0L;
    ViewGapStorage gapStorage;

    ViewChildren(int capacity) {
        super(capacity);
    }

    int raw2Offset(int rawEndOffset) {
        return this.gapStorage == null || rawEndOffset <= this.gapStorage.offsetGapStart ? rawEndOffset : rawEndOffset - this.gapStorage.offsetGapLength;
    }

    int offset2Raw(int offset) {
        return this.gapStorage == null || offset <= this.gapStorage.offsetGapStart ? offset : offset + this.gapStorage.offsetGapLength;
    }

    int startOffset(int index) {
        return index > 0 ? this.raw2Offset(((EditorView)this.get(index - 1)).getRawEndOffset()) : 0;
    }

    int endOffset(int index) {
        return this.raw2Offset(((EditorView)this.get(index)).getRawEndOffset());
    }

    int viewIndexFirst(int offset) {
        offset = this.offset2Raw(offset);
        int last = this.size() - 1;
        int low = 0;
        int high = last;
        while (low <= high) {
            int mid = low + high >>> 1;
            EditorView view = (EditorView)this.get(mid);
            int rawEndOffset = view.getRawEndOffset();
            if (rawEndOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (rawEndOffset > offset) {
                high = mid - 1;
                continue;
            }
            while (view.getLength() == 0 && mid > 0) {
                view = (EditorView)this.get(--mid);
            }
            low = mid + 1;
            break;
        }
        return Math.min(low, last);
    }

    void moveOffsetGap(int index, int newOffsetGapStart) {
        if (this.gapStorage == null) {
            return;
        }
        int origStart = this.gapStorage.offsetGapStart;
        int shift = this.gapStorage.offsetGapLength;
        this.gapStorage.offsetGapStart = newOffsetGapStart;
        int viewCount = this.size();
        if (index == viewCount || ((EditorView)this.get(index)).getRawEndOffset() > origStart) {
            EditorView view;
            int offset;
            while (--index >= 0 && (offset = (view = (EditorView)this.get(index)).getRawEndOffset()) > origStart) {
                view.setRawEndOffset(offset - shift);
            }
        } else {
            EditorView view;
            int offset;
            while (index < viewCount && (offset = (view = (EditorView)this.get(index)).getRawEndOffset()) <= origStart) {
                view.setRawEndOffset(offset + shift);
                ++index;
            }
        }
    }

    int getLength() {
        int size = this.size();
        if (size > 0) {
            EditorView lastChildView = (EditorView)this.get(size - 1);
            return this.raw2Offset(lastChildView.getRawEndOffset());
        }
        return 0;
    }

    double raw2VisualOffset(double rawVisualOffset) {
        return this.gapStorage == null || rawVisualOffset <= this.gapStorage.visualGapStart ? rawVisualOffset : rawVisualOffset - this.gapStorage.visualGapLength;
    }

    double visualOffset2Raw(double visualOffset) {
        return this.gapStorage == null || visualOffset <= this.gapStorage.visualGapStart ? visualOffset : visualOffset + this.gapStorage.visualGapLength;
    }

    final double startVisualOffset(int index) {
        return index > 0 ? this.raw2VisualOffset(((EditorView)this.get(index - 1)).getRawEndVisualOffset()) : 0.0;
    }

    final double endVisualOffset(int index) {
        return this.raw2VisualOffset(((EditorView)this.get(index)).getRawEndVisualOffset());
    }

    final int viewIndexFirstVisual(double visualOffset, int measuredViewCount) {
        int last = measuredViewCount - 1;
        if (last == -1) {
            return -1;
        }
        visualOffset = this.visualOffset2Raw(visualOffset);
        int low = 0;
        int high = last;
        while (low <= high) {
            int mid = low + high >>> 1;
            double rawEndVisualOffset = ((EditorView)this.get(mid)).getRawEndVisualOffset();
            if (rawEndVisualOffset < visualOffset) {
                low = mid + 1;
                continue;
            }
            if (rawEndVisualOffset > visualOffset) {
                high = mid - 1;
                continue;
            }
            while (mid > 0 && ((EditorView)this.get(mid - 1)).getRawEndVisualOffset() == visualOffset) {
                --mid;
            }
            low = mid + 1;
            break;
        }
        return Math.min(low, last);
    }

    void moveVisualGap(int index, double newVisualGapStart) {
        if (this.gapStorage == null) {
            return;
        }
        this.gapStorage.visualGapStart = newVisualGapStart;
        if (index != this.gapStorage.visualGapIndex) {
            if (index < this.gapStorage.visualGapIndex) {
                for (int i = this.gapStorage.visualGapIndex - 1; i >= index; --i) {
                    EditorView view = (EditorView)this.get(i);
                    view.setRawEndVisualOffset(view.getRawEndVisualOffset() + this.gapStorage.visualGapLength);
                }
            } else {
                for (int i = this.gapStorage.visualGapIndex; i < index; ++i) {
                    EditorView view = (EditorView)this.get(i);
                    view.setRawEndVisualOffset(view.getRawEndVisualOffset() - this.gapStorage.visualGapLength);
                }
            }
            this.gapStorage.visualGapIndex = index;
        }
    }

    void checkVisualGapIfLoggable() {
        if (this.gapStorage != null && ViewHierarchyImpl.CHECK_LOG.isLoggable(Level.FINE)) {
            String error = null;
            int visualGapIndex = this.gapStorage.visualGapIndex;
            for (int i = 0; i < this.size(); ++i) {
                EditorView view = (EditorView)this.get(i);
                double rawVisualOffset = view.getRawEndVisualOffset();
                double visualOffset = this.raw2VisualOffset(rawVisualOffset);
                if (i < visualGapIndex) {
                    if (rawVisualOffset >= this.gapStorage.visualGapStart) {
                        error = "Not below visual-gap: rawVisualOffset=" + rawVisualOffset + " >= visualGapStart=" + this.gapStorage.visualGapStart;
                    }
                } else {
                    if (rawVisualOffset < this.gapStorage.visualGapStart) {
                        error = "Not above visual-gap: rawVisualOffset=" + rawVisualOffset + " < visualGapStart=" + this.gapStorage.visualGapStart;
                    }
                    if (i == visualGapIndex && visualOffset != this.gapStorage.visualGapStart) {
                        error = "visualOffset=" + visualOffset + " != gapStorage.visualGapStart=" + this.gapStorage.visualGapStart;
                    }
                }
                if (error != null) break;
            }
            if (error != null) {
                throw new IllegalStateException("gapStorage INTEGRITY ERROR!!!\n" + error);
            }
        }
    }

    void checkIntegrityIfLoggable(EditorView parent) {
        String err;
        if (this.gapStorage != null && ViewHierarchyImpl.CHECK_LOG.isLoggable(Level.FINE) && (err = this.findIntegrityError(parent)) != null) {
            throw new IllegalStateException("ViewChildren ERROR!!!\n" + err);
        }
    }

    protected String findIntegrityError(EditorView parent) {
        String err = null;
        int lastRawEndOffset = 0;
        int lastOffset = 0;
        double lastRawEndVisualOffset = 0.0;
        double lastVisualOffset = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            EditorView view = (EditorView)this.get(i);
            View p = view.getParent();
            if (err == null && p != parent) {
                err = "p=" + p + " != parent=" + parent;
            }
            int rawEndOffset = view.getRawEndOffset();
            int childStartOffset = view.getStartOffset();
            int childEndOffset = view.getEndOffset();
            double rawEndVisualOffset = view.getRawEndVisualOffset();
            double visualOffset = this.raw2VisualOffset(rawEndVisualOffset);
            if (err == null && rawEndOffset < lastRawEndOffset) {
                err = "rawEndOffset=" + rawEndOffset + " < lastRawEndOffset=" + lastRawEndOffset;
            }
            if (err == null && childStartOffset < lastOffset) {
                err = "childStartOffset=" + childStartOffset + " < lastEndOffset=" + lastOffset;
            }
            if (err == null && childEndOffset < childStartOffset) {
                err = "childEndOffset=" + childEndOffset + " < childStartOffset=" + childStartOffset;
            }
            lastOffset = childEndOffset;
            if (err == null && rawEndVisualOffset < lastRawEndVisualOffset) {
                err = "rawEndVisualOffset=" + rawEndVisualOffset + " < lastRawEndVisualOffset=" + lastRawEndVisualOffset;
            }
            if (err == null && visualOffset < lastVisualOffset) {
                err = "visualOffset=" + visualOffset + " < lastVisualOffset=" + lastVisualOffset;
            }
            if (err == null) continue;
            err = "EBVC[" + i + "]: ";
            break;
        }
        return err;
    }

    public StringBuilder appendChildrenInfo(StringBuilder sb, int indent, int importantIndex) {
        if (this.gapStorage != null) {
            sb.append("Gap: ");
            this.gapStorage.appendInfo(sb);
        }
        int viewCount = this.size();
        int digitCount = ArrayUtilities.digitCount((int)viewCount);
        int importantLastIndex = -1;
        int childImportantIndex = importantIndex == -2 ? -2 : -1;
        for (int i = 0; i < viewCount; ++i) {
            sb.append('\n');
            ArrayUtilities.appendSpaces((StringBuilder)sb, (int)indent);
            ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
            EditorView view = (EditorView)this.get(i);
            String xyInfo = this.getXYInfo(i);
            view.appendViewInfo(sb, indent, xyInfo, childImportantIndex);
            boolean appendDots = false;
            if (i == 4) {
                if (importantIndex == -1) {
                    if (i < viewCount - 6) {
                        appendDots = true;
                        i = viewCount - 6;
                    }
                } else if (importantIndex >= 0) {
                    importantLastIndex = importantIndex + 3;
                    if (i < (importantIndex -= 3) - 1) {
                        appendDots = true;
                        i = importantIndex - 1;
                    }
                }
            } else if (i == importantLastIndex && i < viewCount - 6) {
                appendDots = true;
                i = viewCount - 6;
            }
            if (!appendDots) continue;
            sb.append('\n');
            ArrayUtilities.appendSpaces((StringBuilder)sb, (int)indent);
            sb.append("...");
        }
        return sb;
    }

    protected String getXYInfo(int index) {
        return "";
    }
}

