/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.modules.editor.lib2.highlighting.CompoundAttributes;
import org.netbeans.modules.editor.lib2.highlighting.HighlightItem;
import org.netbeans.modules.editor.lib2.highlighting.HighlightsList;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;

class ViewPaintHighlights
implements HighlightsSequence {
    private final HighlightsList paintHighlights;
    private int phIndex;
    private int phStartOffset;
    private int phEndOffset;
    private AttributeSet phAttrs;
    private int viewEndOffset;
    private HighlightItem[] vaItems;
    private int vaIndex;
    private int vaEndOffset;
    private AttributeSet vaAttrs;
    private int offsetDiff;
    private int hiStartOffset;
    private int hiEndOffset;
    private AttributeSet hiAttrs;

    ViewPaintHighlights(HighlightsList paintHighlights) {
        this.paintHighlights = paintHighlights;
        this.updatePH(0);
    }

    void reset(EditorView view, int shift) {
        assert (shift >= 0) : "shift=" + shift + " < 0";
        int viewStartOffset = view.getStartOffset();
        this.viewEndOffset = viewStartOffset + view.getLength();
        AttributeSet attrs = view.getAttributes();
        int startOffset = viewStartOffset + shift;
        if (ViewUtils.isCompoundAttributes(attrs)) {
            CompoundAttributes cAttrs = (CompoundAttributes)attrs;
            this.offsetDiff = viewStartOffset - cAttrs.startOffset();
            this.vaItems = cAttrs.highlightItems();
            this.vaIndex = shift == 0 ? 0 : this.findCAHIndex(startOffset);
            HighlightItem cahItem = this.vaItems[this.vaIndex];
            this.vaEndOffset = cahItem.getEndOffset() + this.offsetDiff;
            this.vaAttrs = cahItem.getAttributes();
        } else {
            this.vaItems = null;
            this.vaIndex = -1;
            this.vaEndOffset = this.viewEndOffset;
            this.vaAttrs = attrs == null ? null : attrs;
        }
        if (startOffset < this.phStartOffset) {
            this.updatePH(this.findPHIndex(startOffset));
        } else if (startOffset >= this.phEndOffset) {
            this.fetchNextPH();
            if (startOffset >= this.phEndOffset) {
                this.updatePH(this.findPHIndex(startOffset));
            }
        }
        this.hiStartOffset = this.hiEndOffset = startOffset;
    }

    @Override
    public boolean moveNext() {
        if (this.hiEndOffset >= this.viewEndOffset) {
            return false;
        }
        if (this.hiEndOffset >= this.phEndOffset) {
            this.fetchNextPH();
        }
        if (this.hiEndOffset >= this.vaEndOffset) {
            ++this.vaIndex;
            if (this.vaIndex >= this.vaItems.length) {
                return false;
            }
            HighlightItem hItem = this.vaItems[this.vaIndex];
            this.vaEndOffset = hItem.getEndOffset() + this.offsetDiff;
            this.vaAttrs = hItem.getAttributes();
        }
        this.hiStartOffset = this.hiEndOffset;
        this.hiEndOffset = this.phEndOffset < this.vaEndOffset ? Math.min(this.phEndOffset, this.viewEndOffset) : this.vaEndOffset;
        this.hiAttrs = this.vaAttrs;
        if (this.phAttrs != null) {
            this.hiAttrs = this.hiAttrs != null ? AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{this.phAttrs, this.hiAttrs}) : this.phAttrs;
        }
        return true;
    }

    @Override
    public int getStartOffset() {
        return this.hiStartOffset;
    }

    @Override
    public int getEndOffset() {
        return this.hiEndOffset;
    }

    @Override
    public AttributeSet getAttributes() {
        return this.hiAttrs;
    }

    private int findCAHIndex(int offset) {
        int low = 0;
        int high = this.vaItems.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int hEndOffset = this.vaItems[mid].getEndOffset() + this.offsetDiff;
            if (hEndOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (hEndOffset > offset) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
            break;
        }
        return low;
    }

    private void updatePH(int index) {
        this.phIndex = index;
        this.phStartOffset = this.phIndex > 0 ? this.paintHighlights.get(this.phIndex - 1).getEndOffset() : this.paintHighlights.startOffset();
        HighlightItem phItem = this.paintHighlights.get(this.phIndex);
        this.phEndOffset = phItem.getEndOffset();
        this.phAttrs = phItem.getAttributes();
    }

    private void fetchNextPH() {
        this.phStartOffset = this.phEndOffset;
        ++this.phIndex;
        HighlightItem hItem = this.paintHighlights.get(this.phIndex);
        this.phEndOffset = hItem.getEndOffset();
        this.phAttrs = hItem.getAttributes();
    }

    private int findPHIndex(int offset) {
        int low = 0;
        int high = this.paintHighlights.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int hEndOffset = this.paintHighlights.get(mid).getEndOffset();
            if (hEndOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (hEndOffset > offset) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
            break;
        }
        return low;
    }
}

