/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.url;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Parser {
    private static final Pattern URL_PATTERN = Pattern.compile("(https|http|ftp):[0-9a-zA-Z/.?%+_~=\\\\&$\\-#,:]*");
    private static final Pattern CHARSET = Pattern.compile("charset=([^;]+)(;|$)", 8);

    private Parser() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Iterable<int[]> recognizeURLs(CharSequence text) {
        LinkedList<int[]> result = new LinkedList<int[]>();
        int state = 0;
        int lastURLStart = -1;
        block11: for (int cntr = 0; cntr < text.length(); ++cntr) {
            char ch = text.charAt(cntr);
            if (state == 6) {
                if (Character.isLetterOrDigit(ch)) continue;
                switch (ch) {
                    case '#': 
                    case '$': 
                    case '%': 
                    case '&': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '=': 
                    case '?': 
                    case '\\': 
                    case '_': 
                    case '~': {
                        break;
                    }
                    default: {
                        assert (lastURLStart != -1);
                        result.add(new int[]{lastURLStart, cntr});
                        lastURLStart = -1;
                        state = 0;
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case 'h': {
                    if (state != 0) break;
                    lastURLStart = cntr;
                    state = 1;
                    continue block11;
                }
                case 't': {
                    if (state == 1) {
                        state = 2;
                        continue block11;
                    }
                    if (state == 2) {
                        state = 3;
                        continue block11;
                    }
                    if (state != 7) break;
                    state = 8;
                    continue block11;
                }
                case 'f': {
                    if (state != 0) break;
                    lastURLStart = cntr;
                    state = 7;
                    continue block11;
                }
                case 'p': {
                    if (state == 3) {
                        state = 4;
                        continue block11;
                    }
                    if (state != 8) break;
                    state = 5;
                    continue block11;
                }
                case 's': {
                    if (state != 4) break;
                    state = 5;
                    continue block11;
                }
                case ':': {
                    if (state != 4 && state != 5) break;
                    state = 6;
                    continue block11;
                }
            }
            state = 0;
            lastURLStart = -1;
        }
        if (lastURLStart != -1 && state == 6) {
            result.add(new int[]{lastURLStart, text.length()});
        }
        return result;
    }

    public static Iterable<int[]> recognizeURLsREBased(CharSequence text) {
        Matcher m = URL_PATTERN.matcher(text);
        LinkedList<int[]> result = new LinkedList<int[]>();
        while (m.find()) {
            result.add(new int[]{m.start(), m.start() + m.group(0).length()});
        }
        return result;
    }

    public static String decodeContentType(String contentType) {
        Matcher m;
        if (contentType == null) {
            return null;
        }
        if (contentType != null && (m = CHARSET.matcher(contentType)).find()) {
            return m.group(1);
        }
        return null;
    }
}

