/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.AssignComments;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.TranslateIdentifier;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.netbeans.modules.java.source.query.CommentSet;
import org.netbeans.modules.java.source.save.DiffContext;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public final class GeneratorUtilities {
    private WorkingCopy copy;
    private static ClassMemberComparator CLASS_MEMBER_COMPARATOR = new ClassMemberComparator();

    private GeneratorUtilities(WorkingCopy copy) {
        this.copy = copy;
    }

    public static GeneratorUtilities get(WorkingCopy copy) {
        return new GeneratorUtilities(copy);
    }

    public ClassTree insertClassMember(ClassTree clazz, Tree member) {
        assert (clazz != null && member != null);
        int idx = 0;
        GuardedDocument gdoc = null;
        SourcePositions sp = null;
        try {
            Document doc = this.copy.getDocument();
            if (doc == null) {
                DataObject data = DataObject.find((FileObject)this.copy.getFileObject());
                EditorCookie cookie = (EditorCookie)data.getCookie(EditorCookie.class);
                doc = cookie.openDocument();
            }
            if (doc != null && doc instanceof GuardedDocument) {
                gdoc = (GuardedDocument)doc;
                sp = this.copy.getTrees().getSourcePositions();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        TreeUtilities utils = this.copy.getTreeUtilities();
        CompilationUnitTree compilationUnit = this.copy.getCompilationUnit();
        Tree lastMember = null;
        for (Tree tree : clazz.getMembers()) {
            TreePath path = TreePath.getPath(compilationUnit, tree);
            if (!(path != null && utils.isSynthetic(path) || CLASS_MEMBER_COMPARATOR.compare(member, tree) >= 0)) {
                if (gdoc == null) break;
                int pos = (int)(lastMember != null ? sp.getEndPosition(compilationUnit, lastMember) : sp.getStartPosition(compilationUnit, clazz));
                pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
                if ((long)pos <= sp.getStartPosition(compilationUnit, tree)) break;
            }
            ++idx;
            lastMember = tree;
        }
        return this.copy.getTreeMaker().insertClassMember(clazz, idx, member);
    }

    public ClassTree insertClassMembers(ClassTree clazz, Iterable<? extends Tree> members) {
        assert (members != null);
        for (Tree tree : members) {
            clazz = this.insertClassMember(clazz, tree);
        }
        return clazz;
    }

    public List<? extends MethodTree> createAllAbstractMethodImplementations(TypeElement clazz) {
        return this.createAbstractMethodImplementations(clazz, this.copy.getElementUtilities().findUnimplementedMethods(clazz));
    }

    public List<? extends MethodTree> createAbstractMethodImplementations(TypeElement clazz, Iterable<? extends ExecutableElement> methods) {
        assert (methods != null);
        ArrayList<MethodTree> ret = new ArrayList<MethodTree>();
        for (ExecutableElement executableElement : methods) {
            ret.add(this.createAbstractMethodImplementation(clazz, executableElement));
        }
        this.tagFirst(ret);
        return ret;
    }

    public MethodTree createAbstractMethodImplementation(TypeElement clazz, ExecutableElement method) {
        assert (clazz != null && method != null);
        return this.createMethod(method, (DeclaredType)clazz.asType());
    }

    public List<? extends MethodTree> createOverridingMethods(TypeElement clazz, Iterable<? extends ExecutableElement> methods) {
        assert (methods != null);
        ArrayList<MethodTree> ret = new ArrayList<MethodTree>();
        for (ExecutableElement executableElement : methods) {
            ret.add(this.createOverridingMethod(clazz, executableElement));
        }
        this.tagFirst(ret);
        return ret;
    }

    public MethodTree createOverridingMethod(TypeElement clazz, ExecutableElement method) {
        assert (clazz != null && method != null);
        return this.createMethod(method, (DeclaredType)clazz.asType());
    }

    public MethodTree createMethod(DeclaredType asMemberOf, ExecutableElement method) {
        TreeMaker make = this.copy.getTreeMaker();
        Set<Modifier> mods = method.getModifiers();
        EnumSet<Modifier> flags = mods.isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(mods);
        flags.remove((Object)Modifier.ABSTRACT);
        flags.remove((Object)Modifier.NATIVE);
        ExecutableType et = (ExecutableType)method.asType();
        try {
            et = (ExecutableType)this.copy.getTypes().asMemberOf(asMemberOf, method);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList<TypeParameterTree> typeParams = new ArrayList<TypeParameterTree>();
        for (TypeVariable typeVariable : et.getTypeVariables()) {
            ArrayList<ExpressionTree> bounds = new ArrayList<ExpressionTree>();
            TypeMirror bound = typeVariable.getUpperBound();
            if (bound.getKind() != TypeKind.NULL) {
                if (bound.getKind() == TypeKind.DECLARED) {
                    Symbol.ClassSymbol boundSymbol = (Symbol.ClassSymbol)((DeclaredType)bound).asElement();
                    if (boundSymbol.getSimpleName().length() == 0 && (boundSymbol.flags() & 0x1000000L) != 0L) {
                        bounds.add((ExpressionTree)make.Type(boundSymbol.getSuperclass()));
                        for (Type iface : boundSymbol.getInterfaces()) {
                            bounds.add((ExpressionTree)make.Type(iface));
                        }
                    } else if (!boundSymbol.getQualifiedName().contentEquals("java.lang.Object")) {
                        bounds.add((ExpressionTree)make.Type(bound));
                    }
                } else {
                    bounds.add((ExpressionTree)make.Type(bound));
                }
            }
            typeParams.add(make.TypeParameter(typeVariable.asElement().getSimpleName(), bounds));
        }
        Tree returnType = make.Type(et.getReturnType());
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
        boolean isVarArgs = method.isVarArgs();
        Iterator<? extends VariableElement> formArgNames = method.getParameters().iterator();
        Iterator<? extends TypeMirror> formArgTypes = et.getParameterTypes().iterator();
        ModifiersTree parameterModifiers = make.Modifiers(EnumSet.noneOf(Modifier.class));
        while (formArgNames.hasNext() && formArgTypes.hasNext()) {
            VariableElement formArgName = formArgNames.next();
            TypeMirror formArgType = formArgTypes.next();
            if (isVarArgs && !formArgNames.hasNext()) {
                parameterModifiers = make.Modifiers(0x400000000L, Collections.emptyList());
            }
            arrayList.add(make.Variable(parameterModifiers, formArgName.getSimpleName(), this.resolveWildcard(formArgType), null));
        }
        ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
        for (TypeMirror typeMirror : et.getThrownTypes()) {
            throwsList.add((ExpressionTree)make.Type(typeMirror));
        }
        ModifiersTree mt = make.Modifiers(flags, Collections.emptyList());
        return make.Method(mt, (CharSequence)method.getSimpleName(), returnType, typeParams, arrayList, throwsList, "{}", null);
    }

    public MethodTree createConstructor(TypeElement clazz, Iterable<? extends VariableElement> fields, ExecutableElement constructor) {
        assert (clazz != null && fields != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(clazz.getKind() == ElementKind.ENUM ? Modifier.PRIVATE : Modifier.PUBLIC);
        ArrayList<VariableTree> parameters = new ArrayList<VariableTree>();
        LinkedList<ExpressionStatementTree> statements = new LinkedList<ExpressionStatementTree>();
        ModifiersTree parameterModifiers = make.Modifiers(EnumSet.noneOf(Modifier.class));
        LinkedList<ExpressionTree> throwsList = new LinkedList<ExpressionTree>();
        LinkedList<TypeParameterTree> typeParams = new LinkedList<TypeParameterTree>();
        for (VariableElement variableElement : fields) {
            TypeMirror typeMirror = this.copy.getTypes().asMemberOf((DeclaredType)clazz.asType(), variableElement);
            parameters.add(make.Variable(parameterModifiers, variableElement.getSimpleName(), make.Type(typeMirror), null));
            statements.add(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)make.Identifier("this"), variableElement.getSimpleName()), make.Identifier(variableElement.getSimpleName()))));
        }
        if (constructor != null) {
            ExecutableType constructorType;
            ExecutableType executableType = constructorType = clazz.getSuperclass().getKind() == TypeKind.DECLARED ? (ExecutableType)this.copy.getTypes().asMemberOf((DeclaredType)clazz.getSuperclass(), constructor) : null;
            if (!constructor.getParameters().isEmpty()) {
                Iterator<? extends TypeMirror> parameterTypes;
                ArrayList<IdentifierTree> arrayList = new ArrayList<IdentifierTree>();
                Iterator<? extends VariableElement> iterator = constructor.getParameters().iterator();
                Iterator<? extends TypeMirror> iterator2 = parameterTypes = constructorType != null ? constructorType.getParameterTypes().iterator() : null;
                while (iterator.hasNext()) {
                    VariableElement ve = iterator.next();
                    javax.lang.model.element.Name name = ve.getSimpleName();
                    TypeMirror type = parameterTypes != null ? parameterTypes.next() : ve.asType();
                    parameters.add(make.Variable(parameterModifiers, name, make.Type(type), null));
                    arrayList.add(make.Identifier(name));
                }
                statements.addFirst(make.ExpressionStatement(make.MethodInvocation(Collections.emptyList(), make.Identifier("super"), arrayList)));
            }
            constructorType = constructorType != null ? constructorType : (ExecutableType)constructor.asType();
            for (TypeMirror typeMirror : constructorType.getThrownTypes()) {
                throwsList.add((ExpressionTree)make.Type(typeMirror));
            }
            for (TypeParameterElement typeParameterElement : constructor.getTypeParameters()) {
                LinkedList<ExpressionTree> boundsList = new LinkedList<ExpressionTree>();
                for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                    boundsList.add((ExpressionTree)make.Type(typeMirror));
                }
                typeParams.add(make.TypeParameter(typeParameterElement.getSimpleName(), boundsList));
            }
        }
        BlockTree body = make.Block(statements, false);
        return make.Method(make.Modifiers(mods), "<init>", null, typeParams, parameters, throwsList, body, null, constructor != null ? constructor.isVarArgs() : false);
    }

    public MethodTree createConstructor(ClassTree clazz, Iterable<? extends VariableTree> fields) {
        assert (clazz != null && fields != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(this.copy.getTreeUtilities().isEnum(clazz) ? Modifier.PRIVATE : Modifier.PUBLIC);
        ArrayList<VariableTree> parameters = new ArrayList<VariableTree>();
        ArrayList<ExpressionStatementTree> statements = new ArrayList<ExpressionStatementTree>();
        ModifiersTree parameterModifiers = make.Modifiers(EnumSet.noneOf(Modifier.class));
        for (VariableTree variableTree : fields) {
            parameters.add(make.Variable(parameterModifiers, variableTree.getName(), variableTree.getType(), null));
            statements.add(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)make.Identifier("this"), variableTree.getName()), make.Identifier(variableTree.getName()))));
        }
        BlockTree body = make.Block(statements, false);
        return make.Method(make.Modifiers(mods), (CharSequence)"<init>", null, Collections.emptyList(), parameters, Collections.emptyList(), body, null);
    }

    public MethodTree createGetter(TypeElement clazz, VariableElement field) {
        assert (clazz != null && field != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        if (field.getModifiers().contains((Object)Modifier.STATIC)) {
            mods.add(Modifier.STATIC);
        }
        javax.lang.model.element.Name name = field.getSimpleName();
        assert (name.length() > 0);
        TypeMirror type = this.copy.getTypes().asMemberOf((DeclaredType)clazz.asType(), field);
        StringBuilder sb = GeneratorUtilities.getCapitalizedName(name);
        sb.insert(0, type.getKind() == TypeKind.BOOLEAN ? "is" : "get");
        BlockTree body = make.Block(Collections.singletonList(make.Return(make.Identifier(name))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)sb, make.Type(type), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
    }

    public MethodTree createGetter(VariableTree field) {
        assert (field != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        if (field.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
            mods.add(Modifier.STATIC);
        }
        javax.lang.model.element.Name name = field.getName();
        assert (name.length() > 0);
        Tree type = field.getType();
        StringBuilder sb = GeneratorUtilities.getCapitalizedName(name);
        sb.insert(0, type.getKind() == Tree.Kind.PRIMITIVE_TYPE && ((PrimitiveTypeTree)type).getPrimitiveTypeKind() == TypeKind.BOOLEAN ? "is" : "get");
        BlockTree body = make.Block(Collections.singletonList(make.Return(make.Identifier(name))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)sb, type, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
    }

    public MethodTree createSetter(TypeElement clazz, VariableElement field) {
        assert (clazz != null && field != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        boolean isStatic = field.getModifiers().contains((Object)Modifier.STATIC);
        if (isStatic) {
            mods.add(Modifier.STATIC);
        }
        javax.lang.model.element.Name name = field.getSimpleName();
        assert (name.length() > 0);
        TypeMirror type = this.copy.getTypes().asMemberOf((DeclaredType)clazz.asType(), field);
        StringBuilder sb = GeneratorUtilities.getCapitalizedName(name);
        sb.insert(0, "set");
        List<VariableTree> params = Collections.singletonList(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), name, make.Type(type), null));
        BlockTree body = make.Block(Collections.singletonList(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)(isStatic ? make.Identifier(field.getEnclosingElement().getSimpleName()) : make.Identifier("this")), name), make.Identifier(name)))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)sb, make.Type(this.copy.getTypes().getNoType(TypeKind.VOID)), Collections.emptyList(), params, Collections.emptyList(), body, null);
    }

    public MethodTree createSetter(ClassTree clazz, VariableTree field) {
        assert (clazz != null && field != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        boolean isStatic = field.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        if (isStatic) {
            mods.add(Modifier.STATIC);
        }
        javax.lang.model.element.Name name = field.getName();
        assert (name.length() > 0);
        StringBuilder sb = GeneratorUtilities.getCapitalizedName(name);
        sb.insert(0, "set");
        List<VariableTree> params = Collections.singletonList(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), name, field.getType(), null));
        BlockTree body = make.Block(Collections.singletonList(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)(isStatic ? make.Identifier(clazz.getSimpleName()) : make.Identifier("this")), name), make.Identifier(name)))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)sb, make.Type(this.copy.getTypes().getNoType(TypeKind.VOID)), Collections.emptyList(), params, Collections.emptyList(), body, null);
    }

    /*
     * WARNING - void declaration
     */
    public CompilationUnitTree addImports(CompilationUnitTree cut, Set<? extends Element> toImport) {
        PackageElement pkg;
        assert (cut != null && toImport != null && toImport.size() > 0);
        ArrayList<? extends Element> elementsToImport = new ArrayList<Element>(toImport);
        Trees trees = this.copy.getTrees();
        Elements elements = this.copy.getElements();
        ElementUtilities elementUtilities = this.copy.getElementUtilities();
        CodeStyle cs = DiffContext.getCodeStyle(this.copy);
        int treshold = cs.countForUsingStarImport();
        int staticTreshold = cs.countForUsingStaticStarImport();
        LinkedHashMap<PackageElement, Integer> pkgCounts = new LinkedHashMap<PackageElement, Integer>();
        pkgCounts.put(elements.getPackageElement("java.lang"), -2);
        ExpressionTree packageName = cut.getPackageName();
        PackageElement packageElement = pkg = packageName != null ? (PackageElement)trees.getElement(TreePath.getPath(cut, (Tree)packageName)) : null;
        if (pkg == null && packageName != null) {
            pkg = elements.getPackageElement(elements.getName(packageName.toString()));
        }
        if (pkg == null) {
            pkg = elements.getPackageElement(elements.getName(""));
        }
        pkgCounts.put(pkg, -2);
        LinkedHashMap<TypeElement, Integer> typeCounts = new LinkedHashMap<TypeElement, Integer>();
        Scope scope = trees.getScope(new TreePath(cut));
        Scope.StarImportScope importScope = new Scope.StarImportScope((Symbol)((Object)pkg));
        if (((JCTree.JCCompilationUnit)cut).starImportScope != null) {
            importScope.importAll(((JCTree.JCCompilationUnit)cut).starImportScope);
        }
        for (Element element : elementsToImport) {
            Integer cnt;
            boolean bl = false;
            Element el = null;
            switch (element.getKind()) {
                case PACKAGE: {
                    el = element;
                    break;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    if (element.getEnclosingElement().getKind() != ElementKind.PACKAGE) break;
                    el = element.getEnclosingElement();
                    break;
                }
                case METHOD: 
                case ENUM_CONSTANT: 
                case FIELD: {
                    bl = true;
                    el = element.getEnclosingElement();
                    assert (element.getModifiers().contains((Object)Modifier.STATIC) && trees.isAccessible(scope, element, (DeclaredType)el.asType())) : "Only static accessible members could be imported";
                    break;
                }
                default: {
                    assert (false) : "Illegal element kind: " + (Object)((Object)element.getKind());
                    break;
                }
            }
            if (el == null) continue;
            Integer n = cnt = bl ? (Integer)typeCounts.get((TypeElement)el) : (Integer)pkgCounts.get((PackageElement)el);
            if (cnt == null) {
                cnt = 0;
            }
            if (cnt >= 0) {
                if (el == element) {
                    cnt = -1;
                } else {
                    Integer n2 = cnt;
                    Integer n3 = cnt = Integer.valueOf(cnt + 1);
                    if (bl) {
                        if (cnt >= staticTreshold) {
                            cnt = -1;
                        }
                    } else if (cnt >= treshold || GeneratorUtilities.checkPackagesForStarImport(((PackageElement)el).getQualifiedName().toString(), cs)) {
                        cnt = -1;
                    }
                }
            }
            if (bl) {
                typeCounts.put((TypeElement)el, cnt);
                continue;
            }
            pkgCounts.put((PackageElement)el, cnt);
        }
        ArrayList<? extends ImportTree> imports = new ArrayList<ImportTree>(cut.getImports());
        for (ImportTree importTree : imports) {
            Integer cnt;
            Element e = this.getImportedElement(cut, importTree);
            Element el = importTree.isStatic() ? (e.getKind().isClass() || e.getKind().isInterface() ? e : elementUtilities.enclosingTypeElement(e)) : (e.getKind() == ElementKind.PACKAGE ? e : ((e.getKind().isClass() || e.getKind().isInterface()) && e.getEnclosingElement().getKind() == ElementKind.PACKAGE ? e.getEnclosingElement() : null));
            if (el == null || (cnt = importTree.isStatic() ? (Integer)typeCounts.get((TypeElement)el) : (Integer)pkgCounts.get((PackageElement)el)) == null) continue;
            if (el == e) {
                cnt = -2;
            } else if (cnt >= 0) {
                Integer n = cnt;
                Integer n4 = cnt = Integer.valueOf(cnt + 1);
                if (importTree.isStatic() ? cnt >= staticTreshold : cnt >= treshold) {
                    cnt = -1;
                }
            }
            if (importTree.isStatic()) {
                typeCounts.put((TypeElement)el, cnt);
                continue;
            }
            pkgCounts.put((PackageElement)el, cnt);
        }
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        Object var18_23 = null;
        for (Map.Entry entry : pkgCounts.entrySet()) {
            if ((Integer)entry.getValue() != -1) continue;
            for (Element element : ((PackageElement)entry.getKey()).getEnclosedElements()) {
                void var18_24;
                if (!element.getKind().isClass() && !element.getKind().isInterface()) continue;
                Scope.Entry starEntry = importScope.lookup((Name)element.getSimpleName());
                if (starEntry.scope == null) continue;
                TypeElement te = null;
                for (Element element2 : elementsToImport) {
                    if (!element2.getKind().isClass() && !element2.getKind().isInterface() || element.getSimpleName() != element2.getSimpleName()) continue;
                    te = (TypeElement)element2;
                    break;
                }
                if (te != null) {
                    hashSet.add(te);
                    continue;
                }
                if (var18_24 == null) {
                    Map<javax.lang.model.element.Name, TypeElement> map = this.getUsedTypes(cut);
                }
                if ((te = (TypeElement)var18_24.get(element.getSimpleName())) == null) continue;
                elementsToImport.add(te);
                hashSet.add(te);
            }
            importScope.importAll(((Symbol)entry.getKey()).members());
        }
        ImportsComparator comparator = new ImportsComparator(cs);
        Collections.sort(elementsToImport, comparator);
        TreeMaker make = this.copy.getTreeMaker();
        int currentToImport = elementsToImport.size() - 1;
        int n = imports.size() - 1;
        while (currentToImport >= 0) {
            void var22_36;
            boolean isStar;
            void var26_46;
            Integer n5;
            Element currentToImportElement = elementsToImport.get(currentToImport);
            boolean isStatic = false;
            Element el = null;
            switch (currentToImportElement.getKind()) {
                case PACKAGE: {
                    el = currentToImportElement;
                    break;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    if (currentToImportElement.getEnclosingElement().getKind() != ElementKind.PACKAGE) break;
                    el = currentToImportElement.getEnclosingElement();
                    break;
                }
                case METHOD: 
                case ENUM_CONSTANT: 
                case FIELD: {
                    isStatic = true;
                    el = currentToImportElement.getEnclosingElement();
                }
            }
            Integer n6 = el == null ? Integer.valueOf(0) : (n5 = isStatic ? (Integer)typeCounts.get((TypeElement)el) : (Integer)pkgCounts.get((PackageElement)el));
            if (hashSet.contains(currentToImportElement)) {
                Integer n7 = 0;
            }
            if (var26_46.intValue() == -2) {
                --currentToImport;
                continue;
            }
            if (var26_46.intValue() == -1) {
                currentToImportElement = el;
                if (isStatic) {
                    typeCounts.put((TypeElement)el, -2);
                } else {
                    pkgCounts.put((PackageElement)el, -2);
                }
            }
            boolean bl = isStar = currentToImportElement.getKind() == ElementKind.PACKAGE || isStatic && (currentToImportElement.getKind().isClass() || currentToImportElement.getKind().isInterface());
            while (var22_36 >= 0) {
                ImportTree imp = (ImportTree)imports.get((int)var22_36);
                Element impElement = this.getImportedElement(cut, imp);
                Element element = imp.isStatic() ? (impElement.getKind().isClass() || impElement.getKind().isInterface() ? impElement : elementUtilities.enclosingTypeElement(impElement)) : (impElement.getKind() == ElementKind.PACKAGE ? impElement : (el = (impElement.getKind().isClass() || impElement.getKind().isInterface()) && impElement.getEnclosingElement().getKind() == ElementKind.PACKAGE ? impElement.getEnclosingElement() : null));
                if (isStatic == imp.isStatic() && (currentToImportElement == impElement || isStar && currentToImportElement == el)) {
                    imports.remove((int)var22_36);
                } else if (comparator.compare(currentToImportElement, imp) > 0) break;
                --var22_36;
            }
            ExpressionTree qualIdent = this.qualIdentFor(currentToImportElement);
            if (isStar) {
                qualIdent = make.MemberSelect(qualIdent, elements.getName("*"));
            }
            imports.add((int)(var22_36 + true), make.Import(qualIdent, isStatic));
            --currentToImport;
        }
        return make.CompilationUnit(cut.getPackageAnnotations(), cut.getPackageName(), imports, cut.getTypeDecls(), cut.getSourceFile());
    }

    public <T extends Tree> T importFQNs(T original) {
        TranslateIdentifier translator = new TranslateIdentifier(this.copy);
        return (T)translator.translate(original);
    }

    public <T extends Tree> T importComments(T original, CompilationUnitTree cut) {
        return GeneratorUtilities.importComments(this.copy, original, cut);
    }

    static <T extends Tree> T importComments(CompilationInfo info, T original, CompilationUnitTree cut) {
        try {
            JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)cut;
            TokenSequence seq = ((SourceFileObject)unit.getSourceFile()).getTokenHierarchy().tokenSequence(JavaTokenId.language());
            TreePath tp = TreePath.getPath(cut, original);
            T toMap = tp != null && original.getKind() != Tree.Kind.COMPILATION_UNIT ? tp.getParentPath().getLeaf() : original;
            AssignComments translator = new AssignComments(info, original, false, (TokenSequence<JavaTokenId>)seq, unit);
            translator.scan(toMap, null);
            return original;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return original;
        }
    }

    public void copyComments(Tree source, Tree target, boolean preceding) {
        CommentHandlerService handler = CommentHandlerService.instance(this.copy.impl.getJavacTask().getContext());
        CommentSetImpl s = handler.getComments(source);
        TreeUtilities.ensureCommentsMapped(this.copy, source, s);
        CommentSetImpl t = handler.getComments(target);
        if (preceding) {
            t.addComments(CommentSet.RelativePosition.PRECEDING, s.getComments(CommentSet.RelativePosition.PRECEDING));
        } else {
            t.addComments(CommentSet.RelativePosition.INLINE, s.getComments(CommentSet.RelativePosition.INLINE));
            t.addComments(CommentSet.RelativePosition.TRAILING, s.getComments(CommentSet.RelativePosition.TRAILING));
        }
    }

    private MethodTree createMethod(ExecutableElement element, DeclaredType type) {
        BlockTree body;
        TreeMaker make = this.copy.getTreeMaker();
        boolean isAbstract = element.getModifiers().contains((Object)Modifier.ABSTRACT);
        if (isAbstract) {
            ArrayList<ThrowTree> blockStatements = new ArrayList<ThrowTree>();
            TypeElement uoe = this.copy.getElements().getTypeElement("java.lang.UnsupportedOperationException");
            if (uoe != null) {
                NewClassTree newClassTree = make.NewClass(null, Collections.emptyList(), make.QualIdent(uoe), Collections.singletonList(make.Literal("Not supported yet.")), null);
                blockStatements.add(make.Throw(newClassTree));
            }
            body = make.Block(blockStatements, false);
        } else {
            ArrayList<IdentifierTree> arguments = new ArrayList<IdentifierTree>();
            for (VariableElement variableElement : element.getParameters()) {
                arguments.add(make.Identifier(variableElement.getSimpleName()));
            }
            MethodInvocationTree inv = make.MethodInvocation(Collections.emptyList(), make.MemberSelect((ExpressionTree)make.Identifier("super"), element.getSimpleName()), arguments);
            StatementTree statementTree = this.copy.getTypes().getNoType(TypeKind.VOID) == element.getReturnType() ? make.ExpressionStatement(inv) : make.Return(inv);
            body = make.Block(Collections.singletonList(statementTree), false);
        }
        MethodTree prototype = this.createMethod(type, element);
        ModifiersTree mt = prototype.getModifiers();
        if (GeneratorUtilities.supportsOverride(this.copy) && this.copy.getSourceVersion().compareTo(SourceVersion.RELEASE_5) >= 0) {
            boolean bl;
            boolean bl2 = true;
            if (this.copy.getSourceVersion().compareTo(SourceVersion.RELEASE_5) == 0) {
                boolean bl3 = bl = !element.getEnclosingElement().getKind().isInterface();
            }
            if (bl) {
                mt = make.addModifiersAnnotation(prototype.getModifiers(), make.Annotation(make.Identifier("Override"), Collections.emptyList()));
            }
        }
        return make.Method(mt, (CharSequence)prototype.getName(), prototype.getReturnType(), prototype.getTypeParameters(), prototype.getParameters(), prototype.getThrows(), body, null);
    }

    private static boolean supportsOverride(CompilationInfo info) {
        return info.getElements().getTypeElement("java.lang.Override") != null;
    }

    private static StringBuilder getCapitalizedName(CharSequence cs) {
        StringBuilder sb = new StringBuilder(cs);
        while (sb.length() > 1 && sb.charAt(0) == '_') {
            sb.deleteCharAt(0);
        }
        if (sb.length() > 1 && Character.isUpperCase(sb.charAt(1))) {
            return sb;
        }
        if (sb.length() > 0) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb;
    }

    private Tree resolveWildcard(TypeMirror type) {
        Tree result;
        TreeMaker make = this.copy.getTreeMaker();
        if (type != null && type.getKind() == TypeKind.WILDCARD) {
            WildcardType wt = (WildcardType)type;
            TypeMirror bound = wt.getSuperBound();
            if (bound == null) {
                bound = wt.getExtendsBound();
            }
            if (bound == null) {
                return make.Type("java.lang.Object");
            }
            result = make.Type(bound);
        } else {
            result = make.Type(type);
        }
        final IdentityHashMap translate = new IdentityHashMap();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitWildcard(WildcardTree node, Void p) {
                Tree bound = node.getBound();
                if (bound != null && (bound.getKind() == Tree.Kind.EXTENDS_WILDCARD || bound.getKind() == Tree.Kind.SUPER_WILDCARD)) {
                    translate.put(bound, ((WildcardTree)bound).getBound());
                }
                return (Void)super.visitWildcard(node, p);
            }
        }.scan(result, null);
        return this.copy.getTreeUtilities().translate(result, translate);
    }

    private Element getImportedElement(CompilationUnitTree cut, ImportTree imp) {
        Element element;
        Trees trees = this.copy.getTrees();
        Tree qualIdent = imp.getQualifiedIdentifier();
        if (qualIdent.getKind() != Tree.Kind.MEMBER_SELECT) {
            Element element2 = trees.getElement(TreePath.getPath(cut, qualIdent));
            if (element2 == null) {
                String fqn = qualIdent.toString();
                if (fqn.endsWith(".*")) {
                    fqn = fqn.substring(0, fqn.length() - 2);
                }
                element2 = this.getElementByFQN(fqn);
            }
            return element2;
        }
        javax.lang.model.element.Name name = ((MemberSelectTree)qualIdent).getIdentifier();
        if ("*".contentEquals(name)) {
            Element element3 = trees.getElement(TreePath.getPath(cut, (Tree)((MemberSelectTree)qualIdent).getExpression()));
            if (element3 == null) {
                element3 = this.getElementByFQN(((MemberSelectTree)qualIdent).getExpression().toString());
            }
            return element3;
        }
        if (imp.isStatic()) {
            Element parent = trees.getElement(TreePath.getPath(cut, (Tree)((MemberSelectTree)qualIdent).getExpression()));
            if (parent == null) {
                parent = this.getElementByFQN(((MemberSelectTree)qualIdent).getExpression().toString());
            }
            if (parent != null && (parent.getKind().isClass() || parent.getKind().isInterface())) {
                Scope s = trees.getScope(new TreePath(cut));
                for (Element element2 : parent.getEnclosedElements()) {
                    if (name != element2.getSimpleName() || !element2.getModifiers().contains((Object)Modifier.STATIC) || !trees.isAccessible(s, element2, (DeclaredType)parent.asType())) continue;
                    return element2;
                }
                return parent;
            }
        }
        if ((element = trees.getElement(TreePath.getPath(cut, qualIdent))) == null) {
            element = this.getElementByFQN(qualIdent.toString());
        }
        return element;
    }

    private Element getElementByFQN(String fqn) {
        Elements elements = this.copy.getElements();
        QualifiedNameable element = elements.getTypeElement(fqn);
        if (element == null) {
            element = elements.getPackageElement(fqn);
        }
        if (element == null) {
            element = ClassReader.instance(this.copy.impl.getJavacTask().getContext()).enterClass((Name)elements.getName(fqn));
        }
        return element;
    }

    private Map<javax.lang.model.element.Name, TypeElement> getUsedTypes(CompilationUnitTree cut) {
        final Trees trees = this.copy.getTrees();
        final HashMap<javax.lang.model.element.Name, TypeElement> map = new HashMap<javax.lang.model.element.Name, TypeElement>();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                Element element;
                if (!map.containsKey(node.getName()) && (element = trees.getElement(this.getCurrentPath())) != null && (element.getKind().isClass() || element.getKind().isInterface()) && element.asType().getKind() != TypeKind.ERROR) {
                    map.put(node.getName(), (TypeElement)element);
                }
                return (Void)super.visitIdentifier(node, p);
            }

            @Override
            public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
                this.scan(node.getPackageAnnotations(), p);
                return (Void)this.scan(node.getTypeDecls(), p);
            }
        }.scan(cut, null);
        return map;
    }

    private ExpressionTree qualIdentFor(Element e) {
        TreeMaker tm = this.copy.getTreeMaker();
        if (e.getKind() == ElementKind.PACKAGE) {
            String name = ((PackageElement)e).getQualifiedName().toString();
            if (e instanceof Symbol) {
                int lastDot = name.lastIndexOf(46);
                if (lastDot < 0) {
                    return tm.Identifier(e);
                }
                return tm.MemberSelect(this.qualIdentFor(name.substring(0, lastDot)), e);
            }
            return this.qualIdentFor(name);
        }
        Element ee = e.getEnclosingElement();
        if (e instanceof Symbol) {
            return ee.getSimpleName().length() > 0 ? tm.MemberSelect(this.qualIdentFor(ee), e) : tm.Identifier(e);
        }
        return ee.getSimpleName().length() > 0 ? tm.MemberSelect(this.qualIdentFor(ee), e.getSimpleName()) : tm.Identifier(e.getSimpleName());
    }

    private ExpressionTree qualIdentFor(String name) {
        Elements elements = this.copy.getElements();
        TreeMaker tm = this.copy.getTreeMaker();
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return tm.Identifier(elements.getName(name));
        }
        return tm.MemberSelect(this.qualIdentFor(name.substring(0, lastDot)), elements.getName(name.substring(lastDot + 1)));
    }

    private void tagFirst(List<MethodTree> methods) {
        BlockTree body;
        if (methods.size() > 0 && (body = methods.get(0).getBody()) != null && !body.getStatements().isEmpty()) {
            this.copy.tag(body.getStatements().get(0), "methodBodyTag");
        }
    }

    static boolean checkPackagesForStarImport(String pkgName, CodeStyle cs) {
        for (String s : cs.getPackagesForStarImport()) {
            if (!(s.endsWith(".*") ? pkgName.startsWith(s = s.substring(0, s.length() - 2)) : pkgName.equals(s))) continue;
            return true;
        }
        return false;
    }

    private static class ImportsComparator
    implements Comparator<Object> {
        private CodeStyle.ImportGroups groups;

        private ImportsComparator(CodeStyle cs) {
            this.groups = cs.getImportGroups();
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            boolean isStatic1 = false;
            StringBuilder sb1 = new StringBuilder();
            if (o1 instanceof ImportTree) {
                isStatic1 = ((ImportTree)o1).isStatic();
                sb1.append(((ImportTree)o1).getQualifiedIdentifier().toString());
            } else if (o1 instanceof Element) {
                Element e1 = (Element)o1;
                if (e1.getKind().isField() || e1.getKind() == ElementKind.METHOD) {
                    sb1.append('.').append(e1.getSimpleName());
                    e1 = e1.getEnclosingElement();
                    isStatic1 = true;
                }
                if (e1.getKind().isClass() || e1.getKind().isInterface()) {
                    sb1.insert(0, ((TypeElement)e1).getQualifiedName());
                } else if (e1.getKind() == ElementKind.PACKAGE) {
                    sb1.insert(0, ((PackageElement)e1).getQualifiedName());
                }
            }
            String s1 = sb1.toString();
            boolean isStatic2 = false;
            StringBuilder sb2 = new StringBuilder();
            if (o2 instanceof ImportTree) {
                isStatic2 = ((ImportTree)o2).isStatic();
                sb2.append(((ImportTree)o2).getQualifiedIdentifier().toString());
            } else if (o2 instanceof Element) {
                Element e2 = (Element)o2;
                if (e2.getKind().isField() || e2.getKind() == ElementKind.METHOD) {
                    sb2.append('.').append(e2.getSimpleName());
                    e2 = e2.getEnclosingElement();
                    isStatic2 = true;
                }
                if (e2.getKind().isClass() || e2.getKind().isInterface()) {
                    sb2.insert(0, ((TypeElement)e2).getQualifiedName());
                } else if (e2.getKind() == ElementKind.PACKAGE) {
                    sb2.insert(0, ((PackageElement)e2).getQualifiedName());
                }
            }
            String s2 = sb2.toString();
            int bal = this.groups.getGroupId(s1, isStatic1) - this.groups.getGroupId(s2, isStatic2);
            return bal == 0 ? s1.compareTo(s2) : bal;
        }
    }

    private static class ClassMemberComparator
    implements Comparator<Tree> {
        private ClassMemberComparator() {
        }

        @Override
        public int compare(Tree tree1, Tree tree2) {
            if (tree1 == tree2) {
                return 0;
            }
            return ClassMemberComparator.getSortPriority(tree1) - ClassMemberComparator.getSortPriority(tree2);
        }

        private static int getSortPriority(Tree tree) {
            int ret = 0;
            ModifiersTree modifiers = null;
            switch (tree.getKind()) {
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    ret = 4000;
                    modifiers = ((ClassTree)tree).getModifiers();
                    break;
                }
                case METHOD: {
                    MethodTree mt = (MethodTree)tree;
                    ret = mt.getName().contentEquals("<init>") ? 200 : 300;
                    modifiers = mt.getModifiers();
                    break;
                }
                case VARIABLE: {
                    ret = 100;
                    modifiers = ((VariableTree)tree).getModifiers();
                }
            }
            if (modifiers != null && !modifiers.getFlags().contains((Object)Modifier.STATIC)) {
                ret += 1000;
            }
            return ret;
        }
    }
}

