/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.modules.parsing.impl.indexing.IndexerCache;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.util.Exceptions;

public class COSSynchronizingIndexer
extends CustomIndexer {
    protected void index(Iterable<? extends Indexable> files, Context context) {
        if (!BuildArtifactMapperImpl.isUpdateResources(BuildArtifactMapperImpl.getTargetFolder(context.getRootURI()))) {
            return;
        }
        Set<String> javaMimeTypes = COSSynchronizingIndexer.gatherJavaMimeTypes();
        LinkedList<File> updated = new LinkedList<File>();
        for (Indexable indexable : files) {
            if (javaMimeTypes.contains(indexable.getMimeType())) continue;
            try {
                URL url = indexable.getURL();
                if (url == null) continue;
                updated.add(new File(url.toURI()));
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        try {
            File sourceRootFile = new File(context.getRootURI().toURI());
            if (!context.checkForEditorModifications()) {
                BuildArtifactMapperImpl.classCacheUpdated(context.getRootURI(), sourceRootFile, Collections.<File>emptyList(), updated, true);
            }
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static Set<String> gatherJavaMimeTypes() {
        HashSet<String> mimeTypes = new HashSet<String>();
        for (IndexerCache.IndexerInfo i : IndexerCache.getCifCache().getIndexersByName("java")) {
            mimeTypes.addAll(i.getMimeTypes());
        }
        return mimeTypes;
    }

    public static final class Factory
    extends CustomIndexerFactory {
        public CustomIndexer createIndexer() {
            return new COSSynchronizingIndexer();
        }

        public boolean supportsEmbeddedIndexers() {
            return true;
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            if (BuildArtifactMapperImpl.getTargetFolder(context.getRootURI()) == null) {
                return;
            }
            LinkedList<File> deletedFiles = new LinkedList<File>();
            for (Indexable indexable : deleted) {
                try {
                    deletedFiles.add(new File(indexable.getURL().toURI()));
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            try {
                File sourceRootFile = new File(context.getRootURI().toURI());
                BuildArtifactMapperImpl.classCacheUpdated(context.getRootURI(), sourceRootFile, deletedFiles, Collections.<File>emptyList(), true);
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return COSSynchronizingIndexer.class.getName();
        }

        public int getIndexVersion() {
            return 1;
        }
    }
}

