/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import com.sun.java.help.search.Indexer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.javahelp.HelpSetRegistration;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class HelpSetRegistrationProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(HelpSetRegistration.class.getCanonicalName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        if (roundEnv.processingOver()) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(HelpSetRegistration.class)) {
            Document doc;
            URI loc;
            HelpSetRegistration r = element.getAnnotation(HelpSetRegistration.class);
            String pkg = ((PackageElement)element).getQualifiedName().toString();
            String hs = pkg.replace('.', '/') + '/' + r.helpSet();
            LayerBuilder builder = this.layer(new Element[]{element});
            builder.file("Services/JavaHelp/" + pkg.replace('.', '-') + ".xml").contents("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE helpsetref PUBLIC \"-//NetBeans//DTD JavaHelp Help Set Reference 1.0//EN\" \"http://www.netbeans.org/dtds/helpsetref-1_0.dtd\">\n<helpsetref url=\"nbdocs:/" + hs + "\" merge=\"" + r.merge() + "\"/>\n").position(r.position()).write();
            try {
                loc = builder.validateResource(hs, element, (Annotation)r, "helpSet", false).toUri();
                if (loc.getScheme() == null) {
                    loc = new File(loc.toString()).toURI();
                }
                doc = XMLUtil.parse((InputSource)new InputSource(loc.toString()), (boolean)true, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), (EntityResolver)new EntityResolver(){

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                        if (publicId.equals("-//Sun Microsystems Inc.//DTD JavaHelp HelpSet Version 1.0//EN")) {
                            return new InputSource(HelpSetRegistrationProcessor.class.getResource("resources/helpset_1_0.dtd").toString());
                        }
                        if (publicId.equals("-//Sun Microsystems Inc.//DTD JavaHelp HelpSet Version 2.0//EN")) {
                            return new InputSource(HelpSetRegistrationProcessor.class.getResource("resources/helpset_2_0.dtd").toString());
                        }
                        return null;
                    }
                });
            }
            catch (IOException x) {
                throw new LayerGenerationException("Could not parse " + hs + ": " + x, element, this.processingEnv, (Annotation)r, "helpSet");
            }
            catch (SAXException x) {
                throw new LayerGenerationException("Could not parse " + hs + ": " + x, element, this.processingEnv, (Annotation)r, "helpSet");
            }
            String searchDir = null;
            for (org.w3c.dom.Element view : XMLUtil.findSubElements((org.w3c.dom.Element)doc.getDocumentElement())) {
                org.w3c.dom.Element data;
                org.w3c.dom.Element type;
                if (!view.getTagName().equals("view") || !"javax.help.SearchView".equals(XMLUtil.findText((Node)(type = XMLUtil.findElement((org.w3c.dom.Element)view, (String)"type", null)))) || !(data = XMLUtil.findElement((org.w3c.dom.Element)view, (String)"data", null)).getAttribute("engine").equals("com.sun.java.help.search.DefaultSearchEngine")) continue;
                searchDir = XMLUtil.findText((Node)data).trim();
                break;
            }
            if (searchDir == null) continue;
            if ("file".equals(loc.getScheme())) {
                File d = new File(loc).getParentFile();
                String out = hs.replaceFirst("/[^/]+$", "/") + searchDir + "/";
                try {
                    File config = File.createTempFile("jhindexer-config", ".txt");
                    try {
                        AtomicInteger cnt = new AtomicInteger();
                        OutputStream os = new FileOutputStream(config);
                        try {
                            PrintWriter pw = new PrintWriter(os);
                            pw.println("IndexRemove " + d + File.separator);
                            HelpSetRegistrationProcessor.scan(d, pw, cnt, new HashSet<String>(Arrays.asList(r.excludes())), "");
                            pw.flush();
                        }
                        finally {
                            os.close();
                        }
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Indexing " + cnt + " HTML files in " + d + " into " + out);
                        File db = HelpSetRegistrationProcessor.createTempFile("jhindexer-out", "");
                        db.delete();
                        db.mkdir();
                        try {
                            Indexer.main((String[])new String[]{"-c", config.getAbsolutePath(), "-db", db.getAbsolutePath()});
                        }
                        catch (Throwable throwable) {
                            for (File f : db.listFiles()) {
                                FileObject dest = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", out + f.getName(), element);
                                os = dest.openOutputStream();
                                try {
                                    FileInputStream is = new FileInputStream(f);
                                    try {
                                        FileUtil.copy((InputStream)is, (OutputStream)os);
                                    }
                                    finally {
                                        ((InputStream)is).close();
                                    }
                                }
                                finally {
                                    os.close();
                                }
                                f.delete();
                            }
                            db.delete();
                            throw throwable;
                        }
                        for (File f : db.listFiles()) {
                            FileObject dest = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", out + f.getName(), element);
                            os = dest.openOutputStream();
                            try {
                                FileInputStream is = new FileInputStream(f);
                                try {
                                    FileUtil.copy((InputStream)is, (OutputStream)os);
                                }
                                finally {
                                    ((InputStream)is).close();
                                }
                            }
                            finally {
                                os.close();
                            }
                            f.delete();
                        }
                        db.delete();
                    }
                    finally {
                        config.delete();
                    }
                }
                catch (Exception x) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not run indexer: " + x, element);
                }
                continue;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot run indexer on non-local files: " + loc, element);
        }
        return true;
    }

    static File createTempFile(String pref, String suff) throws IOException {
        File f = File.createTempFile(pref, suff);
        if (!HelpSetRegistrationProcessor.isUrlCompatible(f)) {
            if (Utilities.isWindows()) {
                f = HelpSetRegistrationProcessor.replaceTempFile(f, "c:\\Temp", pref, suff);
            } else if (Utilities.isUnix()) {
                f = HelpSetRegistrationProcessor.replaceTempFile(f, "/tmp", pref, suff);
            }
        }
        return f;
    }

    private static File replaceTempFile(File origTmpFile, String tmpDirPath, String pref, String suff) {
        File tmpDir = new File(tmpDirPath);
        if (tmpDir.isDirectory()) {
            String fileName;
            File tmpFile;
            int num = 0;
            while ((tmpFile = new File(tmpDir, fileName = pref + System.currentTimeMillis() + "_" + ++num + suff)).exists()) {
            }
            try {
                tmpFile.createNewFile();
            }
            catch (Exception e) {
                return origTmpFile;
            }
            if (tmpFile.isFile() && HelpSetRegistrationProcessor.isUrlCompatible(tmpFile)) {
                origTmpFile.delete();
                return tmpFile;
            }
            tmpFile.delete();
            return origTmpFile;
        }
        return origTmpFile;
    }

    static boolean isUrlCompatible(File f) {
        URL baseURL;
        try {
            baseURL = new URL("file", "", f.getAbsolutePath());
        }
        catch (MalformedURLException ex) {
            return false;
        }
        String fileFromUrl = baseURL.getFile();
        String decodedFileFromUrl = URLDecoder.decode(fileFromUrl);
        return f.getAbsolutePath().equals(decodedFileFromUrl);
    }

    private static void scan(File d, PrintWriter pw, AtomicInteger cnt, Set<String> excludes, String path) {
        for (File f : d.listFiles()) {
            String name = f.getName();
            if (f.isDirectory()) {
                HelpSetRegistrationProcessor.scan(f, pw, cnt, excludes, path + name + '/');
                continue;
            }
            if (excludes.contains(path + name) || !name.matches(".+[.]html?$")) continue;
            pw.println("File " + f);
            cnt.incrementAndGet();
        }
    }
}

