/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.spi.indexing.support;

import java.io.IOException;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable;
import org.netbeans.modules.parsing.impl.indexing.IndexFactoryImpl;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.lucene.support.DocumentIndex;
import org.netbeans.modules.parsing.lucene.support.Index;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class IndexingSupport {
    private static final Logger LOG = Logger.getLogger(IndexingSupport.class.getName());
    private final Context context;
    private final IndexFactoryImpl spiFactory;
    private final DocumentIndex spiIndex;

    private IndexingSupport(Context ctx) throws IOException {
        IndexFactoryImpl factory = SPIAccessor.getInstance().getIndexFactory(ctx);
        assert (factory != null);
        this.context = ctx;
        this.spiFactory = factory;
        this.spiIndex = this.spiFactory.createIndex(ctx);
    }

    public static IndexingSupport getInstance(Context context) throws IOException {
        Parameters.notNull((CharSequence)"context", (Object)context);
        IndexingSupport support = SPIAccessor.getInstance().context_getAttachedIndexingSupport(context);
        if (support == null) {
            support = new IndexingSupport(context);
            SPIAccessor.getInstance().context_attachIndexingSupport(context, support);
        }
        return support;
    }

    public boolean isValid() {
        try {
            return this.spiIndex.getStatus() != Index.Status.INVALID;
        }
        catch (IOException e) {
            return false;
        }
    }

    public IndexDocument createDocument(FileObject file) {
        FileObject root = this.context.getRoot();
        if (FileUtil.isParentOf((FileObject)root, (FileObject)file)) {
            return this.createDocument(SPIAccessor.getInstance().create(new FileObjectIndexable(root, file)));
        }
        throw new IllegalArgumentException(file + " is not under the root " + root);
    }

    public IndexDocument createDocument(Indexable indexable) {
        Parameters.notNull((CharSequence)"indexable", (Object)indexable);
        return new IndexDocument(this.spiFactory.createDocument(indexable));
    }

    public void addDocument(IndexDocument document) {
        Parameters.notNull((CharSequence)"document", (Object)document.spi);
        this.spiIndex.addDocument(document.spi);
    }

    public void removeDocuments(Indexable indexable) {
        Parameters.notNull((CharSequence)"indexable", (Object)indexable);
        this.spiIndex.removeDocument(indexable.getRelativePath());
    }

    public void markDirtyDocuments(Indexable indexable) {
        Parameters.notNull((CharSequence)"indexable", (Object)indexable);
        this.spiIndex.markKeyDirty(indexable.getRelativePath());
    }
}

