/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.ChildrenArray;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Utilities;

abstract class EntrySupport {
    public final Children children;
    protected List<Children.Entry> entries = Collections.emptyList();

    protected EntrySupport(Children children) {
        this.children = children;
    }

    public abstract int getNodesCount(boolean var1);

    public abstract Node[] getNodes(boolean var1);

    public abstract Node getNodeAt(int var1);

    public abstract Node[] testNodes();

    public abstract boolean isInitialized();

    abstract void notifySetEntries();

    final void setEntries(Collection<? extends Children.Entry> entries) {
        this.setEntries(entries, false);
    }

    abstract void setEntries(Collection<? extends Children.Entry> var1, boolean var2);

    protected final List<Children.Entry> getEntries() {
        return new ArrayList<Children.Entry>(this.entries);
    }

    abstract List<Node> snapshot();

    abstract void refreshEntry(Children.Entry var1);

    static class Lazy
    extends EntrySupport {
        private Map<Children.Entry, EntryInfo> entryToInfo = new HashMap<Children.Entry, EntryInfo>();
        private List<Children.Entry> visibleEntries = Collections.emptyList();
        private static final Logger LOGGER = Logger.getLogger(Lazy.class.getName());
        private static final int prefetchCount = Math.max(Integer.getInteger("org.openide.explorer.VisualizerNode.prefetchCount", 50), 0);
        protected final Object LOCK = new Object();
        private boolean initInProgress = false;
        private boolean inited = false;
        private Thread initThread;
        private int snapshotCount;
        private boolean mustNotifySetEntries = false;

        public Lazy(Children ch) {
            super(ch);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkInit() {
            if (this.inited) {
                return true;
            }
            boolean doInit = false;
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.initInProgress) {
                    doInit = true;
                    this.initInProgress = true;
                    this.initThread = Thread.currentThread();
                }
            }
            boolean LOG_ENABLED = LOGGER.isLoggable(Level.FINER);
            if (doInit) {
                if (LOG_ENABLED) {
                    LOGGER.finer("Initialize " + this + " on " + Thread.currentThread());
                    LOGGER.finer("    callAddNotify()");
                }
                try {
                    this.children.callAddNotify();
                }
                finally {
                    class Notify
                    implements Runnable {
                        Notify() {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = Lazy.this.LOCK;
                            synchronized (object) {
                                Lazy.this.initThread = null;
                                Lazy.this.LOCK.notifyAll();
                            }
                        }
                    }
                    Notify notify = new Notify();
                    this.inited = true;
                    if (Children.MUTEX.isReadAccess()) {
                        Children.MUTEX.postWriteRequest((Runnable)notify);
                    } else {
                        notify.run();
                    }
                }
            }
            if (Children.MUTEX.isReadAccess() || Children.MUTEX.isWriteAccess() || this.initThread == Thread.currentThread()) {
                if (LOG_ENABLED) {
                    LOGGER.log(Level.FINER, "Cannot wait for finished initialization " + this + " on " + Thread.currentThread() + " read access: " + Children.MUTEX.isReadAccess() + " write access: " + Children.MUTEX.isWriteAccess() + " initThread: " + this.initThread);
                }
                this.notifySetEntries();
                return false;
            }
            Object object2 = this.LOCK;
            synchronized (object2) {
                while (this.initThread != null) {
                    try {
                        this.LOCK.wait();
                    }
                    catch (InterruptedException ex) {}
                }
            }
            return true;
        }

        final int getSnapshotCount() {
            assert (Thread.holdsLock(this.LOCK));
            return this.snapshotCount;
        }

        final void incrementCount() {
            assert (Thread.holdsLock(this.LOCK));
            ++this.snapshotCount;
        }

        final void decrementCount() {
            assert (Thread.holdsLock(this.LOCK));
            ++this.snapshotCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        List<Node> snapshot() {
            this.checkInit();
            try {
                Children.PR.enterReadAccess();
                LazySnapshot lazySnapshot = this.createSnapshot();
                return lazySnapshot;
            }
            finally {
                Children.PR.exitReadAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void registerNode(int delta, EntryInfo who) {
            if (delta == -1) {
                try {
                    Children.PR.enterWriteAccess();
                    boolean zero = false;
                    LOGGER.finer("register node");
                    Object object = this.LOCK;
                    synchronized (object) {
                        int cnt = 0;
                        boolean found = false;
                        if ((cnt += this.getSnapshotCount()) == 0) {
                            for (Children.Entry entry : Lazy.notNull(this.visibleEntries)) {
                                EntryInfo info = this.entryToInfo.get(entry);
                                if (info.currentNode() != null) {
                                    ++cnt;
                                    break;
                                }
                                if (info != who) continue;
                                found = true;
                            }
                        }
                        boolean bl = zero = cnt == 0 && (found || who == null);
                        if (zero) {
                            this.inited = false;
                            this.initThread = null;
                            this.initInProgress = false;
                            if (this.children.getEntrySupport() == this) {
                                if (LOGGER.isLoggable(Level.FINER)) {
                                    LOGGER.finer("callRemoveNotify() " + this);
                                }
                                this.children.callRemoveNotify();
                            }
                        }
                    }
                }
                finally {
                    Children.PR.exitWriteAccess();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node getNodeAt(int index) {
            if (!this.checkInit()) {
                return null;
            }
            Node node = null;
            do {
                try {
                    Children.PR.enterReadAccess();
                    List<Children.Entry> e = Lazy.notNull(this.visibleEntries);
                    if (index >= e.size()) {
                        Node node2 = node;
                        return node2;
                    }
                    Children.Entry entry = e.get(index);
                    EntryInfo info = this.entryToInfo.get(entry);
                    node = info.getNode();
                    if (!Lazy.isDummyNode(node)) {
                        Node node3 = node;
                        return node3;
                    }
                    this.hideEmpty(null, entry);
                }
                finally {
                    Children.PR.exitReadAccess();
                }
            } while (!Children.MUTEX.isReadAccess());
            return node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node[] getNodes(boolean optimalResult) {
            Node[] tmpNodes;
            if (!this.checkInit()) {
                return new Node[0];
            }
            Node holder = null;
            if (optimalResult) {
                holder = this.children.findChild(null);
            }
            Children.LOG.log(Level.FINEST, "findChild returns: {0}", holder);
            Children.LOG.log(Level.FINEST, "after findChild: {0}", optimalResult);
            do {
                HashSet<Children.Entry> invalidEntries = null;
                tmpNodes = null;
                try {
                    Children.PR.enterReadAccess();
                    List<Children.Entry> e = Lazy.notNull(this.visibleEntries);
                    ArrayList<Node> toReturn = new ArrayList<Node>(e.size());
                    for (Children.Entry entry : e) {
                        EntryInfo info = this.entryToInfo.get(entry);
                        assert (!info.isHidden());
                        Node node = info.getNode();
                        if (Lazy.isDummyNode(node)) {
                            if (invalidEntries == null) {
                                invalidEntries = new HashSet<Children.Entry>();
                            }
                            invalidEntries.add(entry);
                        }
                        toReturn.add(node);
                    }
                    tmpNodes = toReturn.toArray(new Node[0]);
                    if (invalidEntries == null) {
                        Node[] nodeArray = tmpNodes;
                        return nodeArray;
                    }
                    this.hideEmpty(invalidEntries, null);
                }
                finally {
                    Children.PR.exitReadAccess();
                }
            } while (!Children.MUTEX.isReadAccess());
            return tmpNodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node[] testNodes() {
            if (!this.inited) {
                return null;
            }
            ArrayList<Node> created = new ArrayList<Node>();
            try {
                Children.PR.enterReadAccess();
                for (Children.Entry entry : Lazy.notNull(this.visibleEntries)) {
                    EntryInfo info = this.entryToInfo.get(entry);
                    Node node = info.currentNode();
                    if (node == null) continue;
                    created.add(node);
                }
            }
            finally {
                Children.PR.exitReadAccess();
            }
            return created.isEmpty() ? null : created.toArray(new Node[created.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getNodesCount(boolean optimalResult) {
            this.checkInit();
            try {
                Children.PR.enterReadAccess();
                int n = Lazy.notNull(this.visibleEntries).size();
                return n;
            }
            finally {
                Children.PR.exitReadAccess();
            }
        }

        @Override
        public boolean isInitialized() {
            return this.inited;
        }

        Children.Entry entryForNode(Node key) {
            for (Map.Entry<Children.Entry, EntryInfo> entry : this.entryToInfo.entrySet()) {
                if (entry.getValue().currentNode() != key) continue;
                return entry.getKey();
            }
            return null;
        }

        static final boolean isDummyNode(Node node) {
            return node.getClass().getName().endsWith("EntrySupport$Lazy$DummyNode");
        }

        @Override
        void refreshEntry(Children.Entry entry) {
            assert (Children.MUTEX.isWriteAccess());
            boolean LOG_ENABLED = LOGGER.isLoggable(Level.FINER);
            if (LOG_ENABLED) {
                LOGGER.finer("refreshEntry() " + this);
                LOGGER.finer("    entry: " + entry);
            }
            if (!this.inited) {
                return;
            }
            EntryInfo info = this.entryToInfo.get(entry);
            if (info == null) {
                if (LOG_ENABLED) {
                    LOGGER.finer("    no such entry: " + entry);
                }
                return;
            }
            Node oldNode = info.currentNode();
            EntryInfo newInfo = null;
            Node newNode = null;
            if (info.isHidden()) {
                newNode = info.getNode(true, null);
            } else {
                newInfo = info.duplicate(null);
                newNode = newInfo.getNode(true, null);
            }
            boolean newIsDummy = Lazy.isDummyNode(newNode);
            if (newIsDummy && info.isHidden()) {
                return;
            }
            if (newNode.equals(oldNode)) {
                return;
            }
            if (!info.isHidden() || newIsDummy) {
                this.removeEntries(null, entry, newInfo, true, true);
            }
            if (newInfo != null) {
                info = newInfo;
                this.entryToInfo.put(entry, info);
            }
            if (newIsDummy) {
                return;
            }
            int index = 0;
            info.setIndex(-1);
            ArrayList<Children.Entry> arr = new ArrayList<Children.Entry>();
            for (Children.Entry tmpEntry : this.entries) {
                EntryInfo tmpInfo = this.entryToInfo.get(tmpEntry);
                if (tmpInfo.isHidden()) continue;
                tmpInfo.setIndex(index++);
                arr.add(tmpEntry);
            }
            this.visibleEntries = arr;
            this.fireSubNodesChangeIdx(true, new int[]{info.getIndex()}, entry, this.createSnapshot(), null);
        }

        @Override
        void notifySetEntries() {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("notifySetEntries() " + this);
            }
            this.mustNotifySetEntries = true;
        }

        @Override
        void setEntries(Collection<? extends Children.Entry> newEntries, boolean noCheck) {
            List<Children.Entry> toAdd;
            assert (Children.MUTEX.isWriteAccess());
            boolean LOG_ENABLED = LOGGER.isLoggable(Level.FINER);
            if (LOG_ENABLED) {
                LOGGER.finer("setEntries(): " + this);
                LOGGER.finer("    inited: " + this.inited);
                LOGGER.finer("    mustNotifySetEnties: " + this.mustNotifySetEntries);
                LOGGER.finer("    newEntries size: " + newEntries.size() + " data:" + newEntries);
                LOGGER.finer("    entries size: " + this.entries.size() + " data:" + this.entries);
                LOGGER.finer("    visibleEntries size: " + Lazy.notNull(this.visibleEntries).size() + " data:" + this.visibleEntries);
                LOGGER.finer("    entryToInfo size: " + this.entryToInfo.size());
            }
            int entriesSize = 0;
            int entryToInfoSize = 0;
            assert ((entriesSize = this.entries.size()) >= 0);
            assert ((entryToInfoSize = this.entryToInfo.size()) >= 0);
            assert (this.entries.size() == this.entryToInfo.size()) : "Entries: " + this.entries.size() + "; vis. entries: " + Lazy.notNull(this.visibleEntries).size() + "; Infos: " + this.entryToInfo.size() + "; entriesSize: " + entriesSize + "; entryToInfoSize: " + entryToInfoSize + Lazy.dumpEntriesInfos(this.entries, this.entryToInfo);
            if (!this.mustNotifySetEntries && !this.inited) {
                this.entries = new ArrayList<Children.Entry>(newEntries);
                this.visibleEntries = new ArrayList<Children.Entry>(newEntries);
                this.entryToInfo.keySet().retainAll(this.entries);
                for (int i = 0; i < this.entries.size(); ++i) {
                    Children.Entry entry = (Children.Entry)this.entries.get(i);
                    EntryInfo info = this.entryToInfo.get(entry);
                    if (info == null) {
                        info = new EntryInfo(entry);
                        this.entryToInfo.put(entry, info);
                    }
                    info.setIndex(i);
                }
                return;
            }
            HashSet<Children.Entry> entriesToRemove = new HashSet<Children.Entry>(this.entries);
            entriesToRemove.removeAll(newEntries);
            if (!entriesToRemove.isEmpty()) {
                this.removeEntries(entriesToRemove, null, null, false, false);
            }
            if (!(toAdd = this.updateOrder(newEntries)).isEmpty()) {
                this.entries = new ArrayList<Children.Entry>(newEntries);
                int[] idxs = new int[toAdd.size()];
                int addIdx = 0;
                int inx = 0;
                boolean createNodes = toAdd.size() == 2 && prefetchCount > 0;
                this.visibleEntries = new ArrayList<Children.Entry>();
                for (int i = 0; i < this.entries.size(); ++i) {
                    Children.Entry entry = (Children.Entry)this.entries.get(i);
                    EntryInfo info = this.entryToInfo.get(entry);
                    if (info == null) {
                        Node n;
                        info = new EntryInfo(entry);
                        this.entryToInfo.put(entry, info);
                        if (createNodes && Lazy.isDummyNode(n = info.getNode())) {
                            info.setIndex(-2);
                            continue;
                        }
                        idxs[addIdx++] = inx;
                    }
                    if (info.isHidden()) continue;
                    info.setIndex(inx++);
                    this.visibleEntries.add(entry);
                }
                if (addIdx == 0) {
                    return;
                }
                if (idxs.length != addIdx) {
                    int[] tmp = new int[addIdx];
                    for (int i = 0; i < tmp.length; ++i) {
                        tmp[i] = idxs[i];
                    }
                    idxs = tmp;
                }
                this.fireSubNodesChangeIdx(true, idxs, null, this.createSnapshot(), null);
            }
        }

        private List<Children.Entry> updateOrder(Collection<? extends Children.Entry> newEntries) {
            assert (Children.MUTEX.isWriteAccess());
            LinkedList<Children.Entry> toAdd = new LinkedList<Children.Entry>();
            int[] perm = new int[this.visibleEntries.size()];
            int currentPos = 0;
            int permSize = 0;
            LinkedList<Children.Entry> reorderedEntries = null;
            ArrayList<Children.Entry> newVisible = null;
            for (Children.Entry entry : newEntries) {
                EntryInfo info = this.entryToInfo.get(entry);
                if (info == null) {
                    toAdd.add(entry);
                    continue;
                }
                if (reorderedEntries == null) {
                    reorderedEntries = new LinkedList<Children.Entry>();
                    newVisible = new ArrayList<Children.Entry>();
                }
                reorderedEntries.add(entry);
                if (info.isHidden()) continue;
                newVisible.add(entry);
                int oldPos = info.getIndex();
                if (currentPos != oldPos) {
                    info.setIndex(currentPos);
                    perm[oldPos] = 1 + currentPos;
                    ++permSize;
                }
                ++currentPos;
            }
            if (permSize > 0) {
                for (int i = 0; i < perm.length; ++i) {
                    if (perm[i] == 0) {
                        perm[i] = i;
                        continue;
                    }
                    int n = i;
                    perm[n] = perm[n] - 1;
                }
                this.entries = reorderedEntries;
                this.visibleEntries = newVisible;
                Node p = this.children.parent;
                if (p != null) {
                    p.fireReorderChange(perm);
                }
            }
            return toAdd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Node getNode(Children.Entry entry) {
            this.checkInit();
            try {
                Children.PR.enterReadAccess();
                EntryInfo info = this.entryToInfo.get(entry);
                if (info == null) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("getNode() " + this);
                        LOGGER.finer("    no such entry: " + entry);
                    }
                    Node node = null;
                    return node;
                }
                Node node = info.getNode();
                Node node2 = Lazy.isDummyNode(node) ? null : node;
                return node2;
            }
            finally {
                Children.PR.exitReadAccess();
            }
        }

        protected void fireSubNodesChangeIdx(boolean added, int[] idxs, Children.Entry sourceEntry, List<Node> current, List<Node> previous) {
            if (this.children.parent != null && this.children.getEntrySupport() == this) {
                this.children.parent.fireSubNodesChangeIdx(added, idxs, sourceEntry, current, previous);
            }
        }

        private static <T> List<T> notNull(List<T> it) {
            if (it == null) {
                return Collections.emptyList();
            }
            return it;
        }

        private static String dumpEntriesInfos(List<Children.Entry> entries, Map<Children.Entry, EntryInfo> entryToInfo) {
            StringBuilder sb = new StringBuilder();
            int cnt = 0;
            for (Children.Entry entry : entries) {
                sb.append("\n").append(++cnt).append(" entry ").append(entry).append(" -> ").append(entryToInfo.get(entry));
            }
            sb.append("\n\n");
            for (Map.Entry entry : entryToInfo.entrySet()) {
                if (entries.contains(entry.getKey())) {
                    sb.append("\n").append(" contained ").append(entry.getValue());
                    continue;
                }
                sb.append("\n").append(" missing   ").append(entry.getValue()).append(" for ").append(entry.getKey());
            }
            return sb.toString();
        }

        void hideEmpty(final Set<Children.Entry> entries, final Children.Entry entry) {
            Children.MUTEX.postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    Lazy.this.removeEntries(entries, entry, null, true, true);
                }
            });
        }

        private void removeEntries(Set<Children.Entry> entriesToRemove, Children.Entry entryToRemove, EntryInfo newEntryInfo, boolean justHide, boolean delayed) {
            assert (Children.MUTEX.isWriteAccess());
            boolean LOG_ENABLED = LOGGER.isLoggable(Level.FINER);
            if (LOG_ENABLED) {
                LOGGER.finer("removeEntries(): " + this);
                LOGGER.finer("    entriesToRemove: " + entriesToRemove);
                LOGGER.finer("    entryToRemove: " + entryToRemove);
                LOGGER.finer("    newEntryInfo: " + newEntryInfo);
                LOGGER.finer("    justHide: " + justHide);
                LOGGER.finer("    delayed: " + delayed);
            }
            int index = 0;
            int removedIdx = 0;
            int removedNodesIdx = 0;
            int expectedSize = entriesToRemove != null ? entriesToRemove.size() : 1;
            int[] idxs = new int[expectedSize];
            List<Children.Entry> previousEntries = this.visibleEntries;
            HashMap<Children.Entry, EntryInfo> previousInfos = null;
            ArrayList<Children.Entry> newEntries = justHide ? null : new ArrayList<Children.Entry>();
            Node[] removedNodes = null;
            this.visibleEntries = new ArrayList<Children.Entry>();
            for (Children.Entry entry : this.entries) {
                EntryInfo info = this.entryToInfo.get(entry);
                boolean remove = entriesToRemove != null ? entriesToRemove.remove(entry) : entryToRemove.equals(entry);
                if (remove) {
                    if (info.isHidden()) {
                        if (justHide) continue;
                        this.entryToInfo.remove(entry);
                        continue;
                    }
                    idxs[removedIdx++] = info.getIndex();
                    if (previousInfos == null) {
                        previousInfos = new HashMap<Children.Entry, EntryInfo>(this.entryToInfo);
                    }
                    Node node = info.currentNode();
                    if (!info.isHidden() && node != null && !Lazy.isDummyNode(node)) {
                        if (removedNodes == null) {
                            removedNodes = new Node[expectedSize];
                        }
                        removedNodes[removedNodesIdx++] = node;
                    }
                    if (justHide) {
                        EntryInfo dup = newEntryInfo != null ? newEntryInfo : info.duplicate(null);
                        this.entryToInfo.put(info.entry, dup);
                        dup.setIndex(-2);
                        continue;
                    }
                    this.entryToInfo.remove(entry);
                    continue;
                }
                if (!info.isHidden()) {
                    this.visibleEntries.add(info.entry);
                    info.setIndex(index++);
                }
                if (justHide) continue;
                newEntries.add(info.entry);
            }
            if (!justHide) {
                this.entries = newEntries;
            }
            if (removedIdx == 0) {
                return;
            }
            if (removedIdx < idxs.length) {
                idxs = (int[])Lazy.resizeArray(idxs, removedIdx);
            }
            LazySnapshot curSnapshot = this.createSnapshot(this.visibleEntries, new HashMap<Children.Entry, EntryInfo>(this.entryToInfo), delayed);
            LazySnapshot prevSnapshot = this.createSnapshot(previousEntries, previousInfos, false);
            this.fireSubNodesChangeIdx(false, idxs, entryToRemove, curSnapshot, prevSnapshot);
            if (removedNodesIdx > 0) {
                if (removedNodesIdx < removedNodes.length) {
                    removedNodes = (Node[])Lazy.resizeArray(removedNodes, removedNodesIdx);
                }
                if (this.children.parent != null) {
                    for (Node node : removedNodes) {
                        node.deassignFrom(this.children);
                        node.fireParentNodeChange(this.children.parent, null);
                    }
                }
                this.children.destroyNodes(removedNodes);
            }
        }

        private static Object resizeArray(Object oldArray, int newSize) {
            int oldSize = Array.getLength(oldArray);
            Class<?> elementType = oldArray.getClass().getComponentType();
            Object newArray = Array.newInstance(elementType, newSize);
            int preserveLength = Math.min(oldSize, newSize);
            if (preserveLength > 0) {
                System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
            }
            return newArray;
        }

        LazySnapshot createSnapshot() {
            return this.createSnapshot(this.visibleEntries, new HashMap<Children.Entry, EntryInfo>(this.entryToInfo), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected LazySnapshot createSnapshot(List<Children.Entry> entries, Map<Children.Entry, EntryInfo> e2i, boolean delayed) {
            Object object = this.LOCK;
            synchronized (object) {
                return delayed ? new DelayedLazySnapshot(entries, e2i) : new LazySnapshot(entries, e2i);
            }
        }

        final class DelayedLazySnapshot
        extends LazySnapshot {
            public DelayedLazySnapshot(List<Children.Entry> entries, Map<Children.Entry, EntryInfo> e2i) {
                super(entries, e2i);
            }
        }

        class LazySnapshot
        extends AbstractList<Node> {
            final List<Children.Entry> entries;
            final Map<Children.Entry, EntryInfo> entryToInfo;

            public LazySnapshot(List<Children.Entry> entries, Map<Children.Entry, EntryInfo> e2i) {
                Lazy.this.incrementCount();
                this.entries = entries;
                assert (entries != null);
                this.entryToInfo = e2i != null ? e2i : Collections.emptyMap();
            }

            @Override
            public Node get(int index) {
                Children.Entry entry = this.entries.get(index);
                return this.get(entry);
            }

            Node get(Children.Entry entry) {
                EntryInfo info = this.entryToInfo.get(entry);
                Node node = info.getNode();
                if (Lazy.isDummyNode(node)) {
                    Lazy.this.hideEmpty(null, entry);
                }
                return node;
            }

            @Override
            public String toString() {
                return this.entries.toString();
            }

            @Override
            public int size() {
                return this.entries.size();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() throws Throwable {
                boolean unregister = false;
                Object object = Lazy.this.LOCK;
                synchronized (object) {
                    Lazy.this.decrementCount();
                    if (Lazy.this.getSnapshotCount() == 0) {
                        unregister = true;
                    }
                }
                if (unregister) {
                    Lazy.this.registerNode(-1, null);
                }
            }
        }

        static class DummyNode
        extends AbstractNode {
            public DummyNode() {
                super(Children.LEAF);
            }
        }

        private static final class NodeRef
        extends WeakReference<Node>
        implements Runnable {
            private final EntryInfo info;

            public NodeRef(Node node, EntryInfo info) {
                super(node, Utilities.activeReferenceQueue());
                info.lazy().registerNode(1, info);
                this.info = info;
            }

            @Override
            public void run() {
                this.info.lazy().registerNode(-1, this.info);
            }
        }

        final class EntryInfo {
            final Children.Entry entry;
            private NodeRef refNode;
            private int index = -1;
            private Thread creatingNodeThread = null;

            public EntryInfo(Children.Entry entry) {
                this.entry = entry;
            }

            final EntryInfo duplicate(Node node) {
                EntryInfo ei = new EntryInfo(this.entry);
                ei.index = this.index;
                ei.refNode = node != null ? new NodeRef(node, ei) : this.refNode;
                return ei;
            }

            final Lazy lazy() {
                return Lazy.this;
            }

            public final Node getNode() {
                return this.getNode(false, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Node getNode(boolean refresh, Object source) {
                Collection<Object> nodes;
                boolean creating;
                Node node;
                while (true) {
                    node = null;
                    creating = false;
                    Object object = Lazy.this.LOCK;
                    synchronized (object) {
                        if (refresh) {
                            this.refNode = null;
                        }
                        if (this.refNode != null && (node = (Node)this.refNode.get()) != null) {
                            return node;
                        }
                        if (this.creatingNodeThread != null) {
                            if (this.creatingNodeThread == Thread.currentThread()) {
                                return new DummyNode();
                            }
                            try {
                                Lazy.this.LOCK.wait();
                            }
                            catch (InterruptedException ex) {}
                        } else {
                            this.creatingNodeThread = Thread.currentThread();
                            creating = true;
                        }
                    }
                    nodes = Collections.emptyList();
                    if (creating) {
                        try {
                            nodes = this.entry.nodes(source);
                        }
                        catch (RuntimeException ex) {
                            NodeOp.warning(ex);
                        }
                    }
                    Object object2 = Lazy.this.LOCK;
                    synchronized (object2) {
                        if (creating) break;
                        if (this.refNode != null && (node = (Node)this.refNode.get()) != null) {
                            return node;
                        }
                    }
                }
                {
                    if (nodes.size() == 0) {
                        node = new DummyNode();
                    } else {
                        if (nodes.size() > 1) {
                            LOGGER.fine("Number of nodes for Entry: " + this.entry + " is " + nodes.size() + " instead of 1");
                        }
                        node = (Node)nodes.iterator().next();
                    }
                    this.refNode = new NodeRef(node, this);
                    if (creating) {
                        this.creatingNodeThread = null;
                        Lazy.this.LOCK.notifyAll();
                    }
                }
                node.assignTo(Lazy.this.children, -1);
                node.fireParentNodeChange(null, Lazy.this.children.parent);
                return node;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Node currentNode() {
                Object object = Lazy.this.LOCK;
                synchronized (object) {
                    return this.refNode == null ? null : (Node)this.refNode.get();
                }
            }

            final boolean isHidden() {
                return this.index == -2;
            }

            final void setIndex(int i) {
                this.index = i;
            }

            final int getIndex() {
                assert (this.index >= 0) : "When first asked for it has to be set: " + this.index;
                return this.index;
            }

            public String toString() {
                return "EntryInfo for entry: " + this.entry + ", node: " + (this.refNode == null ? null : (Node)this.refNode.get());
            }
        }
    }

    static class Default
    extends EntrySupport {
        private static final Reference<ChildrenArray> EMPTY = new WeakReference<Object>(null);
        private Reference<ChildrenArray> array = EMPTY;
        private Map<Children.Entry, Info> map;
        private static final Object LOCK = new Object();
        private static final Logger LOGGER = Logger.getLogger(Default.class.getName());
        private Thread initThread;
        private boolean inited = false;
        private boolean mustNotifySetEnties = false;

        public Default(Children ch) {
            super(ch);
        }

        @Override
        public boolean isInitialized() {
            ChildrenArray arr = this.array.get();
            return this.inited && arr != null && arr.isInitialized();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        List<Node> snapshot() {
            Node[] nodes = this.getNodes();
            try {
                Children.PR.enterReadAccess();
                DefaultSnapshot defaultSnapshot = this.createSnapshot();
                return defaultSnapshot;
            }
            finally {
                Children.PR.exitReadAccess();
            }
        }

        DefaultSnapshot createSnapshot() {
            return new DefaultSnapshot(this.getNodes(), this.array.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Node[] getNodes() {
            Node[] nodes;
            boolean LOG_ENABLED = LOGGER.isLoggable(Level.FINER);
            if (LOG_ENABLED) {
                LOGGER.finer("getNodes() " + this);
            }
            boolean[] results = new boolean[2];
            do {
                ChildrenArray tmpArray = this.getArray(results);
                try {
                    Children.PR.enterReadAccess();
                    if (this != this.children.getEntrySupport()) {
                        Node[] nodeArray = new Node[]{};
                        return nodeArray;
                    }
                    results[1] = this.isInitialized();
                    nodes = tmpArray.nodes();
                }
                finally {
                    Children.PR.exitReadAccess();
                }
                if (LOG_ENABLED) {
                    LOGGER.finer("  length     : " + (nodes == null ? "nodes is null" : Integer.valueOf(nodes.length)));
                    LOGGER.finer("  init now   : " + this.isInitialized());
                }
                if (!results[1]) continue;
                return nodes;
            } while (!results[0]);
            this.notifySetEntries();
            return nodes == null ? new Node[]{} : nodes;
        }

        @Override
        public Node[] getNodes(boolean optimalResult) {
            boolean LOG_ENABLED = LOGGER.isLoggable(Level.FINER);
            ChildrenArray hold = null;
            Node find = null;
            if (optimalResult) {
                if (LOG_ENABLED) {
                    LOGGER.finer("computing optimal result");
                }
                hold = this.getArray(null);
                if (LOG_ENABLED) {
                    LOGGER.finer("optimal result is here: " + hold);
                }
                find = this.children.findChild(null);
                if (LOG_ENABLED) {
                    LOGGER.finer("Find child got: " + find);
                }
                Children.LOG.log(Level.FINEST, "after findChild: {0}", optimalResult);
            }
            return this.getNodes();
        }

        @Override
        public final int getNodesCount(boolean optimalResult) {
            return this.getNodes(optimalResult).length;
        }

        @Override
        public Node getNodeAt(int index) {
            Node[] nodes = this.getNodes();
            return index < nodes.length ? nodes[index] : null;
        }

        final Node[] justComputeNodes() {
            if (this.map == null) {
                this.map = Collections.synchronizedMap(new HashMap(17));
                LOGGER.finer("Map initialized");
            }
            LinkedList<Node> l = new LinkedList<Node>();
            for (Children.Entry entry : this.entries) {
                Info info = this.findInfo(entry);
                l.addAll(info.nodes(false));
            }
            Node[] arr = l.toArray(new Node[l.size()]);
            for (int i = 0; i < arr.length; ++i) {
                Node n = arr[i];
                if (n == null) {
                    LOGGER.warning("null node among children!");
                    for (int j = 0; j < arr.length; ++j) {
                        LOGGER.log(Level.WARNING, "  {0} = {1}", new Object[]{j, arr[j]});
                    }
                    for (Children.Entry entry : this.entries) {
                        Info info = this.findInfo(entry);
                        LOGGER.log(Level.WARNING, "  entry: {0} info {1} nodes: {2}", new Object[]{entry, info, info.nodes(false)});
                    }
                    throw new NullPointerException("arr[" + i + "] is null");
                }
                n.assignTo(this.children, i);
                n.fireParentNodeChange(null, this.children.parent);
            }
            return arr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Info findInfo(Children.Entry entry) {
            Map<Children.Entry, Info> map = this.map;
            synchronized (map) {
                Info info = this.map.get(entry);
                if (info == null) {
                    info = new Info(entry);
                    this.map.put(entry, info);
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Put: " + entry + " info: " + info);
                    }
                }
                return info;
            }
        }

        @Override
        void notifySetEntries() {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(this + " mustNotifySetEntries()");
            }
            this.mustNotifySetEnties = true;
        }

        private void checkConsistency() {
            assert (this.map.size() == this.entries.size()) : "map.size()=" + this.map.size() + " entries.size()=" + this.entries.size();
        }

        @Override
        protected void setEntries(Collection<? extends Children.Entry> entries, boolean noCheck) {
            List<Info> toAdd;
            Node[] current;
            assert (noCheck || Children.MUTEX.isWriteAccess());
            boolean LOG_ENABLED = LOGGER.isLoggable(Level.FINER);
            ChildrenArray holder = this.array.get();
            if (LOG_ENABLED) {
                LOGGER.finer("setEntries for " + this + " on " + Thread.currentThread());
                LOGGER.finer("       values: " + entries);
                LOGGER.finer("       holder: " + holder);
                LOGGER.finer("       mustNotifySetEntries: " + this.mustNotifySetEnties);
            }
            Node[] nodeArray = current = holder == null ? null : holder.nodes();
            if (this.mustNotifySetEnties) {
                if (holder == null) {
                    holder = this.getArray(null);
                }
                if (current == null) {
                    holder.entrySupport = this;
                    current = holder.nodes();
                }
                this.mustNotifySetEnties = false;
            } else if (holder == null || current == null) {
                this.entries = new ArrayList<Children.Entry>(entries);
                if (this.map != null) {
                    this.map.keySet().retainAll(new HashSet(this.entries));
                }
                return;
            }
            this.checkConsistency();
            LinkedHashSet<Children.Entry> toRemove = new LinkedHashSet<Children.Entry>(this.entries);
            HashSet<? extends Children.Entry> entriesSet = new HashSet<Children.Entry>(entries);
            toRemove.removeAll(entriesSet);
            if (!toRemove.isEmpty()) {
                this.updateRemove(current, toRemove);
                current = holder.nodes();
            }
            if (!(toAdd = this.updateOrder(current, entries)).isEmpty()) {
                this.updateAdd(toAdd, new ArrayList<Children.Entry>(entries));
            }
        }

        private void checkInfo(Info info, Children.Entry entry, Collection<? extends Children.Entry> entries, Map<Children.Entry, Info> map) {
            if (info == null) {
                throw new IllegalStateException("Error in " + this.getClass().getName() + " with entry " + entry + " from among " + entries + " in " + map + " probably caused by faulty key implementation." + " The key hashCode() and equals() methods must behave as for an IMMUTABLE object" + " and the hashCode() must return the same value for equals() keys.");
            }
        }

        private void updateRemove(Node[] current, Set<Children.Entry> toRemove) {
            assert (Children.MUTEX.isWriteAccess());
            LinkedList<Node> nodes = new LinkedList<Node>();
            ChildrenArray cha = this.array.get();
            for (Children.Entry en : toRemove) {
                Info info = this.map.remove(en);
                this.checkInfo(info, en, null, this.map);
                nodes.addAll(info.nodes(true));
                cha.remove(info);
            }
            this.entries.removeAll(toRemove);
            this.checkConsistency();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Current : " + this.entries);
                LOGGER.finer("Removing: " + toRemove);
            }
            if (!nodes.isEmpty()) {
                this.clearNodes();
                this.notifyRemove(nodes, current);
            }
        }

        private List<Info> updateOrder(Node[] current, Collection<? extends Children.Entry> newEntries) {
            assert (Children.MUTEX.isWriteAccess());
            LinkedList<Info> toAdd = new LinkedList<Info>();
            HashMap<Info, Integer> offsets = new HashMap<Info, Integer>();
            int previousPos = 0;
            for (Children.Entry entry : this.entries) {
                Info info = this.map.get(entry);
                this.checkInfo(info, entry, this.entries, this.map);
                offsets.put(info, previousPos);
                previousPos += info.length();
            }
            int[] perm = new int[current.length];
            int currentPos = 0;
            int permSize = 0;
            LinkedList<Children.Entry> reorderedEntries = null;
            for (Children.Entry entry : newEntries) {
                Info info = this.map.get(entry);
                if (info == null) {
                    info = new Info(entry);
                    toAdd.add(info);
                } else {
                    int len = info.length();
                    if (reorderedEntries == null) {
                        reorderedEntries = new LinkedList<Children.Entry>();
                    }
                    reorderedEntries.add(entry);
                    Integer previousInt = (Integer)offsets.get(info);
                    int previousPos2 = previousInt;
                    if (currentPos != previousPos2) {
                        for (int i = 0; i < len; ++i) {
                            perm[previousPos2 + i] = 1 + currentPos + i;
                        }
                        permSize += len;
                    }
                }
                currentPos += info.length();
            }
            if (permSize > 0) {
                for (int i = 0; i < perm.length; ++i) {
                    if (perm[i] == 0) {
                        perm[i] = i;
                        continue;
                    }
                    int n = i;
                    perm[n] = perm[n] - 1;
                }
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Entries before reordering: " + this.entries);
                    LOGGER.finer("Entries after reordering: " + reorderedEntries);
                }
                this.entries = reorderedEntries;
                this.checkConsistency();
                this.clearNodes();
                Node p = this.children.parent;
                if (p != null) {
                    p.fireReorderChange(perm);
                }
            }
            return toAdd;
        }

        private void updateAdd(Collection<Info> infos, List<Children.Entry> entries) {
            assert (Children.MUTEX.isWriteAccess());
            LinkedList<Node> nodes = new LinkedList<Node>();
            for (Info info : infos) {
                nodes.addAll(info.nodes(false));
                this.map.put(info.entry, info);
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Entries before updateAdd(): " + this.entries);
                LOGGER.finer("Entries after updateAdd(): " + entries);
            }
            this.entries = entries;
            this.checkConsistency();
            if (!nodes.isEmpty()) {
                this.clearNodes();
                this.notifyAdd(nodes);
            }
        }

        @Override
        final void refreshEntry(Children.Entry entry) {
            Collection<Node> newNodes;
            ChildrenArray holder = this.array.get();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("refreshEntry: " + entry + " holder=" + holder);
            }
            if (holder == null) {
                return;
            }
            Node[] current = holder.nodes();
            if (current == null) {
                return;
            }
            this.checkConsistency();
            Info info = this.map.get(entry);
            if (info == null) {
                return;
            }
            Collection<Node> oldNodes = info.nodes(false);
            if (((Object)oldNodes).equals(newNodes = info.entry.nodes(null))) {
                return;
            }
            HashSet<Node> toRemove = new HashSet<Node>(oldNodes);
            toRemove.removeAll(new HashSet<Node>(newNodes));
            if (!toRemove.isEmpty()) {
                oldNodes.removeAll(toRemove);
                this.clearNodes();
                this.notifyRemove(toRemove, current);
                current = holder.nodes();
            }
            List<Node> toAdd = this.refreshOrder(entry, oldNodes, newNodes);
            info.useNodes(newNodes);
            if (!toAdd.isEmpty()) {
                this.clearNodes();
                this.notifyAdd(toAdd);
            }
        }

        private List<Node> refreshOrder(Children.Entry entry, Collection<Node> oldNodes, Collection<Node> newNodes) {
            LinkedList<Node> toAdd = new LinkedList<Node>();
            HashSet<Node> oldNodesSet = new HashSet<Node>(oldNodes);
            HashSet<Node> toProcess = new HashSet<Node>(oldNodesSet);
            Node[] permArray = new Node[oldNodes.size()];
            Iterator<Node> it2 = newNodes.iterator();
            int pos = 0;
            while (it2.hasNext()) {
                Node n = it2.next();
                if (oldNodesSet.remove(n)) {
                    permArray[pos++] = n;
                    continue;
                }
                if (!toProcess.contains(n)) {
                    toAdd.add(n);
                    continue;
                }
                it2.remove();
            }
            int[] perm = NodeOp.computePermutation(oldNodes.toArray(new Node[oldNodes.size()]), permArray);
            if (perm != null) {
                this.clearNodes();
                this.findInfo(entry).useNodes(Arrays.asList(permArray));
                Node p = this.children.parent;
                if (p != null) {
                    p.fireReorderChange(perm);
                }
            }
            return toAdd;
        }

        Node[] notifyRemove(Collection<Node> nodes, Node[] current) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("notifyRemove: " + nodes);
                LOGGER.finer("Current     : " + Arrays.asList(current));
            }
            Node[] arr = nodes.toArray(new Node[nodes.size()]);
            if (this.children.parent != null) {
                if (this.children.getEntrySupport() == this) {
                    this.children.parent.fireSubNodesChange(false, arr, current);
                }
                for (Node n : nodes) {
                    n.deassignFrom(this.children);
                    n.fireParentNodeChange(this.children.parent, null);
                }
            }
            this.children.destroyNodes(arr);
            return arr;
        }

        void notifyAdd(Collection<Node> nodes) {
            Node n2;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("notifyAdd: " + nodes);
            }
            for (Node n2 : nodes) {
                n2.assignTo(this.children, -1);
                n2.fireParentNodeChange(null, this.children.parent);
            }
            Node[] arr = nodes.toArray(new Node[nodes.size()]);
            n2 = this.children.parent;
            if (n2 != null && this.children.getEntrySupport() == this) {
                n2.fireSubNodesChange(true, arr, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node[] testNodes() {
            ChildrenArray arr = this.array.get();
            if (arr == null) {
                return null;
            }
            try {
                Children.PR.enterReadAccess();
                Node[] nodeArray = arr.nodes();
                return nodeArray;
            }
            finally {
                Children.PR.exitReadAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ChildrenArray getArray(boolean[] cannotWorkBetter) {
            ChildrenArray arr;
            block27: {
                Object object;
                boolean LOG_ENABLED;
                block26: {
                    class SetAndNotify
                    implements Runnable {
                        public ChildrenArray toSet;
                        public Children whatSet;

                        SetAndNotify() {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = LOCK;
                            synchronized (object) {
                                Default.this.initThread = null;
                                LOCK.notifyAll();
                            }
                            if (LOG_ENABLED) {
                                LOGGER.finer("notifyAll done");
                            }
                        }
                    }
                    block25: {
                        LOG_ENABLED = LOGGER.isLoggable(Level.FINER);
                        boolean doInitialize = false;
                        object = LOCK;
                        synchronized (object) {
                            arr = this.array.get();
                            if (arr == null) {
                                arr = new ChildrenArray();
                                this.registerChildrenArray(arr, true);
                                doInitialize = true;
                                this.initThread = Thread.currentThread();
                            }
                        }
                        if (!doInitialize) break block26;
                        if (LOG_ENABLED) {
                            LOGGER.finer("Initialize " + this + " on " + Thread.currentThread());
                        }
                        try {
                            this.children.callAddNotify();
                            if (!LOG_ENABLED) break block25;
                            LOGGER.finer("addNotify successfully called for " + this + " on " + Thread.currentThread());
                        }
                        catch (Throwable throwable) {
                            boolean notifyLater = Children.MUTEX.isReadAccess();
                            if (LOG_ENABLED) {
                                LOGGER.finer("notifyAll for " + this + " on " + Thread.currentThread() + "  notifyLater: " + notifyLater);
                            }
                            arr.entrySupport = this;
                            this.inited = true;
                            SetAndNotify setAndNotify = new SetAndNotify();
                            setAndNotify.toSet = arr;
                            setAndNotify.whatSet = this.children;
                            if (notifyLater) {
                                Children.MUTEX.postWriteRequest((Runnable)setAndNotify);
                            } else {
                                setAndNotify.run();
                            }
                            throw throwable;
                        }
                    }
                    boolean notifyLater = Children.MUTEX.isReadAccess();
                    if (LOG_ENABLED) {
                        LOGGER.finer("notifyAll for " + this + " on " + Thread.currentThread() + "  notifyLater: " + notifyLater);
                    }
                    arr.entrySupport = this;
                    this.inited = true;
                    SetAndNotify setAndNotify = new SetAndNotify();
                    setAndNotify.toSet = arr;
                    setAndNotify.whatSet = this.children;
                    if (notifyLater) {
                        Children.MUTEX.postWriteRequest((Runnable)setAndNotify);
                    } else {
                        setAndNotify.run();
                    }
                    break block27;
                }
                if (this.initThread != null) {
                    if (Children.MUTEX.isReadAccess() || Children.MUTEX.isWriteAccess() || this.initThread == Thread.currentThread()) {
                        if (LOG_ENABLED) {
                            LOGGER.log(Level.FINER, "cannot initialize better " + this + " on " + Thread.currentThread() + " read access: " + Children.MUTEX.isReadAccess() + " write access: " + Children.MUTEX.isWriteAccess() + " initThread: " + this.initThread);
                        }
                        if (cannotWorkBetter != null) {
                            cannotWorkBetter[0] = true;
                        }
                        arr.entrySupport = this;
                        return arr;
                    }
                    object = LOCK;
                    synchronized (object) {
                        while (this.initThread != null) {
                            if (LOG_ENABLED) {
                                LOGGER.finer("waiting for children for " + this + " on " + Thread.currentThread());
                            }
                            try {
                                LOCK.wait();
                            }
                            catch (InterruptedException ex) {}
                        }
                    }
                    if (LOG_ENABLED) {
                        LOGGER.finer(" children are here for " + this + " on " + Thread.currentThread() + " children " + this.children);
                    }
                }
            }
            return arr;
        }

        private void clearNodes() {
            ChildrenArray arr;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("  clearNodes()");
            }
            if ((arr = this.array.get()) != null) {
                arr.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void registerChildrenArray(ChildrenArray chArr, boolean weak) {
            boolean LOG_ENABLED = LOGGER.isLoggable(Level.FINER);
            if (LOG_ENABLED) {
                LOGGER.finer("registerChildrenArray: " + chArr + " weak: " + weak);
            }
            Object object = LOCK;
            synchronized (object) {
                if (this.array != null && this.array.get() == chArr && ((ChArrRef)this.array).isWeak() == weak) {
                    return;
                }
                this.array = new ChArrRef(chArr, weak);
            }
            if (LOG_ENABLED) {
                LOGGER.finer("pointed by: " + chArr + " to: " + this.array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void finalizedChildrenArray(Reference caller) {
            assert (caller.get() == null) : "Should be null";
            try {
                Children.PR.enterWriteAccess();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.fine("previous array: " + this.array + " caller: " + caller);
                }
                Object object = LOCK;
                synchronized (object) {
                    if (this.array == caller && this.children.getEntrySupport() == this) {
                        this.mustNotifySetEnties = false;
                        this.array = EMPTY;
                        this.inited = false;
                        this.children.callRemoveNotify();
                        assert (this.array == EMPTY);
                    }
                }
            }
            finally {
                Children.PR.exitWriteAccess();
            }
        }

        private class ChArrRef
        extends WeakReference<ChildrenArray>
        implements Runnable {
            private final ChildrenArray chArr;

            public ChArrRef(ChildrenArray referent, boolean weak) {
                super(referent, Utilities.activeReferenceQueue());
                this.chArr = weak ? null : referent;
            }

            @Override
            public ChildrenArray get() {
                return this.chArr != null ? this.chArr : (ChildrenArray)super.get();
            }

            boolean isWeak() {
                return this.chArr == null;
            }

            @Override
            public void run() {
                Default.this.finalizedChildrenArray(this);
            }
        }

        static class DefaultSnapshot
        extends AbstractList<Node> {
            private Node[] nodes;
            Object holder;

            public DefaultSnapshot(Node[] nodes, ChildrenArray cha) {
                this.nodes = nodes;
                this.holder = cha;
            }

            @Override
            public Node get(int index) {
                return this.nodes != null && index < this.nodes.length ? this.nodes[index] : null;
            }

            @Override
            public int size() {
                return this.nodes != null ? this.nodes.length : 0;
            }
        }

        final class Info {
            int length;
            final Children.Entry entry;

            public Info(Children.Entry entry) {
                this.entry = entry;
            }

            public Collection<Node> nodes(boolean hasToExist) {
                assert (!hasToExist || Default.this.array.get() != null) : "ChildrenArray is not initialized";
                ChildrenArray arr = Default.this.getArray(null);
                return arr.nodesFor(this, hasToExist);
            }

            public void useNodes(Collection<Node> nodes) {
                ChildrenArray arr = Default.this.getArray(null);
                arr.useNodes(this, nodes);
                for (Node n : nodes) {
                    n.assignTo(Default.this.children, -1);
                    n.fireParentNodeChange(null, Default.this.children.parent);
                }
            }

            public int length() {
                return this.length;
            }

            public String toString() {
                return "Children.Info[" + this.entry + ",length=" + this.length + "]";
            }
        }
    }
}

