/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.queries.VisibilityQuery;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openidex.search.FileObjectFilter;

final class VisibilityFilter
implements FileObjectFilter {
    VisibilityFilter() {
    }

    @Override
    public boolean searchFile(FileObject file) throws IllegalArgumentException {
        if (file.isFolder()) {
            throw new IllegalArgumentException("file (not folder) expected");
        }
        return this.isPermittedByQuery(file) && this.isPrimaryFile(file);
    }

    private boolean isPermittedByQuery(FileObject file) {
        return VisibilityQuery.getDefault().isVisible(file);
    }

    private boolean isPrimaryFile(FileObject file) {
        try {
            DataObject dob = DataObject.find((FileObject)file);
            return dob.getPrimaryFile().equals(file);
        }
        catch (DataObjectNotFoundException ex) {
            String msg = "DataObject not found for file:" + file;
            Logger logger = Logger.getLogger(VisibilityFilter.class.getName());
            logger.log(Level.INFO, msg, ex);
            return true;
        }
    }

    @Override
    public int traverseFolder(FileObject folder) throws IllegalArgumentException {
        if (!folder.isFolder()) {
            throw new IllegalArgumentException("folder expected");
        }
        return VisibilityQuery.getDefault().isVisible(folder) ? 1 : 0;
    }
}

