/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.configurations;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class M2ConfigProvider
implements ProjectConfigurationProvider<M2Configuration> {
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private NbMavenProjectImpl project;
    private List<M2Configuration> profiles = null;
    private List<M2Configuration> shared = null;
    private List<M2Configuration> nonshared = null;
    private final M2Configuration DEFAULT;
    private M2Configuration active;
    private String initialActive;
    private AuxiliaryConfiguration aux;
    private ProjectProfileHandler profileHandler;
    private PropertyChangeListener propertyChange;
    static String NAMESPACE = "http://www.netbeans.org/ns/maven-config-data/1";
    static String ROOT = "config-data";
    static String ENABLED = "enabled";
    static String ACTIVATED = "activated";
    static String CONFIGURATIONS = "configurations";
    static String CONFIG = "configuration";
    static String PROPERTY = "property";
    static String PROPERTY_NAME_ATTR = "name";
    static String CONFIG_PROFILES_ATTR = "profiles";
    static String CONFIG_ID_ATTR = "id";

    public M2ConfigProvider(NbMavenProjectImpl proj, AuxiliaryConfiguration aux, ProjectProfileHandler prof) {
        NodeList list;
        this.project = proj;
        this.aux = aux;
        this.profileHandler = prof;
        this.DEFAULT = M2Configuration.createDefault(this.project);
        Element el = aux.getConfigurationFragment(ROOT, NAMESPACE, false);
        if (el != null && (list = el.getElementsByTagNameNS(NAMESPACE, ACTIVATED)).getLength() > 0) {
            Element enEl = (Element)list.item(0);
            this.initialActive = new String(enEl.getTextContent());
        }
        this.active = this.DEFAULT;
        this.propertyChange = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("MavenProject".equals(evt.getPropertyName())) {
                    M2ConfigProvider m2ConfigProvider = M2ConfigProvider.this;
                    synchronized (m2ConfigProvider) {
                        M2ConfigProvider.this.profiles = null;
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            M2ConfigProvider.this.checkActiveAgainstAll(M2ConfigProvider.this.getConfigurations(), false);
                            M2ConfigProvider.this.firePropertyChange();
                        }
                    });
                }
            }
        };
    }

    private void checkActiveAgainstAll(Collection<M2Configuration> confs, boolean async) {
        boolean found = false;
        for (M2Configuration conf : confs) {
            if (!conf.getId().equals(this.active.getId())) continue;
            found = true;
            break;
        }
        if (!found) {
            Runnable dothis = new Runnable(){

                @Override
                public void run() {
                    try {
                        M2ConfigProvider.this.doSetActiveConfiguration(M2ConfigProvider.this.DEFAULT, M2ConfigProvider.this.active);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            if (async) {
                RequestProcessor.getDefault().post(dothis);
            } else {
                dothis.run();
            }
        }
    }

    private synchronized Collection<M2Configuration> getConfigurations(boolean skipProfiles) {
        if (this.profiles == null && !skipProfiles) {
            this.profiles = this.createProfilesList();
        }
        if (this.shared == null) {
            this.shared = this.readConfiguration(true);
        }
        if (this.nonshared == null) {
            this.nonshared = this.readConfiguration(false);
        }
        ArrayList<M2Configuration> toRet = new ArrayList<M2Configuration>();
        toRet.add(this.DEFAULT);
        toRet.addAll(this.shared);
        toRet.addAll(this.nonshared);
        if (!skipProfiles) {
            Iterator<M2Configuration> it = this.profiles.iterator();
            while (it.hasNext()) {
                M2Configuration c = it.next();
                if (!toRet.contains(c)) {
                    toRet.add(c);
                    continue;
                }
                it.remove();
            }
        }
        return toRet;
    }

    public synchronized Collection<M2Configuration> getConfigurations() {
        return this.getConfigurations(false);
    }

    public M2Configuration getDefaultConfig() {
        return this.DEFAULT;
    }

    public synchronized Collection<M2Configuration> getProfileConfigurations() {
        this.getConfigurations();
        return this.profiles;
    }

    public synchronized Collection<M2Configuration> getSharedConfigurations() {
        this.getConfigurations();
        return this.shared;
    }

    public synchronized Collection<M2Configuration> getNonSharedConfigurations() {
        this.getConfigurations();
        return this.nonshared;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public void customize() {
        CustomizerProviderImpl prv = (CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class);
        prv.showCustomizer("CONFIGURATION");
    }

    public boolean configurationsAffectAction(String action) {
        return !"delete".equals(action) && !"copy".equals(action) && !"move".equals(action);
    }

    public synchronized M2Configuration getActiveConfiguration() {
        Collection<M2Configuration> confs = this.getConfigurations(false);
        if (this.initialActive != null) {
            for (M2Configuration conf : confs) {
                if (!this.initialActive.equals(conf.getId())) continue;
                this.active = conf;
                this.initialActive = null;
                break;
            }
            if (this.initialActive != null) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            M2ConfigProvider.this.doSetActiveConfiguration(M2ConfigProvider.this.DEFAULT, null);
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
                this.initialActive = null;
            }
        }
        this.checkActiveAgainstAll(confs, true);
        return this.active;
    }

    public synchronized void setConfigurations(List<M2Configuration> shared, List<M2Configuration> nonshared, boolean includeProfiles) {
        M2ConfigProvider.writeAuxiliaryData(this.aux, true, shared);
        M2ConfigProvider.writeAuxiliaryData(this.aux, false, nonshared);
        this.shared = shared;
        this.nonshared = nonshared;
        if (this.active != null) {
            M2Configuration newActive;
            if (shared.contains(this.active)) {
                this.active = newActive = shared.get(shared.indexOf(this.active));
            }
            if (nonshared.contains(this.active)) {
                this.active = newActive = nonshared.get(nonshared.indexOf(this.active));
            }
        }
        this.profiles = null;
        this.firePropertyChange();
    }

    public synchronized void setActiveConfiguration(M2Configuration configuration) throws IllegalArgumentException, IOException {
        if (this.active == configuration || this.active != null && this.active.equals(configuration)) {
            return;
        }
        this.doSetActiveConfiguration(configuration, this.active);
        NbMavenProject.fireMavenProjectReload(this.project);
    }

    private synchronized void doSetActiveConfiguration(M2Configuration newone, M2Configuration old) throws IllegalArgumentException, IOException {
        this.active = newone;
        M2ConfigProvider.writeAuxiliaryData(this.aux, ACTIVATED, this.active.getId());
        this.support.firePropertyChange("activeConfiguration", old, this.active);
    }

    private List<M2Configuration> createProfilesList() {
        List<String> profs = this.profileHandler.getAllProfiles();
        ArrayList<M2Configuration> config = new ArrayList<M2Configuration>();
        for (String prof : profs) {
            M2Configuration c = new M2Configuration(prof, this.project);
            c.setActivatedProfiles(Collections.singletonList(prof));
            config.add(c);
        }
        return config;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener lst) {
        if (this.support.getPropertyChangeListeners().length == 0) {
            this.project.getProjectWatcher().addPropertyChangeListener(this.propertyChange);
        }
        this.support.addPropertyChangeListener(lst);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener lst) {
        this.support.removePropertyChangeListener(lst);
        if (this.support.getPropertyChangeListeners().length == 0) {
            this.project.getProjectWatcher().removePropertyChangeListener(this.propertyChange);
        }
    }

    private void firePropertyChange() {
        this.support.firePropertyChange("configurations", null, null);
    }

    private List<M2Configuration> readConfiguration(boolean shared) {
        NodeList list;
        Element el = this.aux.getConfigurationFragment(ROOT, NAMESPACE, shared);
        if (el != null && (list = el.getElementsByTagNameNS(NAMESPACE, CONFIG)).getLength() > 0) {
            ArrayList<M2Configuration> toRet = new ArrayList<M2Configuration>();
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                Element enEl = (Element)list.item(i);
                M2Configuration c = new M2Configuration(enEl.getAttribute(CONFIG_ID_ATTR), this.project);
                String profs = enEl.getAttribute(CONFIG_PROFILES_ATTR);
                if (profs != null) {
                    String[] s = profs.split(" ");
                    ArrayList<String> prf = new ArrayList<String>();
                    for (String s2 : s) {
                        if (s2.trim().length() <= 0) continue;
                        prf.add(s2.trim());
                    }
                    c.setActivatedProfiles(prf);
                }
                NodeList ps = enEl.getElementsByTagName(PROPERTY);
                for (int y = 0; y < ps.getLength(); ++y) {
                    Element propEl = (Element)ps.item(y);
                    String key = propEl.getAttribute(PROPERTY_NAME_ATTR);
                    String value = propEl.getTextContent();
                    if (key == null || value == null) continue;
                    c.getProperties().setProperty(key, value);
                }
                toRet.add(c);
            }
            return toRet;
        }
        return new ArrayList<M2Configuration>();
    }

    public static void writeAuxiliaryData(AuxiliaryConfiguration conf, String property, String value) {
        Element enEl;
        NodeList list;
        Element el = conf.getConfigurationFragment(ROOT, NAMESPACE, false);
        if (el == null) {
            el = XMLUtil.createDocument((String)ROOT, (String)NAMESPACE, null, null).getDocumentElement();
        }
        if ((list = el.getElementsByTagNameNS(NAMESPACE, property)).getLength() > 0) {
            enEl = (Element)list.item(0);
        } else {
            enEl = el.getOwnerDocument().createElementNS(NAMESPACE, property);
            el.appendChild(enEl);
        }
        enEl.setTextContent(value);
        conf.putConfigurationFragment(el, false);
    }

    private static void writeAuxiliaryData(AuxiliaryConfiguration conf, boolean shared, List<M2Configuration> configs) {
        Element enEl;
        NodeList list;
        Element el = conf.getConfigurationFragment(ROOT, NAMESPACE, shared);
        if (el == null) {
            el = XMLUtil.createDocument((String)ROOT, (String)NAMESPACE, null, null).getDocumentElement();
        }
        if ((list = el.getElementsByTagNameNS(NAMESPACE, CONFIGURATIONS)).getLength() > 0) {
            enEl = (Element)list.item(0);
            NodeList nl = enEl.getChildNodes();
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                enEl.removeChild(nl.item(0));
            }
        } else {
            enEl = el.getOwnerDocument().createElementNS(NAMESPACE, CONFIGURATIONS);
            el.appendChild(enEl);
        }
        for (M2Configuration config : configs) {
            Element child = enEl.getOwnerDocument().createElementNS(NAMESPACE, CONFIG);
            child.setAttribute(CONFIG_ID_ATTR, config.getId());
            child.setAttribute(CONFIG_PROFILES_ATTR, StringUtils.join(config.getActivatedProfiles().iterator(), (String)" "));
            Enumeration<?> en = config.getProperties().propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = config.getProperties().getProperty(key);
                if (key == null || value == null) continue;
                Element prop = enEl.getOwnerDocument().createElementNS(NAMESPACE, PROPERTY);
                prop.setAttribute(PROPERTY_NAME_ATTR, key);
                prop.setTextContent(value);
                child.appendChild(prop);
            }
            enEl.appendChild(child);
        }
        conf.putConfigurationFragment(el, shared);
    }
}

