/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.lucene;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.LucenePackage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.parsing.lucene.BitSetCollector;
import org.netbeans.modules.parsing.lucene.Evictable;
import org.netbeans.modules.parsing.lucene.IndexCacheFactory;
import org.netbeans.modules.parsing.lucene.TermCollector;
import org.netbeans.modules.parsing.lucene.support.Convertor;
import org.netbeans.modules.parsing.lucene.support.Index;
import org.netbeans.modules.parsing.lucene.support.IndexManager;
import org.netbeans.modules.parsing.lucene.support.LowMemoryWatcher;
import org.netbeans.modules.parsing.lucene.support.StoppableConvertor;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class LuceneIndex
implements Index {
    private static final String PROP_INDEX_POLICY = "java.index.useMemCache";
    private static final String PROP_CACHE_SIZE = "java.index.size";
    private static final boolean debugIndexMerging = Boolean.getBoolean("java.index.debugMerge");
    private static final CachePolicy DEFAULT_CACHE_POLICY = CachePolicy.DYNAMIC;
    private static final float DEFAULT_CACHE_SIZE = 0.05f;
    private static final CachePolicy cachePolicy = LuceneIndex.getCachePolicy();
    private static final Logger LOGGER = Logger.getLogger(LuceneIndex.class.getName());
    private static final FieldSelector ALL_FIELDS = new AllFieldsSelector();
    private static LockFactory lockFactory;
    private final DirCache dirCache;

    public static void setDisabledLocks(boolean disabled) {
        lockFactory = disabled ? NoLockFactory.getNoLockFactory() : null;
    }

    public static LuceneIndex create(File cacheRoot, Analyzer analyzer) throws IOException {
        assert (cacheRoot != null && cacheRoot.exists() && cacheRoot.canRead() && cacheRoot.canWrite());
        return new LuceneIndex(cacheRoot, analyzer);
    }

    private LuceneIndex(File refCacheRoot, Analyzer analyzer) throws IOException {
        assert (refCacheRoot != null);
        assert (analyzer != null);
        this.dirCache = new DirCache(refCacheRoot, cachePolicy, analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void query(@NonNull Collection<? super T> result, @NonNull Convertor<? super Document, T> convertor, @NullAllowed FieldSelector selector, @NullAllowed AtomicBoolean cancel, Query ... queries) throws IOException, InterruptedException {
        Parameters.notNull((CharSequence)"queries", (Object)queries);
        Parameters.notNull((CharSequence)"convertor", convertor);
        Parameters.notNull((CharSequence)"result", result);
        IndexReader in = this.dirCache.getReader();
        if (in == null) {
            LOGGER.log(Level.FINE, "{0} is invalid!", this);
            return;
        }
        if (selector == null) {
            selector = ALL_FIELDS;
        }
        BitSet bs = new BitSet(in.maxDoc());
        BitSetCollector c = new BitSetCollector(bs);
        IndexSearcher searcher = new IndexSearcher(in);
        try {
            for (Query q : queries) {
                if (cancel != null && cancel.get()) {
                    throw new InterruptedException();
                }
                searcher.search(q, (Collector)c);
            }
        }
        finally {
            searcher.close();
        }
        int docNum = bs.nextSetBit(0);
        while (docNum >= 0) {
            if (cancel != null && cancel.get()) {
                throw new InterruptedException();
            }
            Document doc = in.document(docNum, selector);
            T value = convertor.convert((Document)doc);
            if (value != null) {
                result.add(value);
            }
            docNum = bs.nextSetBit(docNum + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void queryTerms(@NonNull Collection<? super T> result, @NullAllowed Term seekTo, @NonNull StoppableConvertor<Term, T> filter, @NullAllowed AtomicBoolean cancel) throws IOException, InterruptedException {
        IndexReader in = this.dirCache.getReader();
        if (in == null) {
            return;
        }
        TermEnum terms = seekTo == null ? in.terms() : in.terms(seekTo);
        try {
            do {
                T vote;
                if (cancel != null && cancel.get()) {
                    throw new InterruptedException();
                }
                Term currentTerm = terms.term();
                if (currentTerm == null || (vote = filter.convert(currentTerm)) == null) continue;
                result.add(vote);
            } while (terms.next());
        }
        catch (StoppableConvertor.Stop stop) {
        }
        finally {
            terms.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, T> void queryDocTerms(@NonNull Map<? super T, Set<S>> result, @NonNull Convertor<? super Document, T> convertor, @NonNull Convertor<? super Term, S> termConvertor, @NullAllowed FieldSelector selector, @NullAllowed AtomicBoolean cancel, Query ... queries) throws IOException, InterruptedException {
        Parameters.notNull((CharSequence)"queries", (Object)queries);
        Parameters.notNull((CharSequence)"slector", (Object)selector);
        Parameters.notNull((CharSequence)"convertor", convertor);
        Parameters.notNull((CharSequence)"termConvertor", termConvertor);
        Parameters.notNull((CharSequence)"result", result);
        IndexReader in = this.dirCache.getReader();
        if (in == null) {
            LOGGER.fine(String.format("LuceneIndex[%s] is invalid!\n", this.toString()));
            return;
        }
        if (selector == null) {
            selector = ALL_FIELDS;
        }
        BitSet bs = new BitSet(in.maxDoc());
        BitSetCollector c = new BitSetCollector(bs);
        IndexSearcher searcher = new IndexSearcher(in);
        TermCollector termCollector = new TermCollector();
        try {
            for (Query q : queries) {
                if (cancel != null && cancel.get()) {
                    throw new InterruptedException();
                }
                if (!(q instanceof TermCollector.TermCollecting)) {
                    throw new IllegalArgumentException(String.format("Query: %s does not implement TermCollecting", q.getClass().getName()));
                }
                ((TermCollector.TermCollecting)q).attach(termCollector);
                searcher.search(q, (Collector)c);
            }
        }
        finally {
            searcher.close();
        }
        boolean logged = false;
        int docNum = bs.nextSetBit(0);
        while (docNum >= 0) {
            if (cancel != null && cancel.get()) {
                throw new InterruptedException();
            }
            Document doc = in.document(docNum, selector);
            T value = convertor.convert((Document)doc);
            if (value != null) {
                Set<Term> terms = termCollector.get(docNum);
                if (terms != null) {
                    result.put(value, LuceneIndex.convertTerms(termConvertor, terms));
                } else {
                    if (!logged) {
                        LOGGER.log(Level.WARNING, "Index info [maxDoc: {0} numDoc: {1} docs: {2}]", new Object[]{in.maxDoc(), in.numDocs(), termCollector.docs()});
                        logged = true;
                    }
                    LOGGER.log(Level.WARNING, "No terms found for doc: {0}", docNum);
                }
            }
            docNum = bs.nextSetBit(docNum + 1);
        }
    }

    private static <T> Set<T> convertTerms(Convertor<? super Term, T> convertor, Set<? extends Term> terms) {
        HashSet<T> result = new HashSet<T>(terms.size());
        for (Term term : terms) {
            result.add(convertor.convert(term));
        }
        return result;
    }

    @Override
    public <S, T> void store(final @NonNull Collection<T> toAdd, final @NonNull Collection<S> toDelete, final @NonNull Convertor<? super T, ? extends Document> docConvertor, final @NonNull Convertor<? super S, ? extends Query> queryConvertor, final boolean optimize) throws IOException {
        try {
            IndexManager.writeAccess(new IndexManager.Action<Void>(){

                @Override
                public Void run() throws IOException, InterruptedException {
                    LuceneIndex.this._store(toAdd, toDelete, docConvertor, queryConvertor, optimize);
                    return null;
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S, T> void _store(@NonNull Collection<T> data, @NonNull Collection<S> toDelete, @NonNull Convertor<? super T, ? extends Document> docConvertor, @NonNull Convertor<? super S, ? extends Query> queryConvertor, boolean optimize) throws IOException {
        assert (IndexManager.holdsWriteLock());
        boolean create = !this.dirCache.exists();
        IndexWriter out = this.dirCache.getWriter(create);
        try {
            if (!create) {
                for (S td : toDelete) {
                    out.deleteDocuments(queryConvertor.convert(td));
                }
            }
            if (debugIndexMerging) {
                out.setInfoStream(System.err);
            }
            LowMemoryWatcher lmListener = LowMemoryWatcher.getInstance();
            RAMDirectory memDir = null;
            IndexWriter activeOut = null;
            if (lmListener.isLowMemory()) {
                activeOut = out;
            } else {
                memDir = new RAMDirectory();
                activeOut = new IndexWriter((Directory)memDir, this.dirCache.getAnalyzer(), true, IndexWriter.MaxFieldLength.LIMITED);
            }
            Iterator<T> it = data.iterator();
            while (it.hasNext()) {
                T entry = it.next();
                it.remove();
                Document doc = docConvertor.convert(entry);
                activeOut.addDocument(doc);
                if (memDir == null || !lmListener.isLowMemory()) continue;
                activeOut.close();
                out.addIndexesNoOptimize(new Directory[]{memDir});
                memDir = new RAMDirectory();
                activeOut = new IndexWriter((Directory)memDir, this.dirCache.getAnalyzer(), true, IndexWriter.MaxFieldLength.LIMITED);
            }
            if (memDir != null) {
                activeOut.close();
                out.addIndexesNoOptimize(new Directory[]{memDir});
                activeOut = null;
                memDir = null;
            }
            if (optimize) {
                out.optimize();
            }
        }
        catch (RuntimeException e) {
            throw (RuntimeException)Exceptions.attachMessage((Throwable)e, (String)("Lucene Index Folder: " + this.dirCache.folder.getAbsolutePath()));
        }
        catch (IOException e) {
            throw (IOException)Exceptions.attachMessage((Throwable)e, (String)("Lucene Index Folder: " + this.dirCache.folder.getAbsolutePath()));
        }
        finally {
            try {
                out.close();
            }
            finally {
                this.dirCache.refreshReader();
            }
        }
    }

    @Override
    public Index.Status getStatus(boolean force) throws IOException {
        return this.dirCache.getStatus(force);
    }

    @Override
    public void clear() throws IOException {
        try {
            IndexManager.writeAccess(new IndexManager.Action<Void>(){

                @Override
                public Void run() throws IOException, InterruptedException {
                    LuceneIndex.this.dirCache.clear();
                    return null;
                }
            });
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Closing index: {0} {1}", new Object[]{this.dirCache.toString(), Thread.currentThread().getStackTrace()});
        }
        this.dirCache.close(true);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.dirCache.toString() + "]";
    }

    private static CachePolicy getCachePolicy() {
        String value = System.getProperty(PROP_INDEX_POLICY);
        if (Boolean.TRUE.toString().equals(value) || CachePolicy.ALL.getSystemName().equals(value)) {
            return CachePolicy.ALL;
        }
        if (Boolean.FALSE.toString().equals(value) || CachePolicy.NONE.getSystemName().equals(value)) {
            return CachePolicy.NONE;
        }
        if (CachePolicy.DYNAMIC.getSystemName().equals(value)) {
            return CachePolicy.DYNAMIC;
        }
        return DEFAULT_CACHE_POLICY;
    }

    private static final class DirCache
    implements Evictable {
        private static final String CACHE_LOCK_PREFIX = "nb-lock";
        private static final RequestProcessor RP = new RequestProcessor(LuceneIndex.class.getName(), 1);
        private static final long maxCacheSize = DirCache.getCacheSize();
        private static volatile long currentCacheSize;
        private final File folder;
        private final CachePolicy cachePolicy;
        private final Analyzer analyzer;
        private FSDirectory fsDir;
        private RAMDirectory memDir;
        private CleanReference ref;
        private IndexReader reader;
        private volatile boolean closed;
        private volatile Index.Status validCache;

        private DirCache(@NonNull File folder, @NonNull CachePolicy cachePolicy, @NonNull Analyzer analyzer) throws IOException {
            assert (folder != null);
            assert (cachePolicy != null);
            assert (analyzer != null);
            this.folder = folder;
            this.fsDir = DirCache.createFSDirectory(folder);
            this.cachePolicy = cachePolicy;
            this.analyzer = analyzer;
        }

        Analyzer getAnalyzer() {
            return this.analyzer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void clear() throws IOException {
            block11: {
                this.checkPreconditions();
                this.close(false);
                try {
                    File cacheDir;
                    File[] children;
                    String[] content = this.fsDir.listAll();
                    boolean dirty = false;
                    if (content != null) {
                        for (String file : content) {
                            try {
                                this.fsDir.deleteFile(file);
                            }
                            catch (IOException e) {
                                if (!this.fsDir.fileExists(file)) continue;
                                dirty = true;
                            }
                        }
                    }
                    if (!dirty || (children = (cacheDir = this.fsDir.getFile()).listFiles()) == null) break block11;
                    for (File child : children) {
                        if (child.delete()) continue;
                        Class<?> c = this.fsDir.getClass();
                        int refCount = -1;
                        try {
                            Field field = c.getDeclaredField("refCount");
                            field.setAccessible(true);
                            refCount = field.getInt(this.fsDir);
                        }
                        catch (NoSuchFieldException e) {
                        }
                        catch (IllegalAccessException e) {
                            // empty catch block
                        }
                        Map<Thread, StackTraceElement[]> sts = Thread.getAllStackTraces();
                        throw new IOException("Cannot delete: " + child.getAbsolutePath() + "(" + child.exists() + "," + child.canRead() + "," + child.canWrite() + "," + cacheDir.canRead() + "," + cacheDir.canWrite() + "," + refCount + "," + sts + ")");
                    }
                }
                finally {
                    this.close(true);
                    this.fsDir = DirCache.createFSDirectory(this.folder);
                    this.closed = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void close(boolean closeFSDir) throws IOException {
            try {
                try {
                    if (this.reader != null) {
                        this.reader.close();
                        this.reader = null;
                    }
                }
                finally {
                    if (this.memDir != null) {
                        assert (this.cachePolicy.hasMemCache());
                        if (this.ref != null) {
                            this.ref.clear();
                        }
                        RAMDirectory tmpDir = this.memDir;
                        this.memDir = null;
                        tmpDir.close();
                    }
                }
            }
            finally {
                if (closeFSDir) {
                    this.closed = true;
                    this.fsDir.close();
                }
            }
        }

        boolean exists() {
            try {
                return IndexReader.indexExists((Directory)this.fsDir);
            }
            catch (IOException e) {
                return false;
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.INFO, "Broken index: " + this.folder.getAbsolutePath(), e);
                return false;
            }
        }

        Index.Status getStatus(boolean force) throws IOException {
            this.checkPreconditions();
            Index.Status valid = this.validCache;
            if (force || valid == null) {
                Collection<? extends String> locks = this.getOrphanLock();
                Index.Status res = Index.Status.INVALID;
                if (!locks.isEmpty()) {
                    LOGGER.log(Level.WARNING, "Broken (locked) index folder: {0}", this.folder.getAbsolutePath());
                    for (String string : locks) {
                        this.fsDir.deleteFile(string);
                    }
                    if (force) {
                        this.clear();
                    }
                } else if (!this.exists()) {
                    res = Index.Status.EMPTY;
                } else if (force) {
                    try {
                        this.getReader();
                        res = Index.Status.VALID;
                    }
                    catch (IOException e) {
                        this.clear();
                    }
                    catch (RuntimeException e) {
                        this.clear();
                    }
                } else {
                    res = Index.Status.VALID;
                }
                this.validCache = valid = res;
            }
            return valid;
        }

        IndexWriter getWriter(boolean create) throws IOException {
            this.checkPreconditions();
            this.hit();
            try {
                IndexWriter iw = new IndexWriter((Directory)this.fsDir, this.analyzer, create, IndexWriter.MaxFieldLength.LIMITED);
                iw.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
                return iw;
            }
            catch (IOException ioe) {
                throw this.annotateException(ioe);
            }
        }

        synchronized IndexReader getReader() throws IOException {
            this.checkPreconditions();
            this.hit();
            if (this.reader == null) {
                if (this.validCache != Index.Status.VALID) {
                    return null;
                }
                try {
                    FSDirectory source;
                    if (this.cachePolicy.hasMemCache()) {
                        this.memDir = new RAMDirectory((Directory)this.fsDir);
                        if (this.cachePolicy == CachePolicy.DYNAMIC) {
                            this.ref = new CleanReference(new RAMDirectory[]{this.memDir});
                        }
                        source = this.memDir;
                    } else {
                        source = this.fsDir;
                    }
                    assert (source != null);
                    this.reader = new NoNormsReader(IndexReader.open((Directory)source, (boolean)true));
                }
                catch (FileNotFoundException fnf) {
                }
                catch (IOException ioe) {
                    throw this.annotateException(ioe);
                }
            }
            return this.reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void refreshReader() throws IOException {
            if (IndexWriter.isLocked((Directory)this.fsDir)) {
                IndexWriter.unlock((Directory)this.fsDir);
            }
            try {
                IndexReader newReader;
                if (this.cachePolicy.hasMemCache()) {
                    this.close(false);
                } else if (this.reader != null && (newReader = this.reader.reopen()) != this.reader) {
                    this.reader.close();
                    this.reader = newReader;
                }
            }
            finally {
                this.validCache = Index.Status.VALID;
            }
        }

        public String toString() {
            return this.folder.getAbsolutePath();
        }

        @Override
        public void evicted() {
            if (!this.cachePolicy.hasMemCache()) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IndexManager.writeAccess(new IndexManager.Action<Void>(){

                                @Override
                                public Void run() throws IOException, InterruptedException {
                                    DirCache.this.close(false);
                                    LOGGER.log(Level.FINE, "Evicted index: {0}", DirCache.this.folder.getAbsolutePath());
                                    return null;
                                }
                            });
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (InterruptedException ie) {
                            Exceptions.printStackTrace((Throwable)ie);
                        }
                    }
                });
            } else if (this.ref != null && currentCacheSize > maxCacheSize) {
                this.ref.clearHRef();
            }
        }

        private synchronized void hit() {
            if (!this.cachePolicy.hasMemCache()) {
                try {
                    URL url = this.folder.toURI().toURL();
                    IndexCacheFactory.getDefault().getCache().put(url, this);
                }
                catch (MalformedURLException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            } else if (this.ref != null) {
                this.ref.get();
            }
        }

        private Collection<? extends String> getOrphanLock() {
            LinkedList<String> locks = new LinkedList<String>();
            String[] content = this.folder.list();
            if (content != null) {
                for (String name : content) {
                    if (!name.startsWith(CACHE_LOCK_PREFIX)) continue;
                    locks.add(name);
                }
            }
            return locks;
        }

        private void checkPreconditions() throws Index.IndexClosedException {
            if (this.closed) {
                throw new Index.IndexClosedException();
            }
        }

        private IOException annotateException(IOException ioe) {
            StringBuilder message = new StringBuilder();
            File[] children = this.folder.listFiles();
            if (children == null) {
                message.append("Non existing index folder");
            } else {
                message.append("Current Lucene version: ").append(LucenePackage.get().getSpecificationVersion()).append('(').append(LucenePackage.get().getImplementationVersion()).append(")\n");
                for (File c : children) {
                    message.append(c.getName()).append(" f: ").append(c.isFile()).append(" r: ").append(c.canRead()).append(" w: ").append(c.canWrite()).append("\n");
                }
            }
            return (IOException)Exceptions.attachMessage((Throwable)ioe, (String)message.toString());
        }

        private static FSDirectory createFSDirectory(File indexFolder) throws IOException {
            assert (indexFolder != null);
            FSDirectory directory = FSDirectory.open((File)indexFolder, (LockFactory)lockFactory);
            directory.getLockFactory().setLockPrefix(CACHE_LOCK_PREFIX);
            return directory;
        }

        private static long getCacheSize() {
            float per = -1.0f;
            String propVal = System.getProperty(LuceneIndex.PROP_CACHE_SIZE);
            if (propVal != null) {
                try {
                    per = Float.parseFloat(propVal);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (per < 0.0f) {
                per = 0.05f;
            }
            return (long)(per * (float)Runtime.getRuntime().maxMemory());
        }

        private final class CleanReference
        extends SoftReference<RAMDirectory[]>
        implements Runnable {
            private volatile Directory[] hardRef;
            private final AtomicLong size;

            private CleanReference(RAMDirectory[] dir) {
                boolean doHardRef;
                super(dir, Utilities.activeReferenceQueue());
                this.size = new AtomicLong();
                boolean bl = doHardRef = currentCacheSize < maxCacheSize;
                if (doHardRef) {
                    this.hardRef = dir;
                    long _size = dir[0].sizeInBytes();
                    this.size.set(_size);
                    currentCacheSize += _size;
                }
                LOGGER.log(Level.FINEST, "Caching index: {0} cache policy: {1}", new Object[]{DirCache.this.folder.getAbsolutePath(), DirCache.this.cachePolicy.getSystemName()});
            }

            @Override
            public void run() {
                try {
                    LOGGER.log(Level.FINEST, "Dropping cache index: {0} cache policy: {1}", new Object[]{DirCache.this.folder.getAbsolutePath(), DirCache.this.cachePolicy.getSystemName()});
                    DirCache.this.close(false);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }

            @Override
            public void clear() {
                this.clearHRef();
                super.clear();
            }

            void clearHRef() {
                this.hardRef = null;
                long mySize = this.size.getAndSet(0L);
                currentCacheSize -= mySize;
            }
        }
    }

    private static final class CachePolicy
    extends Enum<CachePolicy> {
        public static final /* enum */ CachePolicy NONE = new CachePolicy("none", false);
        public static final /* enum */ CachePolicy DYNAMIC = new CachePolicy("dynamic", true);
        public static final /* enum */ CachePolicy ALL = new CachePolicy("all", true);
        private final String sysName;
        private final boolean hasMemCache;
        private static final /* synthetic */ CachePolicy[] $VALUES;

        public static CachePolicy[] values() {
            return (CachePolicy[])$VALUES.clone();
        }

        public static CachePolicy valueOf(String name) {
            return Enum.valueOf(CachePolicy.class, name);
        }

        private CachePolicy(String sysName, boolean hasMemCache) {
            assert (sysName != null);
            this.sysName = sysName;
            this.hasMemCache = hasMemCache;
        }

        String getSystemName() {
            return this.sysName;
        }

        boolean hasMemCache() {
            return this.hasMemCache;
        }

        static {
            $VALUES = new CachePolicy[]{NONE, DYNAMIC, ALL};
        }
    }

    private static class NoNormsReader
    extends FilterIndexReader {
        private byte[] norms;

        public NoNormsReader(IndexReader reader) {
            super(reader);
        }

        public byte[] norms(String field) throws IOException {
            byte[] _norms = this.fakeNorms();
            return _norms;
        }

        public void norms(String field, byte[] norm, int offset) throws IOException {
            byte[] _norms = this.fakeNorms();
            System.arraycopy(_norms, 0, norm, offset, _norms.length);
        }

        public boolean hasNorms(String field) throws IOException {
            return false;
        }

        protected void doSetNorm(int doc, String field, byte norm) throws CorruptIndexException, IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doClose() throws IOException {
            NoNormsReader noNormsReader = this;
            synchronized (noNormsReader) {
                this.norms = null;
            }
            super.doClose();
        }

        public IndexReader reopen() throws IOException {
            IndexReader newIn = this.in.reopen();
            if (newIn == this.in) {
                return this;
            }
            return new NoNormsReader(newIn);
        }

        private synchronized byte[] fakeNorms() {
            if (this.norms == null) {
                this.norms = new byte[this.maxDoc()];
                Arrays.fill(this.norms, DefaultSimilarity.encodeNorm((float)1.0f));
            }
            return this.norms;
        }
    }

    private static class AllFieldsSelector
    implements FieldSelector {
        private AllFieldsSelector() {
        }

        public FieldSelectorResult accept(String fieldName) {
            return FieldSelectorResult.LOAD;
        }
    }
}

