/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.artifact;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;

class ResolutionManagementInfo {
    private boolean resolutionRequired;
    private ScopeArtifactFilter scopeFilter = new ScopeArtifactFilter();
    private boolean resolvedTransitively;
    private Set enabledProjects = new LinkedHashSet();

    ResolutionManagementInfo(MavenProject mainProject) {
        this.enabledProjects.add(mainProject);
    }

    boolean isResolutionRequired() {
        return this.resolutionRequired;
    }

    void setResolutionRequired(boolean resolutionRequired) {
        this.resolutionRequired = resolutionRequired;
    }

    boolean isResolvedTransitively() {
        return this.resolvedTransitively;
    }

    void setResolvedTransitively(boolean resolvedTransitively) {
        this.resolvedTransitively = resolvedTransitively;
    }

    ScopeArtifactFilter getScopeFilter() {
        return this.scopeFilter;
    }

    void enableCompileScope() {
        this.scopeFilter.setIncludeCompileScope(true);
        this.scopeFilter.setIncludeProvidedScope(true);
        this.scopeFilter.setIncludeSystemScope(true);
    }

    void enableProvidedScope() {
        this.scopeFilter.setIncludeProvidedScope(true);
    }

    void enableRuntimeScope() {
        this.scopeFilter.setIncludeRuntimeScope(true);
        this.scopeFilter.setIncludeCompileScope(true);
    }

    void enableTestScope() {
        this.scopeFilter.setIncludeTestScope(true);
        this.scopeFilter.setIncludeCompileScope(true);
        this.scopeFilter.setIncludeProvidedScope(true);
        this.scopeFilter.setIncludeSystemScope(true);
        this.scopeFilter.setIncludeRuntimeScope(true);
    }

    void enableSystemScope() {
        this.scopeFilter.setIncludeSystemScope(true);
    }

    void enableProjectResolution(MavenProject project) {
        if (!this.enabledProjects.contains(project)) {
            this.enabledProjects.add(project);
        }
    }

    Set getEnabledProjects() {
        return this.enabledProjects;
    }
}

