/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.javadoc.AbstractJavadocMojo;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;

public class JavadocReport
extends AbstractJavadocMojo
implements MavenReport {
    private File reportOutputDirectory;
    private String destDir;
    private String name;
    private String description;

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.name)) {
            return this.getBundle(locale).getString("report.javadoc.name");
        }
        return this.name;
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.description)) {
            return this.getBundle(locale).getString("report.javadoc.description");
        }
        return this.description;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.outputDirectory = this.getReportOutputDirectory();
        this.executeReport(locale);
    }

    public String getOutputName() {
        return this.destDir + "/index";
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        boolean canGenerate = false;
        if (!this.isAggregator() || this.isAggregator() && this.project.isExecutionRoot()) {
            List files;
            try {
                List sourcePaths = this.getSourcePaths();
                files = this.getFiles(sourcePaths);
            }
            catch (MavenReportException e) {
                this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                return false;
            }
            canGenerate = this.canGenerateReport(files);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(" canGenerateReport " + canGenerate + " project " + this.project));
        }
        return canGenerate;
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            return this.outputDirectory;
        }
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.updateReportOutputDirectory(reportOutputDirectory, this.destDir);
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
        this.updateReportOutputDirectory(this.reportOutputDirectory, destDir);
    }

    private void updateReportOutputDirectory(File reportOutputDirectory, String destDir) {
        this.reportOutputDirectory = reportOutputDirectory != null && destDir != null && !reportOutputDirectory.getAbsolutePath().endsWith(destDir) ? new File(reportOutputDirectory, destDir) : reportOutputDirectory;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping javadoc generation");
            return;
        }
        try {
            RenderingContext context = new RenderingContext(this.outputDirectory, this.getOutputName() + ".html");
            SiteRendererSink sink = new SiteRendererSink(context);
            Locale locale = Locale.getDefault();
            this.generate((Sink)sink, locale);
        }
        catch (MavenReportException e) {
            if (this.failOnError) {
                throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation:" + e.getMessage(), (Exception)((Object)e));
            }
            this.getLog().error((CharSequence)("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation:" + e.getMessage()), (Throwable)e);
        }
        catch (RuntimeException e) {
            if (this.failOnError) {
                throw e;
            }
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isAggregator() {
        return this.aggregate;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("javadoc-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

