/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-site-plugin:3.0-beta-3", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Site Plugin", 0);
        this.append(sb, "The Maven Site Plugin is a plugin that generates a site for the current project.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 9 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "attach-descriptor".equals(this.goal)) {
            this.append(sb, "site:attach-descriptor", 0);
            this.append(sb, "Adds the site descriptor (site.xml) to the list of files to be installed/deployed.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Specifies the input encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "locales", 2);
                this.append(sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository (Default: ${localRepository})", 2);
                this.append(sb, "The local repository.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2);
                this.append(sb, "Specifies the output encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportPlugins", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "siteDirectory (Default: ${basedir}/src/site)", 2);
                this.append(sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy".equals(this.goal)) {
            this.append(sb, "site:deploy", 0);
            this.append(sb, "Deploys the generated site using scp or file protocol to the site URL specified in the <distributionManagement> section of the POM.\nFor scp protocol, the website files are packaged into zip archive, then the archive is transfered to the remote host, next it is un-archived. This method of deployment should normally be much faster than making a file by file copy. For file protocol, the files are copied directly to the destination directory.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "chmod (Default: true)", 2);
                this.append(sb, "Whether to run the 'chmod' command on the remote site after the deploy. Defaults to 'true'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodMode (Default: g+w,a+rX)", 2);
                this.append(sb, "The mode used by the 'chmod' command. Only used if chmod = true. Defaults to 'g+w,a+rX'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodOptions (Default: -Rf)", 2);
                this.append(sb, "The options used by the 'chmod' command. Only used if chmod = true. Defaults to '-Rf'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputDirectory", 2);
                this.append(sb, "Directory containing the generated project sites and report distributions.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "effective-site".equals(this.goal)) {
            this.append(sb, "site:effective-site", 0);
            this.append(sb, "Displays the effective site descriptor as an XML for this build, after inheritance and interpolation of site.xml.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attributes", 2);
                this.append(sb, "The template properties for rendering the site.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedSiteDirectory", 2);
                this.append(sb, "Directory containing generated documentation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Specifies the input encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "locales", 2);
                this.append(sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository (Default: ${localRepository})", 2);
                this.append(sb, "The local repository.", 3);
                this.append(sb, "", 0);
                this.append(sb, "moduleExcludes", 2);
                this.append(sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in '-m1.fml' recursively)\nThe configuration looks like this:\n\n\u00a0\u00a0<moduleExcludes>\n\u00a0\u00a0\u00a0\u00a0<moduleType>filename1.ext,**/*sample.ext</moduleType>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0'apt',\u00a0'fml'\u00a0or\u00a0'xdoc'.\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0Here's\u00a0an\u00a0example:\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<xdoc>changes.xml,navigation.xml</xdoc>\n\u00a0\u00a0</moduleExcludes>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "output", 2);
                this.append(sb, "Optional parameter to write the output of this help in a given file, instead of writing to the console.\nNote: Could be a relative path.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2);
                this.append(sb, "Specifies the output encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportPlugins", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositories", 2);
                this.append(sb, "Remote repositories used for the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "siteDirectory (Default: ${basedir}/src/site)", 2);
                this.append(sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "template", 2);
                this.append(sb, "Deprecated. use templateFile or skinning instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Default template page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateDirectory (Default: src/site)", 2);
                this.append(sb, "Deprecated. use templateFile or skinning instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Directory containing the template page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateFile", 2);
                this.append(sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2);
                this.append(sb, "Deprecated. use the standard m2 directory layout", 3);
                this.append(sb, "", 0);
                this.append(sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "site:help", 0);
            this.append(sb, "Display help information on maven-site-plugin.\nCall\n\u00a0\u00a0mvn\u00a0site:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jar".equals(this.goal)) {
            this.append(sb, "site:jar", 0);
            this.append(sb, "Bundles the site output into a JAR so that it can be deployed to a repository.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attach (Default: true)", 2);
                this.append(sb, "Specifies whether to attach the generated artifact to the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "attributes", 2);
                this.append(sb, "The template properties for rendering the site.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName", 2);
                this.append(sb, "Specifies the filename that will be used for the generated jar file. Please note that '-site' will be appended to the file name.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedSiteDirectory", 2);
                this.append(sb, "Directory containing generated documentation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateReports (Default: true)", 2);
                this.append(sb, "Convenience parameter that allows you to disable report generation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateSitemap (Default: false)", 2);
                this.append(sb, "Generate a sitemap. The result will be a 'sitemap.html' file at the site root.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Specifies the input encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jarOutputDirectory", 2);
                this.append(sb, "Specifies the directory where the generated jar file will be put.", 3);
                this.append(sb, "", 0);
                this.append(sb, "locales", 2);
                this.append(sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository (Default: ${localRepository})", 2);
                this.append(sb, "The local repository.", 3);
                this.append(sb, "", 0);
                this.append(sb, "moduleExcludes", 2);
                this.append(sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in '-m1.fml' recursively)\nThe configuration looks like this:\n\n\u00a0\u00a0<moduleExcludes>\n\u00a0\u00a0\u00a0\u00a0<moduleType>filename1.ext,**/*sample.ext</moduleType>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0'apt',\u00a0'fml'\u00a0or\u00a0'xdoc'.\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0Here's\u00a0an\u00a0example:\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<xdoc>changes.xml,navigation.xml</xdoc>\n\u00a0\u00a0</moduleExcludes>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Directory containing the generated project sites and report distributions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2);
                this.append(sb, "Specifies the output encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportPlugins", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositories", 2);
                this.append(sb, "Remote repositories used for the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "siteDirectory (Default: ${basedir}/src/site)", 2);
                this.append(sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "template", 2);
                this.append(sb, "Deprecated. use templateFile or skinning instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Default template page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateDirectory (Default: src/site)", 2);
                this.append(sb, "Deprecated. use templateFile or skinning instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Directory containing the template page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateFile", 2);
                this.append(sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "validate (Default: false)", 2);
                this.append(sb, "Whether to validate xml input documents. If set to true, all input documents in xml format (in particular xdoc and fml) will be validated and any error will lead to a build failure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2);
                this.append(sb, "Deprecated. use the standard m2 directory layout", 3);
                this.append(sb, "", 0);
                this.append(sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run".equals(this.goal)) {
            this.append(sb, "site:run", 0);
            this.append(sb, "Starts the site up, rendering documents as requested for faster editing. It uses Jetty as the web server.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attributes", 2);
                this.append(sb, "The template properties for rendering the site.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedSiteDirectory", 2);
                this.append(sb, "Directory containing generated documentation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Specifies the input encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "locales", 2);
                this.append(sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository (Default: ${localRepository})", 2);
                this.append(sb, "The local repository.", 3);
                this.append(sb, "", 0);
                this.append(sb, "moduleExcludes", 2);
                this.append(sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in '-m1.fml' recursively)\nThe configuration looks like this:\n\n\u00a0\u00a0<moduleExcludes>\n\u00a0\u00a0\u00a0\u00a0<moduleType>filename1.ext,**/*sample.ext</moduleType>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0'apt',\u00a0'fml'\u00a0or\u00a0'xdoc'.\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0Here's\u00a0an\u00a0example:\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<xdoc>changes.xml,navigation.xml</xdoc>\n\u00a0\u00a0</moduleExcludes>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2);
                this.append(sb, "Specifies the output encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 8080)", 2);
                this.append(sb, "The port to execute the HTTP server on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportPlugins", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositories", 2);
                this.append(sb, "Remote repositories used for the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "siteDirectory (Default: ${basedir}/src/site)", 2);
                this.append(sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "template", 2);
                this.append(sb, "Deprecated. use templateFile or skinning instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Default template page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateDirectory (Default: src/site)", 2);
                this.append(sb, "Deprecated. use templateFile or skinning instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Directory containing the template page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateFile", 2);
                this.append(sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tempWebappDirectory", 2);
                this.append(sb, "Where to create the dummy web application.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2);
                this.append(sb, "Deprecated. use the standard m2 directory layout", 3);
                this.append(sb, "", 0);
                this.append(sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "site".equals(this.goal)) {
            this.append(sb, "site:site", 0);
            this.append(sb, "Generates the site for a single project.\nNote that links between module sites in a multi module build will not work.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attributes", 2);
                this.append(sb, "The template properties for rendering the site.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedSiteDirectory", 2);
                this.append(sb, "Directory containing generated documentation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateReports (Default: true)", 2);
                this.append(sb, "Convenience parameter that allows you to disable report generation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateSitemap (Default: false)", 2);
                this.append(sb, "Generate a sitemap. The result will be a 'sitemap.html' file at the site root.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Specifies the input encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "locales", 2);
                this.append(sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository (Default: ${localRepository})", 2);
                this.append(sb, "The local repository.", 3);
                this.append(sb, "", 0);
                this.append(sb, "moduleExcludes", 2);
                this.append(sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in '-m1.fml' recursively)\nThe configuration looks like this:\n\n\u00a0\u00a0<moduleExcludes>\n\u00a0\u00a0\u00a0\u00a0<moduleType>filename1.ext,**/*sample.ext</moduleType>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0'apt',\u00a0'fml'\u00a0or\u00a0'xdoc'.\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0Here's\u00a0an\u00a0example:\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<xdoc>changes.xml,navigation.xml</xdoc>\n\u00a0\u00a0</moduleExcludes>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Directory containing the generated project sites and report distributions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2);
                this.append(sb, "Specifies the output encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportPlugins", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositories", 2);
                this.append(sb, "Remote repositories used for the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "siteDirectory (Default: ${basedir}/src/site)", 2);
                this.append(sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "template", 2);
                this.append(sb, "Deprecated. use templateFile or skinning instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Default template page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateDirectory (Default: src/site)", 2);
                this.append(sb, "Deprecated. use templateFile or skinning instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Directory containing the template page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateFile", 2);
                this.append(sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "validate (Default: false)", 2);
                this.append(sb, "Whether to validate xml input documents. If set to true, all input documents in xml format (in particular xdoc and fml) will be validated and any error will lead to a build failure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2);
                this.append(sb, "Deprecated. use the standard m2 directory layout", 3);
                this.append(sb, "", 0);
                this.append(sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stage".equals(this.goal)) {
            this.append(sb, "site:stage", 0);
            this.append(sb, "Generates a site in a local staging or mock directory based on the site URL specified in the <distributionManagement> section of the POM.\nIt can be used to test that links between module sites in a multi module build works.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attributes", 2);
                this.append(sb, "The template properties for rendering the site.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedSiteDirectory", 2);
                this.append(sb, "Directory containing generated documentation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateReports (Default: true)", 2);
                this.append(sb, "Convenience parameter that allows you to disable report generation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateSitemap (Default: false)", 2);
                this.append(sb, "Generate a sitemap. The result will be a 'sitemap.html' file at the site root.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Specifies the input encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "locales", 2);
                this.append(sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository (Default: ${localRepository})", 2);
                this.append(sb, "The local repository.", 3);
                this.append(sb, "", 0);
                this.append(sb, "moduleExcludes", 2);
                this.append(sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in '-m1.fml' recursively)\nThe configuration looks like this:\n\n\u00a0\u00a0<moduleExcludes>\n\u00a0\u00a0\u00a0\u00a0<moduleType>filename1.ext,**/*sample.ext</moduleType>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0'apt',\u00a0'fml'\u00a0or\u00a0'xdoc'.\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0Here's\u00a0an\u00a0example:\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<xdoc>changes.xml,navigation.xml</xdoc>\n\u00a0\u00a0</moduleExcludes>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Directory containing the generated project sites and report distributions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2);
                this.append(sb, "Specifies the output encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportPlugins", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositories", 2);
                this.append(sb, "Remote repositories used for the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "siteDirectory (Default: ${basedir}/src/site)", 2);
                this.append(sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stagingDirectory", 2);
                this.append(sb, "Staging directory location. This needs to be an absolute path, like C:\\stagingArea\\myProject\\ on Windows or /stagingArea/myProject/ on Unix.", 3);
                this.append(sb, "", 0);
                this.append(sb, "template", 2);
                this.append(sb, "Deprecated. use templateFile or skinning instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Default template page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateDirectory (Default: src/site)", 2);
                this.append(sb, "Deprecated. use templateFile or skinning instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Directory containing the template page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateFile", 2);
                this.append(sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "validate (Default: false)", 2);
                this.append(sb, "Whether to validate xml input documents. If set to true, all input documents in xml format (in particular xdoc and fml) will be validated and any error will lead to a build failure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2);
                this.append(sb, "Deprecated. use the standard m2 directory layout", 3);
                this.append(sb, "", 0);
                this.append(sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stage-deploy".equals(this.goal)) {
            this.append(sb, "site:stage-deploy", 0);
            this.append(sb, "Deploys the generated site to a staging or mock directory to the site URL specified in the <distributionManagement> section of the POM. It supports scp and file protocols for deployment.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attributes", 2);
                this.append(sb, "The template properties for rendering the site.", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmod (Default: true)", 2);
                this.append(sb, "Whether to run the 'chmod' command on the remote site after the deploy. Defaults to 'true'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodMode (Default: g+w,a+rX)", 2);
                this.append(sb, "The mode used by the 'chmod' command. Only used if chmod = true. Defaults to 'g+w,a+rX'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "chmodOptions (Default: -Rf)", 2);
                this.append(sb, "The options used by the 'chmod' command. Only used if chmod = true. Defaults to '-Rf'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedSiteDirectory", 2);
                this.append(sb, "Directory containing generated documentation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateReports (Default: true)", 2);
                this.append(sb, "Convenience parameter that allows you to disable report generation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateSitemap (Default: false)", 2);
                this.append(sb, "Generate a sitemap. The result will be a 'sitemap.html' file at the site root.", 3);
                this.append(sb, "", 0);
                this.append(sb, "inputEncoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Specifies the input encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "locales", 2);
                this.append(sb, "A comma separated list of locales supported by Maven. The first valid token will be the default Locale for this instance of the Java Virtual Machine.", 3);
                this.append(sb, "", 0);
                this.append(sb, "localRepository (Default: ${localRepository})", 2);
                this.append(sb, "The local repository.", 3);
                this.append(sb, "", 0);
                this.append(sb, "moduleExcludes", 2);
                this.append(sb, "Module type exclusion mappings ex: fml -> **/*-m1.fml (excludes fml files ending in '-m1.fml' recursively)\nThe configuration looks like this:\n\n\u00a0\u00a0<moduleExcludes>\n\u00a0\u00a0\u00a0\u00a0<moduleType>filename1.ext,**/*sample.ext</moduleType>\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0moduleType\u00a0can\u00a0be\u00a0one\u00a0of\u00a0'apt',\u00a0'fml'\u00a0or\u00a0'xdoc'.\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0The\u00a0value\u00a0is\u00a0a\u00a0comma\u00a0separated\u00a0list\u00a0of\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0filenames\u00a0or\u00a0fileset\u00a0patterns.\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<!--\u00a0Here's\u00a0an\u00a0example:\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0-->\n\u00a0\u00a0\u00a0\u00a0<xdoc>changes.xml,navigation.xml</xdoc>\n\u00a0\u00a0</moduleExcludes>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "Directory containing the generated project sites and report distributions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2);
                this.append(sb, "Specifies the output encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportPlugins", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositories", 2);
                this.append(sb, "Remote repositories used for the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "siteDirectory (Default: ${basedir}/src/site)", 2);
                this.append(sb, "Directory containing the site.xml file and the source for apt, fml and xdoc docs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stagingDirectory", 2);
                this.append(sb, "Staging directory location. This needs to be an absolute path, like C:\\stagingArea\\myProject\\ on Windows or /stagingArea/myProject/ on Unix.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stagingRepositoryId (Default: stagingSite)", 2);
                this.append(sb, "The identifier of the repository where the staging site will be deployed. This id will be used to lookup a corresponding <server> entry from the settings.xml. If a matching <server> entry is found, its configured credentials will be used for authentication.", 3);
                this.append(sb, "", 0);
                this.append(sb, "stagingSiteURL", 2);
                this.append(sb, "The staged site will be deployed to this URL. If you don't specify this, the default-value will be '${project.distributionManagement.site.url}/staging', where 'project' is either the current project or, in a reactor build, the top level project in the reactor.", 3);
                this.append(sb, "", 0);
                this.append(sb, "template", 2);
                this.append(sb, "Deprecated. use templateFile or skinning instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Default template page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateDirectory (Default: src/site)", 2);
                this.append(sb, "Deprecated. use templateFile or skinning instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Directory containing the template page.", 3);
                this.append(sb, "", 0);
                this.append(sb, "templateFile", 2);
                this.append(sb, "The location of a Velocity template file to use. When used, skins and the default templates, CSS and images are disabled. It is highly recommended that you package this as a skin instead.", 3);
                this.append(sb, "", 0);
                this.append(sb, "validate (Default: false)", 2);
                this.append(sb, "Whether to validate xml input documents. If set to true, all input documents in xml format (in particular xdoc and fml) will be validated and any error will lead to a build failure.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xdocDirectory (Default: ${basedir}/xdocs)", 2);
                this.append(sb, "Deprecated. use the standard m2 directory layout", 3);
                this.append(sb, "", 0);
                this.append(sb, "Alternative directory for xdoc source, useful for m1 to m2 migration", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

