/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;

public abstract class AbstractScmManager
implements ScmManager {
    private static final String ILLEGAL_SCM_URL = "The scm url must be on the form 'scm:<scm provider><delimiter><provider specific part>' where <delimiter> can be either ':' or '|'.";
    private Map scmProviders = new HashMap();
    private ScmLogger logger;

    protected void setScmProviders(Map providers) {
        this.scmProviders = providers;
    }

    protected void addScmProvider(String providerType, ScmProvider provider) {
        this.scmProviders.put(providerType, provider);
    }

    protected abstract ScmLogger getScmLogger();

    public ScmProvider getProviderByUrl(String scmUrl) throws ScmRepositoryException, NoSuchScmProviderException {
        if (scmUrl == null) {
            throw new NullPointerException("The scm url cannot be null.");
        }
        char delimiter = this.findDelimiter(scmUrl);
        String providerType = scmUrl.substring(4, scmUrl.indexOf(delimiter, 4));
        return this.getProviderByType(providerType);
    }

    public ScmProvider getProviderByType(String providerType) throws NoSuchScmProviderException {
        ScmProvider scmProvider;
        if (this.logger == null) {
            this.logger = this.getScmLogger();
            Iterator i = this.scmProviders.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                ScmProvider p = (ScmProvider)this.scmProviders.get(key);
                p.addListener(this.logger);
            }
        }
        if ((scmProvider = (ScmProvider)this.scmProviders.get(providerType)) == null) {
            throw new NoSuchScmProviderException(providerType);
        }
        return scmProvider;
    }

    public ScmProvider getProviderByRepository(ScmRepository repository) throws NoSuchScmProviderException {
        return this.getProviderByType(repository.getProvider());
    }

    public ScmRepository makeScmRepository(String scmUrl) throws ScmRepositoryException, NoSuchScmProviderException {
        if (scmUrl == null) {
            throw new NullPointerException("The scm url cannot be null.");
        }
        char delimiter = this.findDelimiter(scmUrl);
        String providerType = scmUrl.substring(4, scmUrl.indexOf(delimiter, 4));
        ScmProvider provider = this.getProviderByType(providerType);
        String scmSpecificUrl = this.cleanScmUrl(scmUrl.substring(providerType.length() + 5));
        ScmProviderRepository providerRepository = provider.makeProviderScmRepository(scmSpecificUrl, delimiter);
        return new ScmRepository(providerType, providerRepository);
    }

    protected String cleanScmUrl(String scmUrl) {
        if (scmUrl == null) {
            throw new NullPointerException("The scm url cannot be null.");
        }
        String pathSeparator = "";
        int indexOfDoubleDot = -1;
        if (scmUrl.indexOf("../") > 1) {
            pathSeparator = "/";
            indexOfDoubleDot = scmUrl.indexOf("../");
        }
        if (scmUrl.indexOf("..\\") > 1) {
            pathSeparator = "\\";
            indexOfDoubleDot = scmUrl.indexOf("..\\");
        }
        if (indexOfDoubleDot > 1) {
            int startOfTextToRemove = scmUrl.substring(0, indexOfDoubleDot - 1).lastIndexOf(pathSeparator);
            String beginUrl = "";
            if (startOfTextToRemove >= 0) {
                beginUrl = scmUrl.substring(0, startOfTextToRemove);
            }
            String endUrl = scmUrl.substring(indexOfDoubleDot + 3);
            scmUrl = beginUrl + pathSeparator + endUrl;
            if (scmUrl.indexOf("../") > 1 || scmUrl.indexOf("..\\") > 1) {
                scmUrl = this.cleanScmUrl(scmUrl);
            }
        }
        return scmUrl;
    }

    public ScmRepository makeProviderScmRepository(String providerType, File path) throws ScmRepositoryException, UnknownRepositoryStructure, NoSuchScmProviderException {
        if (providerType == null) {
            throw new NullPointerException("The provider type cannot be null.");
        }
        ScmProvider provider = this.getProviderByType(providerType);
        ScmProviderRepository providerRepository = provider.makeProviderScmRepository(path);
        return new ScmRepository(providerType, providerRepository);
    }

    public List validateScmRepository(String scmUrl) {
        ScmProvider provider;
        char delimiter;
        ArrayList<String> messages = new ArrayList<String>();
        if (scmUrl == null) {
            throw new NullPointerException("The scm url cannot be null.");
        }
        if (!scmUrl.startsWith("scm:")) {
            messages.add("The scm url must start with 'scm:'.");
            return messages;
        }
        if (scmUrl.length() < 6) {
            messages.add(ILLEGAL_SCM_URL);
            return messages;
        }
        try {
            delimiter = this.findDelimiter(scmUrl);
        }
        catch (ScmRepositoryException e) {
            messages.add(e.getMessage());
            return messages;
        }
        String providerType = scmUrl.substring(4, scmUrl.indexOf(delimiter, 4));
        try {
            provider = this.getProviderByType(providerType);
        }
        catch (NoSuchScmProviderException e) {
            messages.add("No such provider installed '" + providerType + "'.");
            return messages;
        }
        String scmSpecificUrl = this.cleanScmUrl(scmUrl.substring(providerType.length() + 5));
        List providerMessages = provider.validateScmUrl(scmSpecificUrl, delimiter);
        if (providerMessages == null) {
            throw new RuntimeException("The SCM provider cannot return null from validateScmUrl().");
        }
        messages.addAll(providerMessages);
        return messages;
    }

    private char findDelimiter(String scmUrl) throws ScmRepositoryException {
        int index = (scmUrl = scmUrl.substring(4)).indexOf(124);
        if (index == -1 && (index = scmUrl.indexOf(58)) == -1) {
            throw new ScmRepositoryException(ILLEGAL_SCM_URL);
        }
        return scmUrl.charAt(index);
    }
}

