/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev;

import java.util.LinkedList;
import java.util.List;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.login.LoginScmResult;
import org.apache.maven.scm.provider.AbstractScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.accurev.AccuRevScmProviderRepository;
import org.apache.maven.scm.provider.accurev.commands.add.AccuRevAddCommand;
import org.apache.maven.scm.provider.accurev.commands.checkout.AccuRevCheckOutUsingPopCommand;
import org.apache.maven.scm.provider.accurev.commands.checkout.AccuRevCheckOutWorkspaceCommand;
import org.apache.maven.scm.provider.accurev.commands.checkout.BaseAccuRevCheckOutCommand;
import org.apache.maven.scm.provider.accurev.commands.login.AccuRevLoginCommand;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;

public class AccuRevScmProvider
extends AbstractScmProvider {
    private final String accurevExecutable;
    private AccuRevAddCommand addCommand;
    private AccuRevLoginCommand loginCommand;
    private BaseAccuRevCheckOutCommand[] checkOutCommands;
    private static final String CHECKOUT_METHOD_PARAM_NAME = "checkoutMethod";
    private static final String CHECKOUT_METHOD_SYS_PROPERTY = "accurev.checkout.method";

    public AccuRevScmProvider() {
        boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
        this.accurevExecutable = AccuRevScmProvider.resolveAccurevExecutable(isWindows);
    }

    public String getScmType() {
        return "accurev";
    }

    protected String getAccurevExecutable() {
        return this.accurevExecutable;
    }

    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        int paramStartIdx;
        AccuRevScmProviderRepository rep = new AccuRevScmProviderRepository();
        int atSignIdx = scmSpecificUrl.indexOf(64);
        if (atSignIdx != -1) {
            int hostEndIdx;
            String beforeAt = scmSpecificUrl.substring(0, atSignIdx);
            String afterAt = scmSpecificUrl.substring(atSignIdx + 1);
            LinkedList parts = AccuRevScmProvider.splitString(beforeAt, delimiter, true);
            if (parts.isEmpty()) {
                throw new ScmRepositoryException("Username is required");
            }
            rep.setUser((String)parts.removeFirst());
            if (!parts.isEmpty()) {
                rep.setPassword((String)parts.removeFirst());
            }
            if ((hostEndIdx = afterAt.indexOf(delimiter)) == -1) {
                throw new ScmRepositoryException("Invalid SCM URL");
            }
            String host = afterAt.substring(0, hostEndIdx);
            rep.setHost(host);
            int idx = afterAt.indexOf(delimiter, hostEndIdx + 1);
            if (idx == -1) {
                throw new ScmRepositoryException("Invalid SCM URL");
            }
            String eitherPortOrNextToken = afterAt.substring(hostEndIdx + 1, idx);
            try {
                rep.setPort(Integer.parseInt(eitherPortOrNextToken));
            }
            catch (NumberFormatException e) {
                idx = hostEndIdx;
            }
            scmSpecificUrl = afterAt.substring(idx + 1);
        }
        if ((paramStartIdx = scmSpecificUrl.indexOf(63)) != -1) {
            String params = scmSpecificUrl.substring(paramStartIdx + 1);
            scmSpecificUrl = scmSpecificUrl.substring(0, paramStartIdx);
            this.processParams(params, rep);
        }
        this.processDepotStreamAndWorkspace(scmSpecificUrl, delimiter, rep);
        String checkoutMethodParam = (String)rep.getParams().get(CHECKOUT_METHOD_PARAM_NAME);
        if (StringUtils.isNotEmpty((String)checkoutMethodParam)) {
            rep.setCheckoutMethod(checkoutMethodParam.trim());
        }
        if (rep.getCheckoutMethod() == null) {
            rep.setCheckoutMethod(System.getProperty(CHECKOUT_METHOD_SYS_PROPERTY, "pop"));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Repository created: " + rep.toString());
        }
        return rep;
    }

    private void processParams(String params, AccuRevScmProviderRepository rep) {
        String[] paramKeyValuePairs = StringUtils.split((String)params, (String)"&");
        for (int i = 0; i < paramKeyValuePairs.length; ++i) {
            String keyValuePair = paramKeyValuePairs[i];
            int delimiterIdx = keyValuePair.indexOf(61);
            if (delimiterIdx == -1) {
                this.getLogger().warn("Invalid parameter \"" + keyValuePair + "\" at position " + i);
                continue;
            }
            String key = keyValuePair.substring(0, delimiterIdx);
            String value = keyValuePair.substring(delimiterIdx + 1);
            rep.getParams().put(key, value);
        }
    }

    protected LoginScmResult login(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        if (null == this.loginCommand) {
            this.loginCommand = new AccuRevLoginCommand(this.accurevExecutable);
            this.loginCommand.setLogger(this.getLogger());
        }
        return (LoginScmResult)this.loginCommand.execute(repository, fileSet, parameters);
    }

    protected CheckOutScmResult checkout(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        AccuRevScmProviderRepository rep = (AccuRevScmProviderRepository)repository;
        this.getLogger().debug("accurev.checkout.method = " + rep.getCheckoutMethod());
        BaseAccuRevCheckOutCommand[] checkOutCmds = this.getCheckoutCommands();
        for (int i = 0; i < checkOutCmds.length; ++i) {
            BaseAccuRevCheckOutCommand checkOutCommand = checkOutCmds[i];
            if (!checkOutCommand.getMethodName().equalsIgnoreCase(rep.getCheckoutMethod())) continue;
            return (CheckOutScmResult)checkOutCommand.execute(repository, fileSet, parameters);
        }
        throw new ScmRepositoryException("accurev.checkout.method=" + rep.getCheckoutMethod() + " is not supported");
    }

    protected AddScmResult add(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        if (null == this.addCommand) {
            this.addCommand = new AccuRevAddCommand(this.accurevExecutable);
            this.addCommand.setLogger(this.getLogger());
        }
        return (AddScmResult)this.addCommand.execute(repository, fileSet, parameters);
    }

    private BaseAccuRevCheckOutCommand[] getCheckoutCommands() {
        if (null == this.checkOutCommands) {
            this.checkOutCommands = this.buildCheckOutCommands();
        }
        return this.checkOutCommands;
    }

    protected BaseAccuRevCheckOutCommand[] buildCheckOutCommands() {
        BaseAccuRevCheckOutCommand[] commands = new BaseAccuRevCheckOutCommand[]{new AccuRevCheckOutUsingPopCommand(this.accurevExecutable), new AccuRevCheckOutWorkspaceCommand(this.accurevExecutable)};
        for (int i = 0; i < commands.length; ++i) {
            BaseAccuRevCheckOutCommand command = commands[i];
            command.setLogger(this.getLogger());
        }
        return commands;
    }

    public static void appendHostToParamsIfNeeded(AccuRevScmProviderRepository repository, List params) {
        if (repository.getHost() != null) {
            params.add("-H");
            params.add(repository.getHost() + ":" + String.valueOf(repository.getPort()));
        }
    }

    private static String resolveAccurevExecutable(boolean windows) {
        String accurevExecutable;
        String executable = "accurev";
        if (windows) {
            executable = executable + ".exe";
        }
        if ((accurevExecutable = System.getProperty("accurevExecutable")) != null) {
            executable = accurevExecutable;
        }
        return executable;
    }

    private static LinkedList splitString(String string, char separatorChar, boolean blankIsNull) {
        int idx;
        LinkedList<String> parts = new LinkedList<String>();
        int fromIdx = 0;
        while ((idx = string.indexOf(separatorChar, fromIdx)) != -1) {
            parts.add(AccuRevScmProvider.getSubstring(string, fromIdx, idx, blankIsNull));
            fromIdx = ++idx;
        }
        parts.add(AccuRevScmProvider.getSubstring(string, fromIdx, string.length(), blankIsNull));
        return parts;
    }

    private static String getSubstring(String string, int fromIdx, int toIdx, boolean blankIsNull) {
        String substring = string.substring(fromIdx, toIdx);
        return blankIsNull && StringUtils.isEmpty((String)substring) ? null : substring;
    }

    private void processDepotStreamAndWorkspace(String depotStreamWorkspace, char delimeter, AccuRevScmProviderRepository repRef) throws ScmRepositoryException {
        LinkedList parts = AccuRevScmProvider.splitString(depotStreamWorkspace, delimeter, true);
        if (parts.size() < 2) {
            throw new ScmRepositoryException("Invalid scmUrl. Depot and stream names are required");
        }
        String depot = (String)parts.removeFirst();
        if (null == depot) {
            throw new ScmRepositoryException("Depot name is missing");
        }
        repRef.setDepot(depot);
        String streamName = (String)parts.removeFirst();
        if (null == streamName) {
            throw new ScmRepositoryException("Stream name is missing");
        }
        repRef.setStreamName(streamName);
        if (!parts.isEmpty()) {
            repRef.setWorkspaceName((String)parts.removeFirst());
        }
        if (!parts.isEmpty()) {
            throw new ScmRepositoryException("Invalid workspace assosiation path: " + depotStreamWorkspace + ". Should be in format \"<depot>" + delimeter + "<stream>" + delimeter + "<workspace>\"");
        }
        if (repRef.getWorkspaceName() == null) {
            // empty if block
        }
    }
}

