/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.edit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.edit.AbstractEditCommand;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.edit.PerforceEditConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceEditCommand
extends AbstractEditCommand
implements PerforceCommand {
    protected ScmResult executeEditCommand(ScmProviderRepository repo, ScmFileSet files) throws ScmException {
        Commandline cl = PerforceEditCommand.createCommandLine((PerforceScmProviderRepository)repo, files.getBasedir(), files);
        PerforceEditConsumer consumer = new PerforceEditConsumer();
        try {
            this.getLogger().debug(PerforceScmProvider.clean("Executing " + cl.toString()));
            Process proc = cl.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                consumer.consumeLine(line);
            }
        }
        catch (CommandLineException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new EditScmResult(cl.toString(), consumer.getEdits());
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmFileSet files) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArgument().setValue("edit");
        try {
            String candir = workingDirectory.getCanonicalPath();
            File[] fs = files.getFiles();
            for (int i = 0; i < fs.length; ++i) {
                File file = fs[i];
                String canfile = file.getCanonicalPath();
                if (canfile.startsWith(candir)) {
                    canfile = canfile.substring(candir.length() + 1);
                }
                command.createArgument().setValue(canfile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return command;
    }
}

