/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam.command.checkin;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.starteam.command.StarteamCommand;
import org.apache.maven.scm.provider.starteam.command.StarteamCommandLineUtils;
import org.apache.maven.scm.provider.starteam.command.checkin.StarteamCheckInConsumer;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class StarteamCheckInCommand
extends AbstractCheckInCommand
implements StarteamCommand {
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, String tag) throws ScmException {
        String issue = System.getProperty("maven.scm.issue");
        this.getLogger().info("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        StarteamScmProviderRepository repository = (StarteamScmProviderRepository)repo;
        StarteamCheckInConsumer consumer = new StarteamCheckInConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        File[] checkInFiles = fileSet.getFiles();
        if (checkInFiles.length == 0) {
            Commandline cl = StarteamCheckInCommand.createCommandLine(repository, fileSet.getBasedir(), message, tag, issue);
            int exitCode = StarteamCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
            if (exitCode != 0) {
                return new CheckInScmResult(cl.toString(), "The starteam command failed.", stderr.getOutput(), false);
            }
        } else {
            for (int i = 0; i < checkInFiles.length; ++i) {
                Commandline cl = StarteamCheckInCommand.createCommandLine(repository, checkInFiles[i], message, tag, issue);
                int exitCode = StarteamCommandLineUtils.executeCommandline(cl, consumer, stderr, this.getLogger());
                if (exitCode == 0) continue;
                return new CheckInScmResult(cl.toString(), "The starteam command failed.", stderr.getOutput(), false);
            }
        }
        return new CheckInScmResult(null, consumer.getCheckedInFiles());
    }

    public static Commandline createCommandLine(StarteamScmProviderRepository repo, File dirOrFile, String message, String tag, String issue) {
        Commandline cl = StarteamCommandLineUtils.createStarteamBaseCommandLine("ci", dirOrFile, repo);
        if (message != null && message.length() > 0) {
            cl.createArgument().setValue("-r");
            cl.createArgument().setValue(message);
        }
        if (tag != null && tag.length() > 0) {
            cl.createArgument().setValue("-vl");
            cl.createArgument().setValue(tag);
        }
        if (issue != null && issue.length() > 0) {
            cl.createArgument().setValue("-cr");
            cl.createArgument().setValue(issue);
        }
        if (dirOrFile.isDirectory()) {
            cl.createArgument().setValue("-f");
            cl.createArgument().setValue("NCI");
            cl.createArgument().setValue("-is");
        } else {
            cl.createArgument().setValue(dirOrFile.getName());
        }
        return cl;
    }
}

