/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.PermissionModeUtils;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.repository.RepositoryPermissions;

public class ScpHelper {
    private ScpHelper() {
    }

    public static void createRemoteDirectories(String path, RepositoryPermissions permissions, CommandExecutor commandExecutor) throws TransferFailedException {
        try {
            String dirPerms;
            String umaskCmd = null;
            if (permissions != null && (dirPerms = permissions.getDirectoryMode()) != null) {
                umaskCmd = "umask " + PermissionModeUtils.getUserMaskFor((String)dirPerms);
            }
            String mkdirCmd = "mkdir -p " + path;
            if (umaskCmd != null) {
                mkdirCmd = umaskCmd + "; " + mkdirCmd;
            }
            commandExecutor.executeCommand(mkdirCmd);
        }
        catch (CommandExecutionException e) {
            throw new TransferFailedException("Error performing commands for file transfer", (Throwable)e);
        }
    }
}

