/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compiler.CompilerConfig;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;
import org.apache.tools.ant.taskdefs.Execute;

public class Property {
    protected String name;
    protected String value;
    protected File file;
    protected String env;
    protected String prefix;
    protected XMLElement xmlProp;
    protected CompilerConfig config;
    protected Compiler compiler;

    public Property(XMLElement xMLElement, CompilerConfig compilerConfig) {
        String string;
        this.xmlProp = xMLElement;
        this.config = compilerConfig;
        this.compiler = compilerConfig.getCompiler();
        this.name = xMLElement.getAttribute("name");
        this.value = xMLElement.getAttribute("value");
        this.env = xMLElement.getAttribute("environment");
        if (this.env != null && !this.env.endsWith(".")) {
            this.env = this.env + ".";
        }
        this.prefix = xMLElement.getAttribute("prefix");
        if (this.prefix != null && !this.prefix.endsWith(".")) {
            this.prefix = this.prefix + ".";
        }
        if ((string = xMLElement.getAttribute("file")) != null) {
            this.file = new File(string);
        }
    }

    public String getValue() {
        return this.toString();
    }

    public String toString() {
        return this.value == null ? "" : this.value;
    }

    public void execute() throws CompilerException {
        if (this.name != null) {
            if (this.value == null) {
                this.config.parseError(this.xmlProp, "You must specify a value with the name attribute");
            }
        } else if (this.file == null && this.env == null) {
            this.config.parseError(this.xmlProp, "You must specify file, or environment when not using the name attribute");
        }
        if (this.file == null && this.prefix != null) {
            this.config.parseError(this.xmlProp, "Prefix is only valid when loading from a file ");
        }
        if (this.name != null && this.value != null) {
            this.addProperty(this.name, this.value);
        } else if (this.file != null) {
            this.loadFile(this.file);
        } else if (this.env != null) {
            this.loadEnvironment(this.env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFile(File file) throws CompilerException {
        block8: {
            Properties properties = new Properties();
            this.config.getPackagerListener().packagerMsg("Loading " + file.getAbsolutePath(), 3);
            try {
                if (file.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        properties.load(fileInputStream);
                    }
                    finally {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    this.addProperties(properties);
                    break block8;
                }
                this.config.getPackagerListener().packagerMsg("Unable to find property file: " + file.getAbsolutePath(), 3);
            }
            catch (IOException iOException) {
                this.config.parseError(this.xmlProp, "Faild to load file: " + file.getAbsolutePath(), iOException);
            }
        }
    }

    protected void loadEnvironment(String string) throws CompilerException {
        Properties properties = new Properties();
        this.config.getPackagerListener().packagerMsg("Loading Environment " + string, 3);
        Vector vector = Execute.getProcEnvironment();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            int n = string2.indexOf(61);
            if (n == -1) {
                this.config.getPackagerListener().packagerMsg("Ignoring " + string, 4);
                continue;
            }
            properties.put(string + string2.substring(0, n), string2.substring(n + 1));
        }
        this.addProperties(properties);
    }

    protected void addProperty(String string, String string2) throws CompilerException {
        string2 = this.compiler.replaceProperties(string2);
        this.compiler.addProperty(string, string2);
    }

    protected void addProperties(Properties properties) throws CompilerException {
        this.resolveAllProperties(properties);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (this.prefix != null) {
                string = this.prefix + string;
            }
            this.addProperty(string, string2);
        }
    }

    private void resolveAllProperties(Properties properties) throws CompilerException {
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor(properties);
        variableSubstitutor.setBracesRequired(true);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            int n = -1;
            do {
                StringReader stringReader = new StringReader(string2);
                StringWriter stringWriter = new StringWriter();
                try {
                    n = variableSubstitutor.substitute(stringReader, stringWriter, "at");
                    properties.put(string, string2);
                }
                catch (IOException iOException) {
                    this.config.parseError(this.xmlProp, "Faild to load file: " + this.file.getAbsolutePath(), iOException);
                }
            } while (n != 0);
        }
    }
}

