/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.ant;

import com.izforge.izpack.ant.ConfigHolder;
import com.izforge.izpack.ant.Property;
import com.izforge.izpack.compiler.CompilerConfig;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.PackagerListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.PropertySet;

public class IzPackTask
extends Task
implements PackagerListener {
    private ConfigHolder config = null;
    private String input = null;
    private String basedir = null;
    private String output = null;
    private String compression = "default";
    private int compressionLevel = -1;
    private InstallerType installerType = null;
    private String izPackDir = null;
    private Properties properties;
    private boolean inheritAll = false;

    public ConfigHolder createConfig() {
        this.config = new ConfigHolder(this.getProject());
        return this.config;
    }

    public void packagerMsg(String string) {
        this.packagerMsg(string, 2);
    }

    public void packagerMsg(String string, int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 4;
                break;
            }
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 1;
                break;
            }
            default: {
                n2 = 2;
            }
        }
        this.log(string, n2);
    }

    public void packagerStart() {
        this.log(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("Packager_starting"), 4);
    }

    public void packagerStop() {
        this.log(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("Packager_ended"), 4);
    }

    public void execute() throws BuildException {
        String string;
        Object object;
        Object object2;
        if (this.input == null && this.config == null) {
            throw new BuildException(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("input_must_be_specified"));
        }
        if (this.output == null) {
            throw new BuildException(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("output_must_be_specified"));
        }
        if (this.basedir == null) {
            throw new BuildException(ResourceBundle.getBundle("com/izforge/izpack/ant/langpacks/messages").getString("basedir_must_be_specified"));
        }
        String string2 = this.installerType == null ? null : this.installerType.getValue();
        CompilerConfig compilerConfig = null;
        String string3 = null;
        if (this.config != null) {
            string3 = this.config.getText();
            this.input = null;
        }
        try {
            compilerConfig = new CompilerConfig(this.input, this.basedir, string2, this.output, this.compression, this.compressionLevel, this, string3);
        }
        catch (CompilerException compilerException) {
            throw new BuildException(compilerException);
        }
        CompilerConfig.setIzpackHome(this.izPackDir);
        if (this.properties != null) {
            object2 = this.properties.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                string = this.properties.getProperty((String)object);
                string = IzPackTask.fixPathString(string);
                compilerConfig.addProperty((String)object, string);
            }
        }
        if (this.inheritAll) {
            object2 = this.getProject().getProperties();
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                String string4 = (String)((Hashtable)object2).get(string);
                string4 = IzPackTask.fixPathString(string4);
                compilerConfig.addProperty(string, string4);
            }
        }
        try {
            compilerConfig.executeCompiler();
        }
        catch (Exception exception) {
            throw new BuildException(exception);
        }
    }

    private static String fixPathString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '\\') continue;
            stringBuffer.setCharAt(i, '/');
        }
        return stringBuffer.toString();
    }

    public void setInput(String string) {
        this.input = string;
    }

    public void setBasedir(String string) {
        this.basedir = string;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public void setInstallerType(InstallerType installerType) {
        this.installerType = installerType;
    }

    public void setIzPackDir(String string) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        this.izPackDir = string;
    }

    public void setInheritAll(boolean bl) {
        this.inheritAll = bl;
    }

    public void setCompression(String string) {
        this.compression = string;
    }

    public void setCompressionLevel(int n) {
        this.compressionLevel = n;
    }

    public void addConfiguredProperty(Property property) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        property.execute();
        Properties properties = property.getProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.log("Adding property: " + property.getClass() + string + "=" + string2, 3);
            this.properties.setProperty(string, string2);
        }
    }

    public void addConfiguredPropertyset(PropertySet propertySet) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.putAll((Map<?, ?>)propertySet.getProperties());
    }

    public static class InstallerType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"standard", "web"};
        }
    }
}

