/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDistributionMojo
extends AbstractMojo {
    protected File outputDirectory;
    protected File clusterBuildDir;
    protected File netbeansInstallation;
    protected String brandingToken;
    protected String defaultOptions;
    protected List<String> enabledClusters;

    protected List<File> findClusterDirectories() throws IOException {
        if (!this.clusterBuildDir.exists()) {
            throw new IOException("There are no additional clusters in " + this.clusterBuildDir);
        }
        HashMap<String, Pattern> matchers = new HashMap<String, Pattern>();
        if (this.enabledClusters == null) {
            this.enabledClusters = new ArrayList<String>();
        }
        for (String enabledCluster : this.enabledClusters) {
            matchers.put(enabledCluster, Pattern.compile(enabledCluster + "(\\d)*"));
        }
        ArrayList<File> enabledClusterDirectories = new ArrayList<File>();
        File[] netbeansSubDirectories = this.netbeansInstallation.listFiles();
        File[] clusterDirectories = this.clusterBuildDir.listFiles();
        ArrayList<File> files = new ArrayList<File>(netbeansSubDirectories.length + clusterDirectories.length);
        files.addAll(Arrays.asList(netbeansSubDirectories));
        files.addAll(Arrays.asList(clusterDirectories));
        if (netbeansSubDirectories == null) {
            throw new IOException("Non-existing NetBeans installation at " + this.netbeansInstallation);
        }
        for (File current : files) {
            if (!current.isDirectory()) continue;
            String folderName = current.getName();
            for (String clusterName : this.enabledClusters) {
                if (!folderName.matches(clusterName + "\\d*")) continue;
                enabledClusterDirectories.add(current);
            }
        }
        return enabledClusterDirectories;
    }

    protected File findPlatformClusterDirectory(List<File> clusterDirectories) {
        for (File clusterDirectory : clusterDirectories) {
            if (!clusterDirectory.getName().matches("platform\\d")) continue;
            return clusterDirectory;
        }
        return null;
    }

    protected void createBundleEtcDir(File buildDir, File harnessDir, List<String> enabledClusters, String defaultOptions, String brandingToken) throws IOException {
        File etcDir = new File(buildDir + File.separator + "etc");
        etcDir.mkdir();
        File clusterConf = new File(etcDir + File.separator + brandingToken + ".clusters");
        clusterConf.createNewFile();
        StringBuffer buffer = new StringBuffer();
        for (String clusterName : enabledClusters) {
            buffer.append(clusterName);
            buffer.append("\n");
        }
        FileUtils.fileWrite((String)clusterConf.getAbsolutePath(), (String)buffer.toString());
        File confFile = new File(harnessDir.getAbsolutePath() + File.separator + "etc" + File.separator + "app.conf");
        File confDestFile = new File(etcDir.getAbsolutePath() + File.separator + brandingToken + ".conf");
        FileUtils.copyFile((File)confFile, (File)confDestFile);
        String contents = FileUtils.fileRead((File)confDestFile);
        contents = contents.replace("default_options=\"", "default_options=\"" + defaultOptions + " ");
        FileUtils.fileWrite((String)confDestFile.getAbsolutePath(), (String)contents);
    }

    protected void copyClusters(File destination, List<File> clusterDirectories) throws IOException {
        for (File clusterDir : clusterDirectories) {
            File buildClusterDir = new File(destination + File.separator + clusterDir.getName());
            FileUtils.copyDirectoryStructure((File)clusterDir, (File)buildClusterDir);
        }
    }
}

