/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.codehaus.mojo.nbm.AbstractNbmMojo;
import org.codehaus.mojo.nbm.ExamineManifest;

public class CollectLibrariesNodeVisitor
implements DependencyNodeVisitor {
    private final List<Artifact> nodes = new ArrayList<Artifact>();
    private Map<String, Artifact> artifacts = new HashMap<String, Artifact>();
    private Map<Artifact, ExamineManifest> examinerCache;
    private List<String> explicitLibs;
    private final Log log;
    private MojoExecutionException throwable;
    private DependencyNode root;
    private Set<String> duplicates;
    private Set<String> conflicts;
    private Set<String> includes;
    private final boolean useOsgiDependencies;

    public CollectLibrariesNodeVisitor(List<String> explicitLibraries, List<Artifact> runtimeArtifacts, Map<Artifact, ExamineManifest> examinerCache, Log log, DependencyNode root, boolean useOsgiDependencies) {
        for (Artifact a : runtimeArtifacts) {
            this.artifacts.put(a.getDependencyConflictId(), a);
        }
        this.examinerCache = examinerCache;
        this.explicitLibs = explicitLibraries;
        this.log = log;
        this.root = root;
        this.useOsgiDependencies = useOsgiDependencies;
        this.duplicates = new HashSet<String>();
        this.conflicts = new HashSet<String>();
        this.includes = new HashSet<String>();
    }

    public boolean visit(DependencyNode node) {
        if (this.throwable != null) {
            return false;
        }
        if (this.root == node) {
            return true;
        }
        try {
            Artifact artifact = node.getArtifact();
            if (!this.artifacts.containsKey(artifact.getDependencyConflictId())) {
                return false;
            }
            if (node.getState() != 0) {
                if (node.getState() == 1) {
                    this.duplicates.add(artifact.getDependencyConflictId());
                }
                if (node.getState() == 2) {
                    this.conflicts.add(artifact.getDependencyConflictId());
                }
                return true;
            }
            ExamineManifest depExaminator = this.examinerCache.get(artifact = this.artifacts.get(artifact.getDependencyConflictId()));
            if (depExaminator == null) {
                depExaminator = new ExamineManifest(this.log);
                depExaminator.setJarFile(artifact.getFile());
                depExaminator.checkFile();
                this.examinerCache.put(artifact, depExaminator);
            }
            if (AbstractNbmMojo.matchesLibrary(artifact, this.explicitLibs, depExaminator, this.log, this.useOsgiDependencies)) {
                if (depExaminator.isNetbeansModule()) {
                    this.log.warn((CharSequence)("You are using a NetBeans Module as a Library (classpath extension): " + artifact.getId()));
                }
                this.nodes.add(artifact);
                this.includes.add(artifact.getDependencyConflictId());
                return true;
            }
        }
        catch (MojoExecutionException mojoExecutionException) {
            this.throwable = mojoExecutionException;
        }
        return false;
    }

    public boolean endVisit(DependencyNode node) {
        if (this.throwable != null) {
            return false;
        }
        if (node == this.root) {
            HashSet<String> badDuplicates = new HashSet<String>();
            badDuplicates.addAll(this.duplicates);
            badDuplicates.removeAll(this.includes);
            if (this.nodes.size() > 0) {
                this.log.info((CharSequence)"Adding on module's Class-Path:");
                for (Artifact inc : this.nodes) {
                    this.log.info((CharSequence)("    " + inc.getId()));
                }
            }
            HashSet<String> badConflicts = new HashSet<String>();
            badConflicts.addAll(this.conflicts);
            badConflicts.removeAll(this.conflicts);
            if (badDuplicates.size() > 0 || badConflicts.size() > 0) {
                this.log.warn((CharSequence)"There are transitive dependencies that were not included in the module's Class-Path because they were resolved as part of another NetBeans module.");
                if (badConflicts.size() > 0) {
                    this.log.warn((CharSequence)"Some are used in different version.");
                }
                for (String dup : badConflicts) {
                    this.log.warn((CharSequence)("  " + dup + " (with different version)"));
                }
                badDuplicates.removeAll(badConflicts);
                for (String dup : badDuplicates) {
                    this.log.warn((CharSequence)("  " + dup));
                }
            }
        }
        return true;
    }

    public List<Artifact> getArtifacts() throws MojoExecutionException {
        if (this.throwable != null) {
            throw this.throwable;
        }
        return this.nodes;
    }
}

