/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.mojo.nbm.AbstractNbmMojo;
import org.codehaus.mojo.nbm.ExamineManifest;
import org.codehaus.mojo.nbm.model.NbmResource;
import org.codehaus.mojo.nbm.model.NetbeansModule;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.netbeans.nbbuild.CreateModuleXML;
import org.netbeans.nbbuild.JHIndexer;
import org.netbeans.nbbuild.MakeListOfNBM;

public abstract class CreateNetbeansFileStructure
extends AbstractNbmMojo {
    protected File nbmBuildDir;
    protected File buildDir;
    protected String finalName;
    protected File descriptor;
    protected String cluster;
    protected File nbmJavahelpSource;
    protected MavenProject project;
    private String distributionUrl;
    protected Resource[] nbmResources;
    protected String encoding;
    protected MavenResourcesFiltering mavenResourcesFiltering;
    protected MavenSession session;
    protected Project antProject;
    protected NetbeansModule module;
    protected File clusterDir;
    protected String moduleJarName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        int index;
        this.antProject = this.registerNbmAntTasks();
        this.module = this.descriptor != null && this.descriptor.exists() ? this.readModuleDescriptor(this.descriptor) : this.createDefaultDescriptor(this.project, false);
        if (this.distributionUrl != null) {
            this.module.setDistributionUrl(this.distributionUrl);
        }
        String type = this.module.getModuleType();
        boolean autoload = "autoload".equals(type);
        boolean eager = "eager".equals(type);
        if (autoload && eager) {
            this.getLog().error((CharSequence)"Module cannot be both eager and autoload");
            throw new MojoExecutionException("Module cannot be both eager and autoload");
        }
        String moduleName = this.module.getCodeNameBase();
        if (moduleName == null) {
            moduleName = this.project.getGroupId() + "." + this.project.getArtifactId();
            moduleName = moduleName.replaceAll("-", ".");
        }
        this.moduleJarName = moduleName.replace('.', '-');
        if ("extra".equals(this.cluster) && this.module.getCluster() != null) {
            this.getLog().warn((CharSequence)"Parameter cluster in module descriptor is deprecated, use the plugin configuration element.");
            this.cluster = this.module.getCluster();
        }
        if ((index = this.moduleJarName.indexOf(47)) > -1) {
            this.moduleJarName = this.moduleJarName.substring(0, index).trim();
        }
        File jarFile = new File(this.buildDir, this.finalName + ".jar");
        this.clusterDir = new File(this.nbmBuildDir, "netbeans" + File.separator + this.cluster);
        File moduleJarLocation = new File(this.clusterDir, "modules");
        moduleJarLocation.mkdirs();
        File moduleFile = new File(moduleJarLocation, this.moduleJarName + ".jar");
        this.getLog().info((CharSequence)("Copying module jar to " + moduleJarLocation));
        try {
            FileUtils.getFileUtils().copyFile(jarFile, moduleFile, null, true, false);
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"Cannot copy module jar");
            throw new MojoExecutionException("Cannot copy module jar", (Exception)ex);
        }
        ExamineManifest modExaminator = new ExamineManifest(this.getLog());
        modExaminator.setJarFile(jarFile);
        modExaminator.checkFile();
        String classpathValue = modExaminator.getClasspath();
        if (this.module != null) {
            ArrayList<String> librList = new ArrayList<String>();
            if (this.module.getLibraries() != null) {
                librList.addAll(this.module.getLibraries());
            }
            List artifacts = this.project.getRuntimeArtifacts();
            for (Artifact artifact : artifacts) {
                File source = artifact.getFile();
                if (!classpathValue.contains("ext/" + artifact.getGroupId() + "/" + source.getName())) continue;
                File targetDir = new File(moduleJarLocation, "ext/" + artifact.getGroupId());
                targetDir.mkdirs();
                File target = new File(targetDir, source.getName());
                try {
                    FileUtils.getFileUtils().copyFile(source, target, null, true, false);
                }
                catch (IOException ex) {
                    this.getLog().error((CharSequence)"Cannot copy library jar");
                    throw new MojoExecutionException("Cannot copy library jar", (Exception)ex);
                }
            }
            if (this.nbmResources != null) {
                this.copyNbmResources();
            }
            this.copyDeprecatedNbmResources();
        }
        if (this.nbmJavahelpSource.exists()) {
            File javahelp_target = new File(this.buildDir, "javahelp");
            String javahelpbase = this.moduleJarName.replace('-', File.separatorChar) + File.separator + "docs";
            String javahelpSearch = "JavaHelpSearch";
            File b = new File(javahelp_target, javahelpbase);
            File p = new File(b, javahelpSearch);
            p.mkdirs();
            Copy cp = (Copy)this.antProject.createTask("copy");
            cp.setTodir(javahelp_target);
            FileSet set = new FileSet();
            set.setDir(this.nbmJavahelpSource);
            cp.addFileset(set);
            cp.execute();
            this.getLog().info((CharSequence)"Generating JavaHelp Index...");
            JHIndexer jhTask = (JHIndexer)this.antProject.createTask("jhindexer");
            jhTask.setBasedir(b);
            jhTask.setDb(p);
            jhTask.setIncludes("**/*.html");
            jhTask.setExcludes(javahelpSearch);
            Path path = new Path(this.antProject);
            jhTask.setClassPath(path);
            this.MNMMODULE51hackClearStaticFieldsInJavaHelpIndexer();
            try {
                jhTask.execute();
            }
            catch (BuildException e) {
                this.getLog().error((CharSequence)"Cannot generate JavaHelp index.");
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            File helpJarLocation = new File(this.clusterDir, "modules/docs");
            helpJarLocation.mkdirs();
            Jar jar = (Jar)this.antProject.createTask("jar");
            jar.setDestFile(new File(helpJarLocation, this.moduleJarName + ".jar"));
            set = new FileSet();
            set.setDir(javahelp_target);
            jar.addFileset(set);
            jar.execute();
        }
        File configDir = new File(this.clusterDir, "config" + File.separator + "Modules");
        configDir.mkdirs();
        CreateModuleXML moduleXmlTask = (CreateModuleXML)this.antProject.createTask("createmodulexml");
        moduleXmlTask.setXmldir(configDir);
        FileSet fs = new FileSet();
        fs.setDir(this.clusterDir);
        fs.setIncludes("modules" + File.separator + this.moduleJarName + ".jar");
        if (autoload) {
            moduleXmlTask.addAutoload(fs);
        } else if (eager) {
            moduleXmlTask.addEager(fs);
        } else {
            moduleXmlTask.addEnabled(fs);
        }
        try {
            moduleXmlTask.execute();
        }
        catch (BuildException e) {
            this.getLog().error((CharSequence)"Cannot generate config file.");
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        MakeListOfNBM makeTask = (MakeListOfNBM)this.antProject.createTask("genlist");
        this.antProject.setNewProperty("module.name", this.finalName);
        this.antProject.setProperty("cluster.dir", this.cluster);
        FileSet set = makeTask.createFileSet();
        set.setDir(this.clusterDir);
        PatternSet pattern = set.createPatternSet();
        pattern.setIncludes("**");
        makeTask.setModule("modules" + File.separator + this.moduleJarName + ".jar");
        makeTask.setOutputfiledir(this.clusterDir);
        try {
            makeTask.execute();
        }
        catch (BuildException e) {
            this.getLog().error((CharSequence)"Cannot Generate nbm list");
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void copyDeprecatedNbmResources() throws BuildException, MojoExecutionException {
        List<NbmResource> ress = this.module.getNbmResources();
        if (ress.size() > 0) {
            this.getLog().warn((CharSequence)"NBM resources defined in module descriptor are deprecated. Please configure NBM resources in plugin configuration.");
            Copy cp = (Copy)this.antProject.createTask("copy");
            cp.setTodir(this.clusterDir);
            HashMap<File, ArrayList<FileSet>> customPaths = new HashMap<File, ArrayList<FileSet>>();
            boolean hasStandard = false;
            for (NbmResource nbmResource : ress) {
                if (nbmResource.getBaseDirectory() == null) continue;
                File base = new File(this.project.getBasedir(), nbmResource.getBaseDirectory());
                FileSet set = new FileSet();
                set.setDir(base);
                for (String inc : nbmResource.getIncludes()) {
                    set.createInclude().setName(inc);
                }
                for (String exc : nbmResource.getExcludes()) {
                    set.createExclude().setName(exc);
                }
                if (nbmResource.getRelativeClusterPath() != null) {
                    File path = new File(this.clusterDir, nbmResource.getRelativeClusterPath());
                    ArrayList<FileSet> col = (ArrayList<FileSet>)customPaths.get(path);
                    if (col == null) {
                        col = new ArrayList<FileSet>();
                        customPaths.put(path, col);
                    }
                    col.add(set);
                    continue;
                }
                cp.addFileset(set);
                hasStandard = true;
            }
            try {
                if (hasStandard) {
                    cp.execute();
                }
                if (customPaths.size() > 0) {
                    for (Map.Entry entry : customPaths.entrySet()) {
                        cp = (Copy)this.antProject.createTask("copy");
                        cp.setTodir((File)entry.getKey());
                        for (FileSet set : (Collection)entry.getValue()) {
                            cp.addFileset(set);
                        }
                        cp.execute();
                    }
                }
            }
            catch (BuildException e) {
                this.getLog().error((CharSequence)"Cannot copy additional resources into the nbm file");
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private void MNMMODULE51hackClearStaticFieldsInJavaHelpIndexer() {
        try {
            Class<?> clazz = Class.forName("com.sun.java.help.search.Indexer");
            Field fld = clazz.getDeclaredField("kitRegistry");
            fld.setAccessible(true);
            Hashtable hash = (Hashtable)fld.get(null);
            hash.clear();
            clazz = Class.forName("com.sun.java.help.search.HTMLIndexerKit");
            fld = clazz.getDeclaredField("defaultParser");
            fld.setAccessible(true);
            fld.set(null, null);
            fld = clazz.getDeclaredField("defaultCallback");
            fld.setAccessible(true);
            fld.set(null, null);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(CreateNetbeansFileStructure.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(CreateNetbeansFileStructure.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(CreateNetbeansFileStructure.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(CreateNetbeansFileStructure.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(CreateNetbeansFileStructure.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void copyNbmResources() throws MojoExecutionException {
        try {
            if (StringUtils.isEmpty((String)this.encoding) && this.isFilteringEnabled(this.nbmResources)) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
            MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution(Arrays.asList(this.nbmResources), this.clusterDir, this.project, this.encoding, Collections.EMPTY_LIST, Collections.EMPTY_LIST, this.session);
            mavenResourcesExecution.setEscapeWindowsPaths(true);
            this.mavenResourcesFiltering.filterResources(mavenResourcesExecution);
        }
        catch (MavenFilteringException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    private boolean isFilteringEnabled(Resource[] resources) {
        for (Resource resource : resources) {
            if (!resource.isFiltering()) continue;
            return true;
        }
        return false;
    }
}

