/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.visual.action.AlignWithMoveDecorator;
import org.netbeans.api.visual.action.AlignWithWidgetCollector;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;

public class AlignWithSupport {
    private static final int GRAVITY = 10;
    private AlignWithWidgetCollector collector;
    private LayerWidget interractionLayer;
    private AlignWithMoveDecorator decorator;
    private ConnectionWidget lineWidget1;
    private ConnectionWidget lineWidget2;

    public AlignWithSupport(AlignWithWidgetCollector collector, LayerWidget interractionLayer, AlignWithMoveDecorator decorator) {
        this.collector = collector;
        this.interractionLayer = interractionLayer;
        this.decorator = decorator;
    }

    protected Point locationSuggested(Widget widget, Rectangle sceneWidgetBounds, Point suggestedLocation, boolean horizontal, boolean vertical, boolean bothSides, boolean snapHack) {
        int d;
        boolean snapNow;
        int a2;
        int a1;
        int b2;
        int b1;
        boolean snap;
        Point point = new Point(suggestedLocation);
        Collection<Rectangle> regions = this.collector.getRegions(widget);
        if (horizontal) {
            snap = false;
            int xs = 0;
            int x = 0;
            int dx = 0;
            int y1 = 0;
            int y2 = 0;
            b1 = sceneWidgetBounds.x;
            b2 = sceneWidgetBounds.x + sceneWidgetBounds.width;
            for (Rectangle rectangle : regions) {
                a1 = rectangle.x;
                a2 = a1 + rectangle.width;
                snapNow = false;
                d = Math.abs(a1 - b1);
                if (snap && d < dx || !snap && d < 10) {
                    snapNow = true;
                    snap = true;
                    x = xs = a1;
                    dx = d;
                }
                if (bothSides) {
                    d = Math.abs(a1 - b2);
                    if (snap && d < dx || !snap && d < 10) {
                        snapNow = true;
                        snap = true;
                        x = a1;
                        xs = a1 - sceneWidgetBounds.width;
                        dx = d;
                    }
                }
                d = Math.abs(a2 - b1);
                if (snap && d < dx || !snap && d < 10) {
                    snapNow = true;
                    snap = true;
                    x = xs = a2;
                    dx = d;
                }
                if (bothSides) {
                    d = Math.abs(a2 - b2);
                    if (snap && d < dx || !snap && d < 10) {
                        snapNow = true;
                        snap = true;
                        x = a2;
                        xs = a2 - sceneWidgetBounds.width;
                        dx = d;
                    }
                }
                if (!snapNow) continue;
                y1 = rectangle.y;
                y2 = rectangle.y + rectangle.height;
            }
            if (snap) {
                point.x = xs;
                if (snapHack) {
                    point.x -= widget.getBounds().x;
                }
            }
            if (this.interractionLayer != null) {
                this.lineWidget1.setControlPoints(snap ? Arrays.asList(new Point(x, Math.min(sceneWidgetBounds.y, y1)), new Point(x, Math.max(sceneWidgetBounds.y + sceneWidgetBounds.height, y2))) : Collections.emptyList(), true);
            }
        }
        if (vertical) {
            snap = false;
            int ys = 0;
            int y = 0;
            int dy = 0;
            int x1 = 0;
            int x2 = 0;
            b1 = sceneWidgetBounds.y;
            b2 = sceneWidgetBounds.y + sceneWidgetBounds.height;
            for (Rectangle rectangle : regions) {
                a1 = rectangle.y;
                a2 = a1 + rectangle.height;
                snapNow = false;
                d = Math.abs(a1 - b1);
                if (snap && d < dy || !snap && d < 10) {
                    snapNow = true;
                    snap = true;
                    y = ys = a1;
                    dy = d;
                }
                d = Math.abs(a1 - b2);
                if (snap && d < dy || !snap && d < 10) {
                    snapNow = true;
                    snap = true;
                    ys = a1 - sceneWidgetBounds.height;
                    y = a1;
                    dy = d;
                }
                d = Math.abs(a2 - b1);
                if (snap && d < dy || !snap && d < 10) {
                    snapNow = true;
                    snap = true;
                    y = ys = a2;
                    dy = d;
                }
                d = Math.abs(a2 - b2);
                if (snap && d < dy || !snap && d < 10) {
                    snapNow = true;
                    snap = true;
                    ys = a2 - sceneWidgetBounds.height;
                    y = a2;
                    dy = d;
                }
                if (!snapNow) continue;
                x1 = rectangle.x;
                x2 = rectangle.x + rectangle.width;
            }
            if (snap) {
                point.y = ys;
                if (snapHack) {
                    point.y -= widget.getBounds().y;
                }
            }
            if (this.interractionLayer != null) {
                this.lineWidget2.setControlPoints(snap ? Arrays.asList(new Point(Math.min(sceneWidgetBounds.x, x1), y), new Point(Math.max(sceneWidgetBounds.x + sceneWidgetBounds.width, x2), y)) : Collections.emptyList(), true);
            }
        }
        return point;
    }

    public void show() {
        if (this.interractionLayer != null) {
            if (this.lineWidget1 == null) {
                this.lineWidget1 = this.decorator.createLineWidget(this.interractionLayer.getScene());
            }
            if (this.lineWidget2 == null) {
                this.lineWidget2 = this.decorator.createLineWidget(this.interractionLayer.getScene());
            }
            this.interractionLayer.addChild(this.lineWidget1);
            this.interractionLayer.addChild(this.lineWidget2);
            this.lineWidget1.setControlPoints(Collections.<Point>emptySet(), true);
            this.lineWidget2.setControlPoints(Collections.<Point>emptySet(), true);
        }
    }

    public void hide() {
        if (this.interractionLayer != null) {
            this.interractionLayer.removeChild(this.lineWidget1);
            this.interractionLayer.removeChild(this.lineWidget2);
        }
    }
}

