/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

public class FlowNetwork {
    private EmbeddedPlanarGraph originalGraph;
    private Map<MGraph.Vertex, Node> vertexNodeMap;
    private Map<Face, Node> faceNodeMap;
    public Collection<Node> nodes;
    public Collection<Arc> arcs;
    public Node source;
    public Node sink;

    public static FlowNetwork createGraph(EmbeddedPlanarGraph graph) {
        FlowNetwork network = new FlowNetwork(graph);
        network.createGraph();
        return network;
    }

    private FlowNetwork(EmbeddedPlanarGraph graph) {
        this.originalGraph = graph;
        this.vertexNodeMap = new HashMap<MGraph.Vertex, Node>();
        this.faceNodeMap = new HashMap<Face, Node>();
        this.nodes = new ArrayList<Node>();
        this.arcs = new ArrayList<Arc>();
    }

    private void createGraph() {
        Collection<MGraph.Vertex> vertices = this.originalGraph.getOriginalGraph().getVertices();
        ArrayList<Face> faces = this.originalGraph.getFaces();
        for (MGraph.Vertex v : vertices) {
            Node vn = this.getNode(v);
            for (Face f : faces) {
                if (!f.containsVertex(v)) continue;
                Node fn = this.getNode(f);
                List<Face.Dart> darts = f.getDartsFrom(v);
                for (Face.Dart d : darts) {
                    this.addArc(vn, fn, d);
                }
            }
        }
        for (Face f : faces) {
            Node fn = this.getNode(f);
            for (Face.Dart d : f.getDarts()) {
                Face nf = this.originalGraph.getOppositeFace(f, d);
                Node nfn = this.getNode(nf);
                this.addArc(fn, nfn, d);
            }
        }
        this.source = new Node();
        this.source.isSource = true;
        this.sink = new Node();
        this.sink.isSink = true;
        int sourceProduction = 0;
        int sinkProduction = 0;
        for (Node n : this.getNodes()) {
            Arc arc;
            if (n.production > 0) {
                arc = this.addArc(this.source, n);
                arc.capacity = n.production;
                arc.cost = 0;
                sourceProduction += n.production;
                continue;
            }
            if (n.production >= 0) continue;
            arc = this.addArc(n, this.sink);
            arc.capacity = -n.production;
            arc.cost = 0;
            sinkProduction += n.production;
        }
        this.source.production = sourceProduction;
        this.sink.production = sinkProduction;
    }

    public EmbeddedPlanarGraph getOriginalGraph() {
        return this.originalGraph;
    }

    public Node getNode(MGraph.Vertex vertex) {
        Node node = this.vertexNodeMap.get(vertex);
        if (node == null) {
            node = new Node(vertex);
            this.vertexNodeMap.put(vertex, node);
            this.nodes.add(node);
        }
        return node;
    }

    public Node getNode(Face face) {
        Node node = this.faceNodeMap.get(face);
        if (node == null) {
            node = new Node(face);
            this.faceNodeMap.put(face, node);
            this.nodes.add(node);
        }
        return node;
    }

    public Node getSource() {
        return this.source;
    }

    public Node getSink() {
        return this.sink;
    }

    public Arc addArc(Node sourceNode, Node destNode, Face.Dart dart) {
        Arc arc = new Arc(sourceNode, destNode, dart);
        this.arcs.add(arc);
        return arc;
    }

    public Arc addArc(Node sourceNode, Node destNode) {
        return this.addArc(sourceNode, destNode, null);
    }

    public void removeArc(Arc arc) {
        this.arcs.remove(arc);
        Node node = arc.getSourceNode();
        if (node != null) {
            node.removeOutputArc(arc);
        }
        if ((node = arc.getDestinationNode()) != null) {
            node.removeInputArc(arc);
        }
    }

    public Collection<Node> getNodes() {
        return this.nodes;
    }

    public Collection<Arc> getArcs() {
        return this.arcs;
    }

    public void removeSourceAndSink() {
        this.nodes.remove(this.source);
        this.nodes.remove(this.sink);
        ArrayList<Arc> _arcs = new ArrayList<Arc>(this.source.getOutputArcs());
        for (Arc a : _arcs) {
            this.removeArc(a);
        }
        _arcs = new ArrayList<Arc>(this.sink.getInputArcs());
        for (Arc a : _arcs) {
            this.removeArc(a);
        }
    }

    public String toString() {
        String s = "Flow Network\n";
        s = s + "Source:\n" + this.source + "\n";
        s = s + "Sink:\n" + this.sink + "\n";
        s = s + "Nodes:\n";
        for (Node n : this.nodes) {
            s = s + n + "\n";
        }
        return s;
    }

    public static class ResidualArc
    extends Arc {
        private boolean isReverse;
        private Arc arc;

        public ResidualArc(Node sourceNode, Node destNode, Arc arc, boolean isReverse) {
            super(sourceNode, destNode, null);
            this.isReverse = isReverse;
            this.arc = arc;
            if (!isReverse) {
                this.setCapacity(arc.getCapacity() - arc.getFlow());
            } else {
                this.setCapacity(arc.getFlow());
            }
            this.setCost(arc.getCost());
        }

        public boolean isReverse() {
            return this.isReverse;
        }

        public Arc getArc() {
            return this.arc;
        }

        @Override
        public String toString() {
            String s = "ResidualArc:\n";
            s = s + "isReverse = " + this.isReverse + "\n";
            s = s + "capacity = " + this.getCapacity() + "\n";
            s = s + "cost = " + this.getCost() + "\n";
            s = s + "flow = " + this.getFlow() + "\n";
            return s;
        }
    }

    public static class ResidualFlowNetwork
    extends FlowNetwork {
        private Map<Arc, ResidualArc> arcToResidualArcMap;
        private Map<Arc, ResidualArc> arcToReverseResidualArcMap;
        private FlowNetwork network;
        private Map<Node, Node> nodeMap;

        public ResidualFlowNetwork(FlowNetwork network) {
            super(null);
            this.network = network;
            this.nodeMap = new HashMap<Node, Node>();
            this.arcToResidualArcMap = new HashMap<Arc, ResidualArc>();
            this.arcToReverseResidualArcMap = new HashMap<Arc, ResidualArc>();
            this.source = this.getNode(network.getSource());
            this.source.isSource = true;
            this.sink = this.getNode(network.getSink());
            this.sink.isSink = true;
            for (Arc arc : network.getArcs()) {
                this.addResidualArc(arc);
            }
        }

        private void addResidualArc(Arc arc) {
            Node sourceNode = this.getNode(arc.getSourceNode());
            Node destNode = this.getNode(arc.getDestinationNode());
            ResidualArc residualArc = new ResidualArc(sourceNode, destNode, arc, false);
            this.arcToResidualArcMap.put(arc, residualArc);
            ResidualArc reverseResidualArc = new ResidualArc(destNode, sourceNode, arc, true);
            this.arcToReverseResidualArcMap.put(arc, reverseResidualArc);
        }

        public ResidualArc getResidualArcFromArc(Arc arc) {
            return this.arcToResidualArcMap.get(arc);
        }

        public ResidualArc getReverseResidualArcFromArc(Arc arc) {
            return this.arcToReverseResidualArcMap.get(arc);
        }

        private Node getNode(Node node) {
            Node residualNode = this.nodeMap.get(node);
            if (residualNode == null) {
                if (node.isVertexNode()) {
                    residualNode = this.getNode(node.getVertex());
                } else if (node.isFaceNode()) {
                    residualNode = this.getNode(node.getFace());
                } else {
                    residualNode = new Node();
                    residualNode.setProduction(node.getProduction());
                    this.nodes.add(residualNode);
                }
                this.nodeMap.put(node, residualNode);
            }
            return residualNode;
        }
    }

    public static class Arc {
        private Node sourceNode;
        private Node destinationNode;
        private int capacity;
        private int cost;
        private int flow;
        private int lowerBound;
        private Face.Dart dart;

        public Arc(Node source, Node destination, Face.Dart dart) {
            this.sourceNode = source;
            this.destinationNode = destination;
            this.dart = dart;
            this.flow = 0;
            if (this.sourceNode.isVertexNode() || destination.isVertexNode()) {
                this.lowerBound = 0;
                this.capacity = 3;
                this.cost = 0;
            } else if (this.sourceNode.isFaceNode() && this.destinationNode.isFaceNode()) {
                this.lowerBound = 0;
                this.capacity = Integer.MAX_VALUE;
                this.cost = 1;
            }
            this.sourceNode.addOutputArc(this);
            this.destinationNode.addInputArc(this);
        }

        public Node getSourceNode() {
            return this.sourceNode;
        }

        public Node getDestinationNode() {
            return this.destinationNode;
        }

        public Face.Dart getDart() {
            return this.dart;
        }

        public int getCost() {
            return this.cost;
        }

        public void setCost(int cost) {
            this.cost = cost;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public void setCapacity(int capacity) {
            this.capacity = capacity;
        }

        public void setFlow(int flow) {
            this.flow = flow;
        }

        public int getFlow() {
            return this.flow;
        }

        public void addFlow(int delta) {
            this.flow += delta;
        }

        public void substractCapacity(int delta) {
            this.capacity -= delta;
        }

        public void addCapacity(int delta) {
            this.capacity += delta;
        }

        public boolean isVertexArc() {
            return this.sourceNode.isVertexNode();
        }

        public boolean isFaceArc() {
            return this.sourceNode.isFaceNode() && this.destinationNode.isFaceNode();
        }

        public String toString() {
            String s = "Arc:\n";
            s = s + "capacity = " + this.capacity + "\n";
            s = s + "cost = " + this.cost + "\n";
            s = s + "flow = " + this.flow + "\n";
            s = s + "lowerBound = " + this.lowerBound + "\n";
            return s;
        }
    }

    public static class Node {
        private Face face;
        private MGraph.Vertex vertex;
        private Collection<Arc> inputArcs = new ArrayList<Arc>();
        private Collection<Arc> outputArcs = new ArrayList<Arc>();
        private int production;
        private boolean isSource;
        private boolean isSink;

        public Node() {
        }

        public Node(Face face) {
            this();
            this.face = face;
            int degree = face.getDegree();
            this.production = face.isOuterFace() ? -(1 * degree + 4) : (degree == 2 ? 0 : -(1 * degree - 4));
        }

        public Node(MGraph.Vertex vertex) {
            this();
            this.vertex = vertex;
            this.production = 4 - vertex.getDegree();
        }

        public MGraph.Vertex getVertex() {
            return this.vertex;
        }

        public Face getFace() {
            return this.face;
        }

        public boolean isFaceNode() {
            return this.face != null;
        }

        public boolean isVertexNode() {
            return this.vertex != null;
        }

        public void addInputArc(Arc arc) {
            this.inputArcs.add(arc);
        }

        public void removeInputArc(Arc arc) {
            this.inputArcs.remove(arc);
        }

        public void addOutputArc(Arc arc) {
            this.outputArcs.add(arc);
        }

        public void removeOutputArc(Arc arc) {
            this.outputArcs.remove(arc);
        }

        public Collection<Arc> getInputArcs() {
            return this.inputArcs;
        }

        public Collection<Arc> getOutputArcs() {
            return this.outputArcs;
        }

        public Arc getArcToVia(Node node, Face.Dart dart) {
            MGraph.Edge edge = dart.getEdge();
            for (Arc arc : this.outputArcs) {
                if (arc.getDestinationNode() != node || arc.getDart().getEdge() != edge) continue;
                return arc;
            }
            return null;
        }

        public int getProduction() {
            return this.production;
        }

        public void setProduction(int production) {
            this.production = production;
        }

        public String toString() {
            String s = "Node: \n";
            if (this.isSource) {
                s = "Source Node:\n";
            } else if (this.isSink) {
                s = "Sink Node:\n";
            }
            s = s + "hashCode: " + this.hashCode() + "\n";
            s = s + "vertex: " + this.vertex + "\n";
            s = s + "face: " + this.face + "\n";
            s = s + "production: " + this.production + "\n";
            return s;
        }
    }
}

