/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor;

import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.modules.editor.lib2.actions.MacroRecording;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class AbstractEditorAction
extends TextAction {
    private static Logger UILOG = Logger.getLogger("org.netbeans.ui.actions.editor");
    private static final long serialVersionUID = 1L;
    private final Map<String, ?> attrs;

    protected AbstractEditorAction(Map<String, ?> attrs) {
        super(null);
        this.attrs = attrs;
        if (attrs != null) {
            String actionName = (String)attrs.get("Name");
            if (actionName == null) {
                throw new IllegalArgumentException("Null Action.NAME attribute for action " + this.getClass());
            }
            this.putValue("Name", actionName);
        }
    }

    protected AbstractEditorAction() {
        this((Map<String, ?>)null);
    }

    public abstract void actionPerformed(ActionEvent var1, JTextComponent var2);

    protected void actionNameUpdate(String actionName) {
    }

    protected boolean asynchronous() {
        return false;
    }

    protected final String actionName() {
        return (String)this.getValue("Name");
    }

    protected final void resetCaretMagicPosition(JTextComponent component) {
        Caret caret;
        if (component != null && (caret = component.getCaret()) != null) {
            caret.setMagicCaretPosition(null);
        }
    }

    @Override
    public final void actionPerformed(final ActionEvent evt) {
        String actionNameLowerCase;
        final JTextComponent component = this.getTextComponent(evt);
        MacroRecording.get().recordAction(this, evt);
        if (UILOG.isLoggable(Level.FINE) && (actionNameLowerCase = this.actionName()) != null && !"default-typed".equals(actionNameLowerCase) && -1 == actionNameLowerCase.indexOf("caret") && -1 == actionNameLowerCase.indexOf("delete") && -1 == actionNameLowerCase.indexOf("selection") && -1 == actionNameLowerCase.indexOf("build-tool-tip") && -1 == actionNameLowerCase.indexOf("build-popup-menu") && -1 == actionNameLowerCase.indexOf("page-up") && -1 == actionNameLowerCase.indexOf("page-down") && -1 == actionNameLowerCase.indexOf("-kit-install")) {
            LogRecord r = new LogRecord(Level.FINE, "UI_ACTION_EDITOR");
            r.setResourceBundle(NbBundle.getBundle(AbstractEditorAction.class));
            if (evt != null) {
                r.setParameters(new Object[]{evt, evt.toString(), this, this.toString(), this.getValue("Name")});
            } else {
                r.setParameters(new Object[]{"no-ActionEvent", "no-ActionEvent", this, this.toString(), this.getValue("Name")});
            }
            r.setLoggerName(UILOG.getName());
            UILOG.log(r);
        }
        if (this.asynchronous()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    AbstractEditorAction.this.actionPerformed(evt, component);
                }
            });
        } else {
            this.actionPerformed(evt, component);
        }
    }

    @Override
    public Object getValue(String key) {
        Object value = super.getValue(key);
        if (value == null && this.attrs != null && !"instanceCreate".equals(key)) {
            value = this.attrs.get(key);
        }
        return value;
    }

    @Override
    public void putValue(String key, Object value) {
        super.putValue(key, value);
        if ("Name".equals(key) && value instanceof String) {
            this.actionNameUpdate((String)value);
        }
    }
}

