/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.editor.EditorActionRegistration;
import org.netbeans.api.editor.EditorActionRegistrations;
import org.netbeans.modules.editor.lib2.actions.EditorActionUtilities;
import org.netbeans.modules.editor.lib2.actions.PresenterEditorAction;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public final class EditorActionRegistrationProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return new HashSet<String>(Arrays.asList(EditorActionRegistration.class.getCanonicalName(), EditorActionRegistrations.class.getCanonicalName()));
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        if (roundEnv.processingOver()) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(EditorActionRegistration.class)) {
            EditorActionRegistration annotation = element.getAnnotation(EditorActionRegistration.class);
            this.register(element, annotation);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(EditorActionRegistrations.class)) {
            EditorActionRegistrations annotationArray = element.getAnnotation(EditorActionRegistrations.class);
            for (EditorActionRegistration annotation : annotationArray.value()) {
                this.register(element, annotation);
            }
        }
        return true;
    }

    private void register(Element e, EditorActionRegistration annotation) throws LayerGenerationException {
        int toolBarPosition;
        String menuText;
        String shortDescription;
        String methodName;
        String className;
        DeclaredType swingActionType = this.processingEnv.getTypeUtils().getDeclaredType(this.processingEnv.getElementUtils().getTypeElement("javax.swing.Action"), new TypeMirror[0]);
        DeclaredType utilMapType = this.processingEnv.getTypeUtils().getDeclaredType(this.processingEnv.getElementUtils().getTypeElement("java.util.Map"), new TypeMirror[0]);
        boolean directActionCreation = false;
        switch (e.getKind()) {
            case CLASS: {
                boolean mapCtorPublic;
                className = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
                if (e.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(className + " must not be abstract", e);
                }
                if (!e.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    throw new LayerGenerationException(className + " is not public", e);
                }
                Element defaultCtor = null;
                Element mapCtor = null;
                for (ExecutableElement constructor : ElementFilter.constructorsIn(e.getEnclosedElements())) {
                    List<? extends VariableElement> params = constructor.getParameters();
                    if (params.isEmpty()) {
                        defaultCtor = constructor;
                        continue;
                    }
                    if (params.size() != 1 || !this.processingEnv.getTypeUtils().isAssignable(params.get(0).asType(), utilMapType)) continue;
                    mapCtor = constructor;
                }
                String msgBase = "No-argument (or single-argument \"Map<String,?> attrs\") constructor";
                if (defaultCtor == null && mapCtor == null) {
                    throw new LayerGenerationException(msgBase + " not present in " + className, e);
                }
                boolean defaultCtorPublic = defaultCtor != null && defaultCtor.getModifiers().contains((Object)Modifier.PUBLIC);
                boolean bl = mapCtorPublic = mapCtor != null && mapCtor.getModifiers().contains((Object)Modifier.PUBLIC);
                if (!defaultCtorPublic && !mapCtorPublic) {
                    throw new LayerGenerationException(msgBase + " not public in " + className, e);
                }
                if (!this.processingEnv.getTypeUtils().isAssignable(e.asType(), swingActionType)) {
                    throw new LayerGenerationException(className + " is not assignable to javax.swing.Action", e);
                }
                if (mapCtorPublic) {
                    directActionCreation = true;
                }
                methodName = null;
                break;
            }
            case METHOD: {
                boolean mapParam;
                className = this.processingEnv.getElementUtils().getBinaryName((TypeElement)e.getEnclosingElement()).toString();
                methodName = e.getSimpleName().toString();
                if (!e.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(className + "." + methodName + " must be static", e);
                }
                List<? extends VariableElement> params = ((ExecutableElement)e).getParameters();
                boolean emptyParams = params.isEmpty();
                boolean bl = mapParam = params.size() == 1 && this.processingEnv.getTypeUtils().isAssignable(params.get(0).asType(), utilMapType);
                if (!emptyParams && !mapParam) {
                    throw new LayerGenerationException(className + "." + methodName + " must not take arguments (or have a single-argument \"Map<String,?> attrs\")", e);
                }
                TypeMirror returnType = ((ExecutableElement)e).getReturnType();
                if (swingActionType != null && !this.processingEnv.getTypeUtils().isAssignable(returnType, swingActionType)) {
                    throw new LayerGenerationException(className + "." + methodName + " is not assignable to javax.swing.Action", e);
                }
                if (!mapParam) break;
                directActionCreation = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Annotated element is not loadable as an instance: " + e);
            }
        }
        String actionName = annotation.name();
        StringBuilder filePath = new StringBuilder(50);
        String mimeType = annotation.mimeType();
        filePath.append("Editors");
        if (mimeType.length() > 0) {
            filePath.append("/").append(mimeType);
        }
        filePath.append("/Actions/").append(actionName).append(".instance");
        LayerBuilder layer = this.layer(new Element[]{e});
        LayerBuilder.File file = layer.file(filePath.toString());
        String preferencesKey = annotation.preferencesKey();
        boolean checkBoxPresenter = preferencesKey.length() > 0;
        String iconResource = annotation.iconResource();
        if (iconResource.length() > 0) {
            file.stringvalue("iconBase", iconResource);
        }
        if ((shortDescription = annotation.shortDescription()).length() > 0) {
            if ("BY_ACTION_NAME".equals(shortDescription)) {
                shortDescription = "#" + actionName;
            }
            file.bundlevalue("ShortDescription", shortDescription);
        }
        if ((menuText = annotation.menuText()).length() > 0) {
            file.bundlevalue("menuText", menuText);
        } else if (shortDescription.length() > 0) {
            menuText = shortDescription;
            file.bundlevalue("menuText", menuText);
        }
        String popupText = annotation.popupText();
        if (popupText.length() > 0) {
            file.bundlevalue("popupText", popupText);
        } else if (menuText.length() > 0) {
            popupText = menuText;
            file.bundlevalue("popupText", popupText);
        }
        String presenterActionName = null;
        String menuPath = annotation.menuPath();
        int menuPosition = annotation.menuPosition();
        if (menuPosition != Integer.MAX_VALUE) {
            StringBuilder presenterFilePath = new StringBuilder(50);
            presenterFilePath.append("Menu/");
            if (menuPath.length() > 0) {
                presenterFilePath.append(menuPath).append('/');
            }
            presenterFilePath.append(actionName).append(".shadow");
            LayerBuilder.File presenterShadowFile = layer.file(presenterFilePath.toString());
            if (presenterActionName == null) {
                presenterActionName = checkBoxPresenter ? "Editors/Actions/" + actionName + ".instance" : this.generatePresenterAction(layer, actionName);
            }
            presenterShadowFile.stringvalue("originalFile", presenterActionName);
            presenterShadowFile.intvalue("position", menuPosition);
            presenterShadowFile.write();
        }
        String popupPath = annotation.popupPath();
        int popupPosition = annotation.popupPosition();
        if (popupPosition != Integer.MAX_VALUE) {
            StringBuilder presenterFilePath = new StringBuilder(50);
            presenterFilePath.append("Editors/Popup/");
            if (mimeType.length() > 0) {
                presenterFilePath.append(mimeType).append("/");
            }
            if (popupPath.length() > 0) {
                presenterFilePath.append(popupPath).append('/');
            }
            presenterFilePath.append(actionName).append(".shadow");
            LayerBuilder.File presenterShadowFile = layer.file(presenterFilePath.toString());
            if (presenterActionName == null) {
                presenterActionName = checkBoxPresenter ? "Editors/Actions/" + actionName + ".instance" : this.generatePresenterAction(layer, actionName);
            }
            presenterShadowFile.stringvalue("originalFile", presenterActionName);
            presenterShadowFile.intvalue("position", popupPosition);
            presenterShadowFile.write();
        }
        if ((toolBarPosition = annotation.toolBarPosition()) != Integer.MAX_VALUE) {
            StringBuilder presenterFilePath = new StringBuilder(50);
            presenterFilePath.append("Editors/Toolbar/");
            if (mimeType.length() > 0) {
                presenterFilePath.append(mimeType).append("/");
            }
            presenterFilePath.append(actionName).append(".shadow");
            LayerBuilder.File presenterShadowFile = layer.file(presenterFilePath.toString());
            if (presenterActionName == null) {
                presenterActionName = this.generatePresenterAction(layer, actionName);
            }
            presenterShadowFile.stringvalue("originalFile", presenterActionName);
            presenterShadowFile.intvalue("position", toolBarPosition);
            presenterShadowFile.write();
        }
        if (preferencesKey.length() > 0) {
            file.stringvalue("preferencesKey", preferencesKey);
            file.methodvalue("preferencesNode", EditorActionUtilities.class.getName(), "getGlobalPreferences");
        }
        file.stringvalue("helpID", actionName);
        file.methodvalue("AcceleratorKey", EditorActionUtilities.class.getName(), "getAccelerator");
        file.stringvalue("Name", actionName);
        int weight = annotation.weight();
        if (weight != 0) {
            file.intvalue("weight", weight);
        }
        if (directActionCreation) {
            if (methodName != null) {
                file.methodvalue("instanceCreate", className, methodName);
            } else {
                file.newvalue("instanceCreate", className);
            }
        } else {
            file.methodvalue("instanceCreate", "org.openide.awt.Actions", checkBoxPresenter ? "checkbox" : "alwaysEnabled");
            file.stringvalue("displayName", actionName);
            if (methodName != null) {
                file.methodvalue("delegate", className, methodName);
            } else {
                file.newvalue("delegate", className);
            }
        }
        file.write();
    }

    private String generatePresenterAction(LayerBuilder layer, String actionName) {
        String presenterActionName = "Editors/ActionPresenters/" + actionName + ".instance";
        LayerBuilder.File presenterActionFile = layer.file(presenterActionName);
        presenterActionFile.methodvalue("instanceCreate", PresenterEditorAction.class.getName(), "create");
        presenterActionFile.stringvalue("Name", actionName);
        presenterActionFile.write();
        return presenterActionName;
    }
}

