/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.ListenerList;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public final class SyntaxHighlighting
extends AbstractHighlightsContainer
implements TokenHierarchyListener,
ChangeListener {
    private static final Logger LOG = Logger.getLogger(SyntaxHighlighting.class.getName());
    public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.SyntaxHighlighting";
    private static final HashMap<String, FCSInfo<?>> globalFCSCache = new HashMap();
    private final HashMap<String, FCSInfo<?>> fcsCache = new HashMap();
    private final Document document;
    private final String mimeTypeForOptions;
    private TokenHierarchy<? extends Document> hierarchy = null;
    private long version = 0L;
    private AttributeSet cachedAttrs;
    static AttributeSet TEST_FALLBACK_COLORING;

    public SyntaxHighlighting(Document document) {
        this.document = document;
        String mimeType = (String)document.getProperty("mimeType");
        this.mimeTypeForOptions = mimeType != null && mimeType.startsWith("test") ? mimeType : null;
        this.findFCSInfo("", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        SyntaxHighlighting syntaxHighlighting = this;
        synchronized (syntaxHighlighting) {
            if (this.hierarchy == null) {
                this.hierarchy = TokenHierarchy.get((Document)this.document);
                this.hierarchy.addTokenHierarchyListener((TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)this, this.hierarchy));
            }
            if (this.hierarchy.isActive()) {
                return new HSImpl(this.version, this.hierarchy, startOffset, endOffset);
            }
            return HighlightsSequence.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
        if (evt.type() == TokenHierarchyEventType.LANGUAGE_PATHS) {
            return;
        }
        SyntaxHighlighting syntaxHighlighting = this;
        synchronized (syntaxHighlighting) {
            ++this.version;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder();
            TokenSequence ts = this.hierarchy.tokenSequence();
            sb.append("\n");
            sb.append("Tokens after change: <").append(evt.affectedStartOffset()).append(", ").append(evt.affectedEndOffset()).append(">\n");
            SyntaxHighlighting.dumpSequence(ts, sb);
            sb.append("--------------------------------------------\n\n");
            LOG.finest(sb.toString());
        }
        this.fireHighlightsChange(evt.affectedStartOffset(), evt.affectedEndOffset());
    }

    private String languagePathToMimePathOptions(LanguagePath languagePath) {
        if (languagePath.size() == 1) {
            return this.mimeTypeForOptions;
        }
        if (languagePath.size() > 1) {
            return this.mimeTypeForOptions + "/" + languagePath.subPath(1).mimePath();
        }
        throw new IllegalStateException("LanguagePath should not be empty.");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireHighlightsChange(0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends TokenId> FCSInfo<T> findFCSInfo(String mimePath, Language<T> language) {
        FCSInfo<Object> fcsInfo = this.fcsCache.get(mimePath);
        if (fcsInfo == null) {
            HashMap<String, FCSInfo<?>> hashMap = globalFCSCache;
            synchronized (hashMap) {
                FCSInfo<?> fcsI = globalFCSCache.get(mimePath);
                fcsInfo = fcsI;
                if (fcsInfo == null) {
                    fcsInfo = new FCSInfo<T>(mimePath, language);
                    if (this.mimeTypeForOptions == null) {
                        globalFCSCache.put(mimePath, fcsInfo);
                    }
                }
            }
            fcsInfo.addChangeListener(WeakListeners.change((ChangeListener)this, fcsInfo));
            this.fcsCache.put(mimePath, fcsInfo);
        }
        return fcsInfo;
    }

    private static void dumpSequence(TokenSequence<?> seq, StringBuilder sb) {
        if (seq == null) {
            sb.append("Inactive TokenHierarchy");
        } else {
            seq.moveStart();
            while (seq.moveNext()) {
                TokenSequence emSeq = seq.embedded();
                if (emSeq != null) {
                    SyntaxHighlighting.dumpSequence(emSeq, sb);
                    continue;
                }
                Token token = seq.token();
                sb.append("<");
                sb.append(String.format("%3s", seq.offset())).append(", ");
                sb.append(String.format("%3s", seq.offset() + token.length())).append(", ");
                sb.append(String.format("%+3d", token.length())).append("> : ");
                sb.append(SyntaxHighlighting.tokenId(token.id(), true)).append(" : '");
                sb.append(SyntaxHighlighting.tokenText(token));
                sb.append("'\n");
            }
        }
    }

    private static String tokenId(TokenId tokenId, boolean format) {
        if (format) {
            return String.format("%20s.%-15s", tokenId.getClass().getSimpleName(), tokenId.name());
        }
        return tokenId.getClass().getSimpleName() + "." + tokenId.name();
    }

    private static String tokenText(Token<?> token) {
        CharSequence text = token.text();
        StringBuilder sb = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isISOControl(ch)) {
                switch (ch) {
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    default: {
                        sb.append("\\").append(Integer.toOctalString(ch));
                        break;
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static String attributeSet(AttributeSet as) {
        if (as == null) {
            return "AttributeSet is null";
        }
        StringBuilder sb = new StringBuilder();
        Enumeration<?> keys = as.getAttributeNames();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = as.getAttribute(key);
            if (key == null) {
                sb.append("null");
            } else {
                sb.append("'").append(key.toString()).append("'");
            }
            sb.append(" = ");
            if (value == null) {
                sb.append("null");
            } else {
                sb.append("'").append(value.toString()).append("'");
            }
            if (!keys.hasMoreElements()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private final class TSInfo<T extends TokenId> {
        final TokenSequence<T> ts;
        final FCSInfo<T> fcsInfo;

        public TSInfo(TokenSequence<T> ts) {
            this.ts = ts;
            LanguagePath languagePath = ts.languagePath();
            Language innerLanguage = languagePath.innerLanguage();
            String mimePathExt = SyntaxHighlighting.this.mimeTypeForOptions != null ? SyntaxHighlighting.this.languagePathToMimePathOptions(languagePath) : languagePath.mimePath();
            this.fcsInfo = SyntaxHighlighting.this.findFCSInfo(mimePathExt, innerLanguage);
        }

        AttributeSet findCurrentAttrs() {
            return this.findAttrs(this.ts.token().id());
        }

        AttributeSet findAttrs(T tokenId) {
            return this.fcsInfo.findAttrs(tokenId);
        }
    }

    private static final class FCSInfo<T extends TokenId>
    implements LookupListener {
        private volatile ChangeEvent changeEvent;
        private final Language<T> innerLanguage;
        private final String mimePath;
        private final ListenerList<ChangeListener> listeners;
        private final Lookup.Result<FontColorSettings> result;
        private AttributeSet[] tokenId2attrs;
        FontColorSettings fcs;

        public FCSInfo(String mimePath, Language<T> innerLanguage) {
            this.innerLanguage = innerLanguage;
            this.mimePath = mimePath;
            this.listeners = new ListenerList();
            Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)mimePath));
            this.result = lookup.lookupResult(FontColorSettings.class);
            this.result.addLookupListener((LookupListener)this);
            this.updateFCS();
        }

        synchronized AttributeSet findAttrs(T tokenId) {
            AttributeSet attrs = this.tokenId2attrs[tokenId.ordinal()];
            if (attrs == null && this.fcs != null) {
                String primary;
                String name = tokenId.name();
                attrs = this.fcs.getTokenFontColors(name);
                if (attrs == null && (primary = tokenId.primaryCategory()) != null) {
                    attrs = this.fcs.getTokenFontColors(primary);
                }
                if (attrs == null) {
                    String c;
                    List categories = this.innerLanguage.nonPrimaryTokenCategories(tokenId);
                    Iterator i$ = categories.iterator();
                    while (i$.hasNext() && (attrs = this.fcs.getTokenFontColors(c = (String)i$.next())) == null) {
                    }
                }
                if (attrs == null) {
                    attrs = TEST_FALLBACK_COLORING;
                }
                this.tokenId2attrs[tokenId.ordinal()] = attrs;
            }
            return attrs;
        }

        public void addChangeListener(ChangeListener l) {
            this.listeners.add((EventListener)l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.listeners.remove((EventListener)l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateFCS() {
            FontColorSettings newFCS = (FontColorSettings)this.result.allInstances().iterator().next();
            if (newFCS == null && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("No FontColorSettings for '" + this.mimePath + "' mime path.");
            }
            FCSInfo fCSInfo = this;
            synchronized (fCSInfo) {
                this.fcs = newFCS;
                if (this.innerLanguage != null) {
                    this.tokenId2attrs = new AttributeSet[this.innerLanguage.maxOrdinal() + 1];
                }
            }
        }

        private ChangeEvent createChangeEvent() {
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            return this.changeEvent;
        }

        public void resultChanged(LookupEvent ev) {
            this.updateFCS();
            ChangeEvent e = this.createChangeEvent();
            for (ChangeListener l : this.listeners.getListeners()) {
                l.stateChanged(e);
            }
        }
    }

    private static final class LogHelper {
        int tokenCount;
        long startTime;

        private LogHelper() {
        }
    }

    private final class HSImpl
    implements HighlightsSequence {
        private static final int S_NORMAL = 1;
        private static final int S_EMBEDDED_HEAD = 2;
        private static final int S_EMBEDDED_TAIL = 3;
        private static final int S_DONE = 4;
        private final long version;
        private final TokenHierarchy<? extends Document> scanner;
        private final int startOffset;
        private final int endOffset;
        private List<TSInfo<?>> sequences;
        private int state = -1;
        private LogHelper logHelper;

        public HSImpl(long version, TokenHierarchy<? extends Document> scanner, int startOffset, int endOffset) {
            this.version = version;
            this.scanner = scanner;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.sequences = null;
            if (LOG.isLoggable(Level.FINE)) {
                this.logHelper = new LogHelper();
                this.logHelper.startTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean moveNext() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                if (this.checkVersion()) {
                    if (this.sequences == null) {
                        this.sequences = new ArrayList();
                        TokenSequence seq = this.scanner.tokenSequence();
                        if (seq != null) {
                            seq.move(this.startOffset);
                            TSInfo tsInfo = new TSInfo(seq);
                            this.sequences.add(tsInfo);
                            this.state = 1;
                        } else {
                            this.state = 4;
                        }
                    }
                } else {
                    this.state = 4;
                }
                while (this.state != 4) {
                    TSInfo<?> tsInfo;
                    switch (this.state) {
                        case 1: {
                            this.state = this.moveTheSequence();
                            break;
                        }
                        case 2: {
                            tsInfo = this.sequences.get(this.sequences.size() - 1);
                            tsInfo.ts.moveStart();
                            if (tsInfo.ts.moveNext()) {
                                this.state = 1;
                                break;
                            }
                            throw new IllegalStateException("Invalid state");
                        }
                        case 3: {
                            this.sequences.remove(this.sequences.size() - 1);
                            this.state = this.moveTheSequence();
                            break;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Invalid state: " + this.state);
                        }
                    }
                    if (this.state == 1) {
                        tsInfo = this.sequences.get(this.sequences.size() - 1);
                        TokenSequence seq = tsInfo.ts;
                        TokenSequence embeddedSeq = seq.embedded();
                        while (embeddedSeq != null && embeddedSeq.moveNext()) {
                            TokenSequence lts = embeddedSeq;
                            this.sequences.add(new TSInfo(lts));
                            if (embeddedSeq.offset() + embeddedSeq.token().length() < this.startOffset) {
                                embeddedSeq.move(this.startOffset);
                                if (!embeddedSeq.moveNext()) {
                                    this.state = 3;
                                    break;
                                }
                            } else if (embeddedSeq.offset() > seq.offset()) {
                                this.state = 2;
                                break;
                            }
                            seq = embeddedSeq;
                            embeddedSeq = seq.embedded();
                        }
                    }
                    SyntaxHighlighting.this.cachedAttrs = null;
                    if (this.state == 4 || this.getAttributes() == null) continue;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    if (this.state != 4) {
                        ++this.logHelper.tokenCount;
                    } else {
                        LOG.fine("SyntaxHighlighting for " + this.scanner.inputSource() + ":\n-> returned " + this.logHelper.tokenCount + " token highlights for <" + this.startOffset + "," + this.endOffset + "> in " + (System.currentTimeMillis() - this.logHelper.startTime) + " ms.\n");
                    }
                }
                return this.state != 4;
            }
        }

        @Override
        public int getStartOffset() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                switch (this.state) {
                    case 1: {
                        TSInfo<?> tsInfo = this.sequences.get(this.sequences.size() - 1);
                        return Math.max(tsInfo.ts.offset(), this.startOffset);
                    }
                    case 2: {
                        TSInfo<?> embeddedTSInfo = this.sequences.get(this.sequences.size() - 2);
                        return Math.max(embeddedTSInfo.ts.offset(), this.startOffset);
                    }
                    case 3: {
                        TSInfo<?> tsInfo = this.sequences.get(this.sequences.size() - 1);
                        tsInfo.ts.moveEnd();
                        if (tsInfo.ts.movePrevious()) {
                            return Math.max(tsInfo.ts.offset() + tsInfo.ts.token().length(), this.startOffset);
                        }
                        throw new IllegalStateException("Invalid state");
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state " + this.state + ", call moveNext() first.");
            }
        }

        @Override
        public int getEndOffset() {
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                switch (this.state) {
                    case 1: {
                        TSInfo<?> tsInfo = this.sequences.get(this.sequences.size() - 1);
                        return Math.min(tsInfo.ts.offset() + tsInfo.ts.token().length(), this.endOffset);
                    }
                    case 2: {
                        TSInfo<?> tsInfo = this.sequences.get(this.sequences.size() - 1);
                        tsInfo.ts.moveStart();
                        if (tsInfo.ts.moveNext()) {
                            return Math.min(tsInfo.ts.offset(), this.endOffset);
                        }
                        TSInfo<?> embeddedTSInfo = this.sequences.get(this.sequences.size() - 2);
                        return Math.min(embeddedTSInfo.ts.offset() + embeddedTSInfo.ts.token().length(), this.endOffset);
                    }
                    case 3: {
                        TSInfo<?> embeddedTSInfo = this.sequences.get(this.sequences.size() - 2);
                        return Math.min(embeddedTSInfo.ts.offset() + embeddedTSInfo.ts.token().length(), this.endOffset);
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state " + this.state + ", call moveNext() first.");
            }
        }

        @Override
        public AttributeSet getAttributes() {
            if (SyntaxHighlighting.this.cachedAttrs != null) {
                return SyntaxHighlighting.this.cachedAttrs;
            }
            SyntaxHighlighting syntaxHighlighting = SyntaxHighlighting.this;
            synchronized (syntaxHighlighting) {
                switch (this.state) {
                    case 1: {
                        return this.findAttribs(this.sequences.size() - 1);
                    }
                    case 2: 
                    case 3: {
                        return this.findAttribs(this.sequences.size() - 2);
                    }
                    case 4: {
                        throw new NoSuchElementException();
                    }
                }
                throw new IllegalStateException("Invalid state " + this.state + ", call moveNext() first.");
            }
        }

        private AttributeSet findAttribs(int seqIdx) {
            TSInfo<?> tsInfo = this.sequences.get(seqIdx);
            AttributeSet attrs = tsInfo.findCurrentAttrs();
            if (LOG.isLoggable(Level.FINE)) {
                Token token = tsInfo.ts.token();
                TokenId tokenId = token.id();
                attrs = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, "<html><b>Token:</b> " + token.text() + "<br><b>Id:</b> " + tokenId.name() + "<br><b>Category:</b> " + tokenId.primaryCategory() + "<br><b>Ordinal:</b> " + tokenId.ordinal() + "<br><b>Mimepath:</b> " + tsInfo.ts.languagePath().mimePath()}), attrs});
            }
            return attrs;
        }

        private int moveTheSequence() {
            TSInfo<?> tsInfo = this.sequences.get(this.sequences.size() - 1);
            if (tsInfo.ts.moveNext()) {
                if (tsInfo.ts.offset() < this.endOffset) {
                    return 1;
                }
                return 4;
            }
            if (this.sequences.size() > 1) {
                TSInfo<?> embeddedTSInfo = this.sequences.get(this.sequences.size() - 2);
                tsInfo.ts.moveEnd();
                if (tsInfo.ts.movePrevious()) {
                    if (tsInfo.ts.offset() + tsInfo.ts.token().length() < embeddedTSInfo.ts.offset() + embeddedTSInfo.ts.token().length()) {
                        return 3;
                    }
                    this.sequences.remove(this.sequences.size() - 1);
                    return this.moveTheSequence();
                }
                throw new IllegalStateException("Invalid state");
            }
            this.sequences.clear();
            return 4;
        }

        private boolean checkVersion() {
            return this.version == SyntaxHighlighting.this.version;
        }
    }
}

