/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.View;
import org.netbeans.modules.editor.lib2.view.EditorView;

final class ViewReplace<V extends EditorView, CV extends EditorView> {
    final V view;
    int index;
    int removeCount;
    List<CV> added;

    ViewReplace(V view) {
        assert (view != null);
        this.view = view;
    }

    void add(CV childView) {
        if (this.added == null) {
            this.added = new ArrayList<CV>();
        }
        this.added.add(childView);
    }

    int addedSize() {
        return this.added != null ? this.added.size() : 0;
    }

    EditorView[] addedViews() {
        EditorView[] views;
        if (this.added != null) {
            views = new EditorView[this.added.size()];
            this.added.toArray(views);
        } else {
            views = null;
        }
        return views;
    }

    int removeEndIndex() {
        return this.index + this.removeCount;
    }

    int addEndIndex() {
        return this.index + this.addedSize();
    }

    int removeNext() {
        ++this.removeCount;
        return this.removeEndIndex();
    }

    void removeTillEnd() {
        this.removeCount = ((View)this.view).getViewCount() - this.index;
    }

    boolean isChanged() {
        return this.added != null || this.removeCount > 0;
    }

    boolean isMakingViewEmpty() {
        return this.index == 0 && this.removeCount == ((View)this.view).getViewCount() && this.addedSize() == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(((EditorView)this.view).getDumpId());
        sb.append(": index=").append(this.index);
        sb.append(", remove=").append(this.removeCount);
        EditorView[] addedViews = this.addedViews();
        sb.append(", added=");
        if (addedViews != null && addedViews.length > 0) {
            sb.append(addedViews.length);
        } else {
            sb.append("0");
        }
        if (!this.isChanged()) {
            sb.append(", NonChanged");
        }
        sb.append('\n');
        return sb.toString();
    }
}

