/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryEvent;
import org.netbeans.modules.editor.lib2.view.EditorViewFactoryListener;
import org.netbeans.modules.editor.lib2.view.OffsetRegion;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.ViewBuilder;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class ViewUpdates
implements DocumentListener,
EditorViewFactoryListener {
    private static final Logger LOG = Logger.getLogger(ViewUpdates.class.getName());
    private static final int REBUILD_DELAY = 0;
    private static final int MAX_VIEW_REBUILD_ATTEMPTS = 10;
    private static final RequestProcessor rebuildRegionRP = new RequestProcessor("ViewHierarchy-Region-Rebuilding", 1, false, false);
    private final Object rebuildRegionLock = new String("rebuild-region-lock");
    private final DocumentView docView;
    private EditorViewFactory[] viewFactories;
    private DocumentListener incomingModificationListener;
    private OffsetRegion rebuildRegion;
    private DocumentEvent incomingEvent;
    private final RequestProcessor.Task rebuildRegionTask = rebuildRegionRP.create((Runnable)new RebuildViews());
    private boolean listenerPriorityAwareDoc;

    public ViewUpdates(DocumentView docView) {
        this.docView = docView;
        this.incomingModificationListener = new IncomingModificationListener();
        Document doc = docView.getDocument();
        this.listenerPriorityAwareDoc = DocumentUtilities.addPriorityDocumentListener((Document)doc, (DocumentListener)((DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this.incomingModificationListener, null)), (DocumentListenerPriority)DocumentListenerPriority.FIRST);
        DocumentUtilities.addDocumentListener((Document)doc, (DocumentListener)((DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)doc)), (DocumentListenerPriority)DocumentListenerPriority.VIEW);
        assert (this.viewFactories == null);
        List<EditorViewFactory.Factory> factoryFactories = EditorViewFactory.factories();
        this.viewFactories = new EditorViewFactory[factoryFactories.size()];
        for (int i = 0; i < factoryFactories.size(); ++i) {
            this.viewFactories[i] = factoryFactories.get(i).createEditorViewFactory(docView);
            this.viewFactories[i].addEditorViewFactoryListener((EditorViewFactoryListener)WeakListeners.create(EditorViewFactoryListener.class, (EventListener)this, (Object)this.viewFactories[i]));
        }
    }

    private ViewBuilder startBuildViews() {
        ViewBuilder viewBuilder = new ViewBuilder(this.docView, this.viewFactories);
        this.docView.checkMutexAcquiredIfLogging();
        return viewBuilder;
    }

    private void finishBuildViews(ViewBuilder viewBuilder) {
        viewBuilder.finish();
        this.docView.checkIntegrityIfLoggable();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finer("ViewUpdates.buildViews(): UPDATED-DOC-VIEW:\n" + this.docView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reinitAllViews() {
        for (int i = 10; i >= 0; --i) {
            ViewBuilder viewBuilder = this.startBuildViews();
            try {
                this.fetchRebuildRegion();
                viewBuilder.initFullRebuild();
                if (!viewBuilder.createReplaceRepaintViews(i == 0)) continue;
                break;
            }
            finally {
                this.finishBuildViews(viewBuilder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ensureChildrenValid(int startIndex, int endIndex, int extraStart, int extraEnd) {
        int viewCount = this.docView.getViewCount();
        assert (startIndex < endIndex) : "startIndex=" + startIndex + " >= endIndex=" + endIndex;
        assert (endIndex <= viewCount) : "endIndex=" + endIndex + " > viewCount=" + viewCount;
        if (viewCount > 0) {
            ParagraphView pView = this.docView.getParagraphView(startIndex);
            if (pView.children != null) {
                while (++startIndex < endIndex) {
                    pView = this.docView.getParagraphView(startIndex);
                    if (pView.children != null) {
                        continue;
                    }
                    break;
                }
            } else {
                while (startIndex > 0 && extraStart > 0) {
                    pView = this.docView.getParagraphView(--startIndex);
                    if (pView.children != null) {
                        ++startIndex;
                        break;
                    }
                    --extraStart;
                }
            }
            if (startIndex < endIndex) {
                pView = this.docView.getParagraphView(endIndex - 1);
                if (pView.children != null) {
                    --endIndex;
                    while (endIndex > startIndex) {
                        pView = this.docView.getParagraphView(endIndex - 1);
                        if (pView.children != null) {
                            --endIndex;
                            continue;
                        }
                        break;
                    }
                } else {
                    while (endIndex < viewCount && extraEnd > 0) {
                        pView = this.docView.getParagraphView(endIndex++);
                        if (pView.children == null) {
                            --extraEnd;
                            continue;
                        }
                        break;
                    }
                }
                for (int i = 10; i >= 0; --i) {
                    ViewBuilder viewBuilder = this.startBuildViews();
                    try {
                        viewBuilder.initParagraphs(startIndex, endIndex, this.docView.getParagraphView(startIndex).getStartOffset(), this.docView.getParagraphView(endIndex - 1).getEndOffset());
                        if (!viewBuilder.createReplaceRepaintViews(i == 0)) continue;
                        break;
                    }
                    finally {
                        this.finishBuildViews(viewBuilder);
                    }
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.clearIncomingEvent(evt);
        if (this.docView.lock()) {
            this.docView.checkDocumentLockedIfLogging();
            try {
                if (!this.docView.op.isUpdatable()) {
                    return;
                }
                Document doc = this.docView.getDocument();
                assert (doc == evt.getDocument()) : "Invalid document";
                int insertOffset = evt.getOffset();
                int insertLength = evt.getLength();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("\nDOCUMENT-INSERT-evt: offset=" + insertOffset + ", length=" + insertLength + ", current-docViewEndOffset=" + (evt.getDocument().getLength() + 1) + '\n');
                }
                for (int i = 10; i >= 0; --i) {
                    ViewBuilder viewBuilder = this.startBuildViews();
                    try {
                        if (!viewBuilder.initModUpdate(insertOffset, insertLength, this.fetchRebuildRegion()) || !viewBuilder.createReplaceRepaintViews(i == 0)) continue;
                        this.docView.validChange().documentEvent = evt;
                        break;
                    }
                    finally {
                        this.finishBuildViews(viewBuilder);
                    }
                }
            }
            finally {
                this.docView.op.clearIncomingModification();
                this.docView.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.clearIncomingEvent(evt);
        if (this.docView.lock()) {
            this.docView.checkDocumentLockedIfLogging();
            try {
                if (!this.docView.op.isUpdatable() || this.docView.getViewCount() == 0) {
                    return;
                }
                Document doc = this.docView.getDocument();
                assert (doc == evt.getDocument()) : "Invalid document";
                int removeOffset = evt.getOffset();
                int removeLength = evt.getLength();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("\nDOCUMENT-REMOVE-evt: offset=" + removeOffset + ", length=" + removeLength + ", current-docViewEndOffset=" + (evt.getDocument().getLength() + 1) + '\n');
                }
                for (int i = 10; i >= 0; --i) {
                    ViewBuilder viewBuilder = this.startBuildViews();
                    try {
                        if (!viewBuilder.initModUpdate(removeOffset, -removeLength, this.fetchRebuildRegion()) || !viewBuilder.createReplaceRepaintViews(i == 0)) continue;
                        this.docView.validChange().documentEvent = evt;
                        break;
                    }
                    finally {
                        this.finishBuildViews(viewBuilder);
                    }
                }
            }
            finally {
                this.docView.op.clearIncomingModification();
                this.docView.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.clearIncomingEvent(evt);
        if (this.docView.lock()) {
            this.docView.checkDocumentLockedIfLogging();
            try {
                if (!this.docView.op.isUpdatable()) {
                    return;
                }
                this.docView.checkIntegrityIfLoggable();
            }
            finally {
                this.docView.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewFactoryChanged(EditorViewFactoryEvent evt) {
        boolean postRebuildTask;
        Object object = this.rebuildRegionLock;
        synchronized (object) {
            this.docView.checkDocumentLockedIfLogging();
            postRebuildTask = this.rebuildRegion == null;
            List<EditorViewFactory.Change> changes = evt.getChanges();
            for (EditorViewFactory.Change change : changes) {
                int startOffset = change.getStartOffset();
                int endOffset = change.getEndOffset();
                Document doc = this.docView.getDocument();
                int docTextLen = doc.getLength() + 1;
                startOffset = Math.min(startOffset, docTextLen);
                endOffset = Math.min(endOffset, docTextLen);
                this.rebuildRegion = OffsetRegion.union(this.rebuildRegion, doc, startOffset, endOffset, false);
            }
        }
        if (postRebuildTask) {
            this.rebuildRegionTask.schedule(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncedViewsRebuild() {
        OffsetRegion region;
        if (this.docView.op.isActive() && (region = this.fetchRebuildRegion()) != null) {
            this.docView.checkDocumentLockedIfLogging();
            for (int i = 10; i >= 0; --i) {
                ViewBuilder viewBuilder = this.startBuildViews();
                try {
                    if (!viewBuilder.initChangedRegionRebuild(region) || !viewBuilder.createReplaceRepaintViews(i == 0)) continue;
                    break;
                }
                finally {
                    this.finishBuildViews(viewBuilder);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OffsetRegion fetchRebuildRegion() {
        Object object = this.rebuildRegionLock;
        synchronized (object) {
            OffsetRegion region = this.rebuildRegion;
            this.rebuildRegion = null;
            return region;
        }
    }

    void incomingEvent(DocumentEvent evt) {
        if (this.incomingEvent != null) {
            this.docView.op.releaseChildrenUnlocked();
            LOG.log(Level.INFO, "View hierarchy rebuild due to pending document event", new Exception("Pending incoming event: " + this.incomingEvent));
        }
        this.incomingEvent = evt;
    }

    private void clearIncomingEvent(DocumentEvent evt) {
        if (this.listenerPriorityAwareDoc) {
            if (this.incomingEvent == null) {
                throw new IllegalStateException("Incoming event already cleared");
            }
            if (this.incomingEvent != evt) {
                throw new IllegalStateException("Invalid incomingEvent=" + this.incomingEvent + " != evt=" + evt);
            }
            this.incomingEvent = null;
        }
    }

    private final class RebuildViews
    implements Runnable {
        private RebuildViews() {
        }

        @Override
        public void run() {
            ((ViewUpdates)ViewUpdates.this).docView.op.syncViewsRebuild();
        }
    }

    private final class IncomingModificationListener
    implements DocumentListener {
        private IncomingModificationListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ViewUpdates.this.incomingEvent(e);
            ((ViewUpdates)ViewUpdates.this).docView.op.markIncomingModification();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ViewUpdates.this.incomingEvent(e);
            ((ViewUpdates)ViewUpdates.this).docView.op.markIncomingModification();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ViewUpdates.this.incomingEvent(e);
        }
    }
}

