/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;

public class Task
implements Runnable {
    public static final Task EMPTY = new Task();
    private static WeakHashMap<Class, Boolean> overrides;
    private static RequestProcessor RP;
    final Runnable run;
    private boolean finished;
    private HashSet<TaskListener> list;

    public Task(Runnable runnable) {
        this.run = runnable;
        if (runnable == null) {
            this.finished = true;
        }
    }

    protected Task() {
        this.run = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFinished() {
        Task task = this;
        synchronized (task) {
            return this.finished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFinished() {
        Task task = this;
        synchronized (task) {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFinished(long l) throws InterruptedException {
        Task task = this;
        synchronized (task) {
            if (this.overridesTimeoutedWaitFinished()) {
                if (this.finished) {
                    return true;
                }
                long l2 = System.currentTimeMillis() + l;
                while (true) {
                    this.wait(l);
                    if (this.finished) {
                        return true;
                    }
                    if (l == 0L) continue;
                    long l3 = System.currentTimeMillis();
                    if (l2 <= l3) {
                        return false;
                    }
                    l = l2 - l3;
                }
            }
        }
        class Run
        implements Runnable {
            Run() {
            }

            public void run() {
                Task.this.waitFinished();
            }
        }
        task = RP.post(new Run());
        return ((RequestProcessor.Task)task).waitFinished(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyRunning() {
        Task task = this;
        synchronized (task) {
            RequestProcessor.logger().log(Level.FINE, "notifyRunning: {0}", this);
            this.finished = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyFinished() {
        Iterator iterator;
        Object object = this;
        synchronized (object) {
            this.finished = true;
            RequestProcessor.logger().log(Level.FINE, "notifyFinished: {0}", this);
            this.notifyAll();
            if (this.list == null) {
                return;
            }
            iterator = ((HashSet)this.list.clone()).iterator();
        }
        while (iterator.hasNext()) {
            object = (TaskListener)iterator.next();
            object.taskFinished(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.notifyRunning();
            if (this.run != null) {
                this.run.run();
            }
        }
        finally {
            this.notifyFinished();
        }
    }

    public synchronized void addTaskListener(TaskListener taskListener) {
        if (this.list == null) {
            this.list = new HashSet();
        }
        this.list.add(taskListener);
        if (this.finished) {
            taskListener.taskFinished(this);
        }
    }

    public synchronized void removeTaskListener(TaskListener taskListener) {
        if (this.list == null) {
            return;
        }
        this.list.remove(taskListener);
    }

    public String toString() {
        return "task " + this.run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean overridesTimeoutedWaitFinished() {
        if (this.getClass() == Task.class) {
            return true;
        }
        if (this.getClass() == RequestProcessor.Task.class) {
            return true;
        }
        Class<Task> clazz = Task.class;
        synchronized (Task.class) {
            WeakHashMap<Class, Boolean> weakHashMap;
            Boolean bl;
            if (overrides == null) {
                overrides = new WeakHashMap();
                RP = new RequestProcessor("Timeout waitFinished compatibility processor", 255);
            }
            if ((bl = (weakHashMap = overrides).get(this.getClass())) != null) {
                // ** MonitorExit[var3_1] (shouldn't be in output)
                return bl;
            }
            try {
                Method method = this.getClass().getMethod("waitFinished", Long.TYPE);
                bl = method.getDeclaringClass() != Task.class;
                weakHashMap.put(this.getClass(), bl);
                // ** MonitorExit[var3_1] (shouldn't be in output)
                return bl;
            }
            catch (Exception exception) {
                Exceptions.printStackTrace(exception);
                // ** MonitorExit[var3_1] (shouldn't be in output)
                return true;
            }
        }
    }

    String debug() {
        return this.run == null ? "null" : this.run.getClass().getName();
    }

    static {
        Task.EMPTY.finished = true;
    }
}

