/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;
import org.openidex.search.SearchPattern;

public final class SearchHistory {
    private SearchPattern lastSelected;
    private PropertyChangeSupport pcs;
    private static final int MAX_SEARCH_PATTERNS_ITEMS = 50;
    private List<SearchPattern> searchPatternsList = new ArrayList<SearchPattern>(50);
    private static SearchHistory INSTANCE = null;
    public static final String LAST_SELECTED = "last-selected";
    public static final String ADD_TO_HISTORY = "add-to-history";
    private static Preferences prefs;
    private static final String PREFS_NODE = "SearchHistory";
    private static final String PROP_SEARCH_PATTERN_PREFIX = "search_pattern_";

    private SearchHistory() {
        prefs = NbPreferences.forModule(SearchHistory.class).node(PREFS_NODE);
        this.load();
    }

    public static synchronized SearchHistory getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new SearchHistory();
        }
        return INSTANCE;
    }

    private void load() {
        for (int i = 0; i < 50; ++i) {
            String searchExpr = prefs.get(PROP_SEARCH_PATTERN_PREFIX + i, null);
            if (searchExpr == null) continue;
            this.searchPatternsList.add(SearchPattern.create(searchExpr, false, false, false));
        }
    }

    public SearchPattern getLastSelected() {
        return this.lastSelected;
    }

    public void setLastSelected(SearchPattern pattern) {
        SearchPattern oldPattern = this.lastSelected;
        this.lastSelected = pattern;
        if (this.pcs != null) {
            this.pcs.firePropertyChange(LAST_SELECTED, oldPattern, pattern);
        }
    }

    private synchronized PropertyChangeSupport getPropertyChangeSupport() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.getPropertyChangeSupport().addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(pcl);
        }
    }

    public synchronized List<SearchPattern> getSearchPatterns() {
        return Collections.unmodifiableList(this.searchPatternsList);
    }

    public synchronized void add(SearchPattern pattern) {
        if (pattern == null || pattern.getSearchExpression() == null || pattern.getSearchExpression().length() == 0) {
            return;
        }
        if (this.searchPatternsList.size() > 0 && pattern.equals(this.searchPatternsList.get(0))) {
            return;
        }
        if (this.searchPatternsList.size() == 50) {
            this.searchPatternsList.remove(49);
        }
        this.searchPatternsList.add(0, pattern);
        for (int i = 0; i < this.searchPatternsList.size(); ++i) {
            prefs.put(PROP_SEARCH_PATTERN_PREFIX + i, this.searchPatternsList.get(i).getSearchExpression());
        }
        if (this.pcs != null) {
            this.pcs.firePropertyChange(ADD_TO_HISTORY, null, pattern);
        }
    }
}

