/*
 * Decompiled with CFR 0.152.
 */
package javax.lang.model.util;

import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleElementVisitor6;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class ElementKindVisitor6<R, P>
extends SimpleElementVisitor6<R, P> {
    protected ElementKindVisitor6() {
        super(null);
    }

    protected ElementKindVisitor6(R defaultValue) {
        super(defaultValue);
    }

    @Override
    public R visitPackage(PackageElement e, P p) {
        assert (e.getKind() == ElementKind.PACKAGE) : "Bad kind on PackageElement";
        return this.defaultAction(e, p);
    }

    @Override
    public R visitType(TypeElement e, P p) {
        ElementKind k = e.getKind();
        switch (k) {
            case ANNOTATION_TYPE: {
                return this.visitTypeAsAnnotationType(e, p);
            }
            case CLASS: {
                return this.visitTypeAsClass(e, p);
            }
            case ENUM: {
                return this.visitTypeAsEnum(e, p);
            }
            case INTERFACE: {
                return this.visitTypeAsInterface(e, p);
            }
        }
        throw new AssertionError((Object)("Bad kind " + (Object)((Object)k) + " for TypeElement" + e));
    }

    public R visitTypeAsAnnotationType(TypeElement e, P p) {
        return this.defaultAction(e, p);
    }

    public R visitTypeAsClass(TypeElement e, P p) {
        return this.defaultAction(e, p);
    }

    public R visitTypeAsEnum(TypeElement e, P p) {
        return this.defaultAction(e, p);
    }

    public R visitTypeAsInterface(TypeElement e, P p) {
        return this.defaultAction(e, p);
    }

    @Override
    public R visitVariable(VariableElement e, P p) {
        ElementKind k = e.getKind();
        switch (k) {
            case ENUM_CONSTANT: {
                return this.visitVariableAsEnumConstant(e, p);
            }
            case EXCEPTION_PARAMETER: {
                return this.visitVariableAsExceptionParameter(e, p);
            }
            case FIELD: {
                return this.visitVariableAsField(e, p);
            }
            case LOCAL_VARIABLE: {
                return this.visitVariableAsLocalVariable(e, p);
            }
            case PARAMETER: {
                return this.visitVariableAsParameter(e, p);
            }
            case RESOURCE_VARIABLE: {
                return this.visitVariableAsResourceVariable(e, p);
            }
        }
        throw new AssertionError((Object)("Bad kind " + (Object)((Object)k) + " for VariableElement" + e));
    }

    public R visitVariableAsEnumConstant(VariableElement e, P p) {
        return this.defaultAction(e, p);
    }

    public R visitVariableAsExceptionParameter(VariableElement e, P p) {
        return this.defaultAction(e, p);
    }

    public R visitVariableAsField(VariableElement e, P p) {
        return this.defaultAction(e, p);
    }

    public R visitVariableAsLocalVariable(VariableElement e, P p) {
        return this.defaultAction(e, p);
    }

    public R visitVariableAsParameter(VariableElement e, P p) {
        return this.defaultAction(e, p);
    }

    public R visitVariableAsResourceVariable(VariableElement e, P p) {
        return this.visitUnknown(e, p);
    }

    @Override
    public R visitExecutable(ExecutableElement e, P p) {
        ElementKind k = e.getKind();
        switch (k) {
            case CONSTRUCTOR: {
                return this.visitExecutableAsConstructor(e, p);
            }
            case INSTANCE_INIT: {
                return this.visitExecutableAsInstanceInit(e, p);
            }
            case METHOD: {
                return this.visitExecutableAsMethod(e, p);
            }
            case STATIC_INIT: {
                return this.visitExecutableAsStaticInit(e, p);
            }
        }
        throw new AssertionError((Object)("Bad kind " + (Object)((Object)k) + " for ExecutableElement" + e));
    }

    public R visitExecutableAsConstructor(ExecutableElement e, P p) {
        return this.defaultAction(e, p);
    }

    public R visitExecutableAsInstanceInit(ExecutableElement e, P p) {
        return this.defaultAction(e, p);
    }

    public R visitExecutableAsMethod(ExecutableElement e, P p) {
        return this.defaultAction(e, p);
    }

    public R visitExecutableAsStaticInit(ExecutableElement e, P p) {
        return this.defaultAction(e, p);
    }

    @Override
    public R visitTypeParameter(TypeParameterElement e, P p) {
        assert (e.getKind() == ElementKind.TYPE_PARAMETER) : "Bad kind on TypeParameterElement";
        return this.defaultAction(e, p);
    }
}

