/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import hidden.org.codehaus.plexus.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.indexer.RemoteIndexTransferListener;
import org.netbeans.modules.maven.indexer.RepositoryIndexerListener;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.spi.ArchetypeQueries;
import org.netbeans.modules.maven.indexer.spi.BaseQueries;
import org.netbeans.modules.maven.indexer.spi.ChecksumQueries;
import org.netbeans.modules.maven.indexer.spi.ClassesQuery;
import org.netbeans.modules.maven.indexer.spi.ContextLoadedQuery;
import org.netbeans.modules.maven.indexer.spi.DependencyInfoQueries;
import org.netbeans.modules.maven.indexer.spi.GenericFindQuery;
import org.netbeans.modules.maven.indexer.spi.RepositoryIndexerImplementation;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.sonatype.nexus.index.ArtifactAvailablility;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactContextProducer;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.ArtifactScanningListener;
import org.sonatype.nexus.index.FlatSearchRequest;
import org.sonatype.nexus.index.FlatSearchResponse;
import org.sonatype.nexus.index.GroupedSearchRequest;
import org.sonatype.nexus.index.GroupedSearchResponse;
import org.sonatype.nexus.index.Grouping;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.SearchEngine;
import org.sonatype.nexus.index.context.IndexCreator;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.creator.AbstractIndexCreator;
import org.sonatype.nexus.index.creator.JarFileContentsIndexCreator;
import org.sonatype.nexus.index.creator.MinimalArtifactInfoIndexCreator;
import org.sonatype.nexus.index.search.grouping.GGrouping;
import org.sonatype.nexus.index.updater.DefaultIndexUpdater;
import org.sonatype.nexus.index.updater.IndexUpdateRequest;
import org.sonatype.nexus.index.updater.IndexUpdater;
import org.sonatype.nexus.index.updater.ResourceFetcher;

public class NexusRepositoryIndexerImpl
implements RepositoryIndexerImplementation,
BaseQueries,
ChecksumQueries,
ArchetypeQueries,
DependencyInfoQueries,
ClassesQuery,
GenericFindQuery,
ContextLoadedQuery {
    private static final String MAVENINDEX_PATH = "mavenindex";
    private ArtifactRepository repository;
    private NexusIndexer indexer;
    private SearchEngine searcher;
    private IndexUpdater remoteIndexUpdater;
    private ArtifactContextProducer contextProducer;
    private WagonManager wagonManager;
    private boolean inited = false;
    private static final String NB_DEPENDENCY_GROUP = "nbdg";
    private static final String NB_DEPENDENCY_ARTIFACT = "nbda";
    private static final String NB_DEPENDENCY_VERSION = "nbdv";
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.maven.indexer.RepositoryIndexer");
    static final Mutex MUTEX = new Mutex();
    private Lookup lookup = Lookups.singleton((Object)this);
    private List<? extends IndexCreator> CREATORS;
    private static final int MAX_RESULT_COUNT = 512;
    private static final int DEFAULT_MAX_CLAUSE = 1024;
    private static final int MAX_MAX_CLAUSE = 8192;

    private List<? extends IndexCreator> getLocalRepoIndexCreators() {
        if (this.CREATORS == null) {
            this.CREATORS = Arrays.asList(new AbstractIndexCreator[]{new MinimalArtifactInfoIndexCreator(), new JarFileContentsIndexCreator(), new NbIndexCreator()});
        }
        return this.CREATORS;
    }

    public static String createLocalRepositoryPath(FileObject fo) {
        return EmbedderFactory.getProjectEmbedder().getLocalRepository().getBasedir();
    }

    @Override
    public String getType() {
        return "nexus";
    }

    @Override
    public Lookup getCapabilityLookup() {
        return this.lookup;
    }

    private void initIndexer() {
        if (!this.inited) {
            try {
                DefaultContainerConfiguration config = new DefaultContainerConfiguration();
                ClassWorld world = new ClassWorld();
                ClassRealm embedderRealm = world.newRealm("maven.embedder", MavenEmbedder.class.getClassLoader());
                ClassRealm indexerRealm = world.newRealm("maven.indexer", NexusRepositoryIndexerImpl.class.getClassLoader());
                ClassRealm plexusRealm = world.newRealm("plexus.core", NexusRepositoryIndexerImpl.class.getClassLoader());
                plexusRealm.importFrom(embedderRealm.getId(), "META-INF/plexus");
                plexusRealm.importFrom(embedderRealm.getId(), "META-INF/maven");
                plexusRealm.importFrom(indexerRealm.getId(), "META-INF/plexus");
                plexusRealm.importFrom(indexerRealm.getId(), "META-INF/maven");
                config.setClassWorld(world);
                DefaultPlexusContainer embedder = new DefaultPlexusContainer((ContainerConfiguration)config);
                this.repository = EmbedderFactory.getProjectEmbedder().getLocalRepository();
                this.indexer = (NexusIndexer)embedder.lookup(NexusIndexer.class);
                this.searcher = (SearchEngine)embedder.lookup(SearchEngine.class);
                this.remoteIndexUpdater = (IndexUpdater)embedder.lookup(IndexUpdater.class);
                this.wagonManager = (WagonManager)embedder.lookup(WagonManager.class);
                this.contextProducer = (ArtifactContextProducer)embedder.lookup(ArtifactContextProducer.class);
                this.inited = true;
            }
            catch (DuplicateRealmException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (NoSuchRealmException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ComponentLookupException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (PlexusContainerException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void loadIndexingContext(RepositoryInfo ... repoids) throws IOException {
        assert (MUTEX.isWriteAccess());
        this.initIndexer();
        for (RepositoryInfo info : repoids) {
            IndexingContext context = (IndexingContext)this.indexer.getIndexingContexts().get(info.getId());
            if (context != null) {
                String contexturl = context.getIndexUpdateUrl();
                String repourl = info.getIndexUpdateUrl();
                File contextfile = context.getRepository();
                File repofile = info.getRepositoryPath() != null ? new File(info.getRepositoryPath()) : null;
                if (contexturl == null != (repourl == null) || contexturl != null && !contexturl.equals(repourl)) {
                    LOGGER.fine("Remote context changed:" + info.getId() + ", unload/load");
                    this.unloadIndexingContext(info);
                } else if (contextfile == null != (repofile == null) || contextfile != null && !contextfile.equals(repofile)) {
                    LOGGER.fine("Local context changed:" + info.getId() + ", unload/load");
                    this.unloadIndexingContext(info);
                } else {
                    LOGGER.fine("Skipping Context :" + info.getId() + ", already loaded.");
                    continue;
                }
            }
            LOGGER.fine("Loading Context :" + info.getId());
            if (!info.isLocal() && !info.isRemoteDownloadable()) continue;
            File loc = new File(this.getDefaultIndexLocation(), info.getId());
            boolean index = false;
            if (!loc.exists() || loc.listFiles().length <= 0) {
                index = true;
                LOGGER.finer("Index Not Available :" + info.getId() + " At :" + loc.getAbsolutePath());
            }
            try {
                this.indexer.addIndexingContextForced(info.getId(), info.getId(), info.isLocal() ? new File(info.getRepositoryPath()) : null, loc, info.isRemoteDownloadable() ? info.getRepositoryUrl() : null, info.isRemoteDownloadable() ? info.getIndexUpdateUrl() : null, info.isLocal() ? this.getLocalRepoIndexCreators() : NexusIndexer.FULL_INDEX);
            }
            catch (IOException ex) {
                LOGGER.info("Found a broken index at " + loc.getAbsolutePath());
                LOGGER.log(Level.FINE, "Caused by ", ex);
                FileUtils.deleteDirectory((File)loc);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NexusRepositoryIndexerImpl.class, (String)"MSG_Reconstruct_Index"));
                this.indexer.addIndexingContextForced(info.getId(), info.getId(), info.isLocal() ? new File(info.getRepositoryPath()) : null, loc, info.isRemoteDownloadable() ? info.getRepositoryUrl() : null, info.isRemoteDownloadable() ? info.getIndexUpdateUrl() : null, info.isLocal() ? this.getLocalRepoIndexCreators() : NexusIndexer.FULL_INDEX);
            }
            if (!index) continue;
            this.indexLoadedRepo(info, true);
        }
        HashSet<String> currents = new HashSet<String>();
        for (RepositoryInfo info : RepositoryPreferences.getInstance().getRepositoryInfos()) {
            currents.add(info.getId());
        }
        HashSet<String> toRemove = new HashSet<String>(this.indexer.getIndexingContexts().keySet());
        toRemove.removeAll(currents);
        if (!toRemove.isEmpty()) {
            this.unloadIndexingContext(toRemove);
        }
    }

    private Collection<IndexingContext> getContexts(RepositoryInfo[] allrepos) {
        assert (MUTEX.isWriteAccess());
        ArrayList<IndexingContext> toRet = new ArrayList<IndexingContext>();
        for (RepositoryInfo info : allrepos) {
            IndexingContext context = (IndexingContext)this.indexer.getIndexingContexts().get(info.getId());
            if (context != null) {
                toRet.add(context);
                continue;
            }
            if (!info.isLocal() && !info.isRemoteDownloadable()) continue;
            LOGGER.info("The context '" + info.getId() + "' isn't loaded. Please file under component: maven in NetBeans issue tracking system");
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlatSearchResponse repeatedFlatSearch(FlatSearchRequest fsr, Collection<IndexingContext> contexts, boolean shouldThrow) throws IOException {
        FlatSearchResponse response = null;
        try {
            BooleanQuery.TooManyClauses tooManyC = null;
            for (int i = 1024; i <= 8192; i *= 2) {
                try {
                    BooleanQuery.setMaxClauseCount((int)i);
                    response = this.searcher.searchFlatPaged(fsr, contexts);
                }
                catch (BooleanQuery.TooManyClauses exc) {
                    tooManyC = exc;
                    response = null;
                    LOGGER.finest("TooManyClause on " + i + " clauses");
                }
                if (response == null) continue;
                LOGGER.finest("OK, passed on " + i + " clauses");
                break;
            }
            if (response == null && shouldThrow) {
                throw tooManyC;
            }
        }
        finally {
            BooleanQuery.setMaxClauseCount((int)1024);
        }
        return response;
    }

    private void unloadIndexingContext(RepositoryInfo ... repos) throws IOException {
        assert (MUTEX.isWriteAccess());
        for (RepositoryInfo repo : repos) {
            LOGGER.finer("Unloading Context :" + repo.getId());
            IndexingContext ic = (IndexingContext)this.indexer.getIndexingContexts().get(repo.getId());
            if (ic == null) continue;
            this.indexer.removeIndexingContext(ic, false);
        }
    }

    private void unloadIndexingContext(Set<String> repos) throws IOException {
        assert (MUTEX.isWriteAccess());
        for (String repo : repos) {
            LOGGER.fine("Unloading Context :" + repo);
            IndexingContext ic = (IndexingContext)this.indexer.getIndexingContexts().get(repo);
            if (ic == null) continue;
            this.indexer.removeIndexingContext(ic, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexLoadedRepo(RepositoryInfo repo, boolean updateLocal) {
        block12: {
            assert (MUTEX.isWriteAccess());
            try {
                Map indexingContexts = this.indexer.getIndexingContexts();
                IndexingContext indexingContext = (IndexingContext)indexingContexts.get(repo.getId());
                if (indexingContext == null) {
                    LOGGER.info("Indexing context could not be found :" + repo.getId());
                    return;
                }
                if (repo.isRemoteDownloadable()) {
                    LOGGER.finer("Indexing Remote Repository :" + repo.getId());
                    RemoteIndexTransferListener listener = new RemoteIndexTransferListener(repo);
                    try {
                        IndexUpdateRequest iur = new IndexUpdateRequest(indexingContext);
                        iur.setResourceFetcher((ResourceFetcher)new DefaultIndexUpdater.WagonFetcher(this.wagonManager, (TransferListener)listener, null));
                        this.remoteIndexUpdater.fetchAndUpdateIndex(iur);
                        break block12;
                    }
                    finally {
                        listener.transferCompleted(null);
                    }
                }
                LOGGER.finer("Indexing Local Repository :" + repo.getId());
                this.indexer.scan(indexingContext, (ArtifactScanningListener)new RepositoryIndexerListener(this.indexer, indexingContext), updateLocal);
            }
            catch (IOException iOException) {
                LOGGER.warning(iOException.getMessage());
            }
            finally {
                RepositoryPreferences.getInstance().setLastIndexUpdate(repo.getId(), new Date());
                this.fireChangeIndex(repo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexRepo(final RepositoryInfo repo) {
        LOGGER.finer("Indexing Context :" + repo);
        try {
            RemoteIndexTransferListener.addToActive(Thread.currentThread());
            MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() throws Exception {
                    NexusRepositoryIndexerImpl.this.initIndexer();
                    IndexingContext cntx = (IndexingContext)NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts().get(repo.getId());
                    if (cntx != null) {
                        NexusRepositoryIndexerImpl.this.indexer.removeIndexingContext(cntx, true);
                    }
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(new RepositoryInfo[]{repo});
                    NexusRepositoryIndexerImpl.this.indexLoadedRepo(repo, false);
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            RemoteIndexTransferListener.removeFromActive(Thread.currentThread());
        }
    }

    public void shutdownAll() {
        LOGGER.finer("Shutting Down All Contexts");
        try {
            MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() throws Exception {
                    if (NexusRepositoryIndexerImpl.this.inited) {
                        for (IndexingContext ic : NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts().values()) {
                            LOGGER.finer(" Shutting Down:" + ic.getId());
                            NexusRepositoryIndexerImpl.this.indexer.removeIndexingContext(ic, false);
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void updateIndexWithArtifacts(final RepositoryInfo repo, final Collection<Artifact> artifacts) {
        try {
            MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() throws Exception {
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(new RepositoryInfo[]{repo});
                    Map indexingContexts = NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts();
                    IndexingContext indexingContext = (IndexingContext)indexingContexts.get(repo.getId());
                    if (indexingContext == null) {
                        LOGGER.warning("Indexing context could not be created :" + repo.getId());
                        return null;
                    }
                    for (Artifact artifact : artifacts) {
                        File art;
                        String absolutePath;
                        if (artifact.getFile() != null) {
                            absolutePath = artifact.getFile().getAbsolutePath();
                        } else {
                            if (artifact.getVersion() == null) continue;
                            absolutePath = repo.getRepositoryPath() + File.separator + NexusRepositoryIndexerImpl.this.repository.pathOf(artifact);
                        }
                        if (!(art = new File(absolutePath)).exists()) continue;
                        ArtifactContext ac = NexusRepositoryIndexerImpl.this.contextProducer.getArtifactContext(indexingContext, art);
                        NexusRepositoryIndexerImpl.this.indexer.addArtifactToIndex(ac, indexingContext);
                    }
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fireChangeIndex(repo);
    }

    @Override
    public void deleteArtifactFromIndex(final RepositoryInfo repo, final Artifact artifact) {
        try {
            MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() throws Exception {
                    String absolutePath;
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(new RepositoryInfo[]{repo});
                    Map indexingContexts = NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts();
                    IndexingContext indexingContext = (IndexingContext)indexingContexts.get(repo.getId());
                    if (indexingContext == null) {
                        LOGGER.warning("Indexing context chould not be created :" + repo.getId());
                        return null;
                    }
                    if (artifact.getFile() != null) {
                        absolutePath = artifact.getFile().getAbsolutePath();
                    } else if (artifact.getVersion() != null) {
                        absolutePath = repo.getRepositoryPath() + File.separator + NexusRepositoryIndexerImpl.this.repository.pathOf(artifact);
                    } else {
                        return null;
                    }
                    String extension = artifact.getArtifactHandler().getExtension();
                    String pomPath = absolutePath.substring(0, absolutePath.length() - extension.length());
                    pomPath = pomPath + "pom";
                    File pom = new File(pomPath);
                    if (pom.exists()) {
                        NexusRepositoryIndexerImpl.this.indexer.deleteArtifactFromIndex(NexusRepositoryIndexerImpl.this.contextProducer.getArtifactContext(indexingContext, pom), indexingContext);
                    }
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fireChangeIndex(repo);
    }

    private void fireChangeIndex(final RepositoryInfo repo) {
        if (MUTEX.isWriteAccess()) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    NexusRepositoryIndexerImpl.this.fireChangeIndex(repo);
                }
            });
            return;
        }
        assert (!MUTEX.isWriteAccess() && !MUTEX.isReadAccess());
        repo.fireChangeIndex();
    }

    private File getDefaultIndexLocation() {
        File cacheDir;
        String userdir = System.getProperty("netbeans.user");
        if (userdir != null) {
            cacheDir = new File(new File(new File(userdir, "var"), "cache"), MAVENINDEX_PATH);
        } else {
            File root = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            cacheDir = new File(root, MAVENINDEX_PATH);
        }
        cacheDir.mkdirs();
        return cacheDir;
    }

    @Override
    public Set<String> getGroups(List<RepositoryInfo> repos) {
        return this.filterGroupIds("", repos);
    }

    @Override
    public Set<String> filterGroupIds(final String prefix, final List<RepositoryInfo> repos) {
        final RepositoryInfo[] allrepos = repos.toArray(new RepositoryInfo[repos.size()]);
        try {
            return (Set)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Set<String>>(){

                public Set<String> run() throws Exception {
                    TreeSet<String> groups = new TreeSet<String>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(allrepos);
                    ArrayList<RepositoryInfo> slowCheck = new ArrayList<RepositoryInfo>();
                    for (RepositoryInfo repo : repos) {
                        IndexingContext context;
                        if (!repo.isLocal() && !repo.isRemoteDownloadable() || (context = (IndexingContext)NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts().get(repo.getId())) == null) continue;
                        Set all = context.getAllGroups();
                        if (all.size() > 0) {
                            if (prefix.length() == 0) {
                                groups.addAll(all);
                                continue;
                            }
                            for (String gr : all) {
                                if (!gr.startsWith(prefix)) continue;
                                groups.add(gr);
                            }
                            continue;
                        }
                        slowCheck.add(repo);
                    }
                    RepositoryInfo[] slowrepos = slowCheck.toArray(new RepositoryInfo[slowCheck.size()]);
                    if (slowrepos.length > 0) {
                        BooleanQuery bq = new BooleanQuery();
                        bq.add(new BooleanClause((Query)new PrefixQuery(new Term("u", prefix)), BooleanClause.Occur.MUST));
                        GroupedSearchRequest gsr = new GroupedSearchRequest((Query)bq, (Grouping)new GGrouping(), (Comparator)new Comparator<String>(){

                            @Override
                            public int compare(String o1, String o2) {
                                return o1.compareTo(o2);
                            }
                        });
                        GroupedSearchResponse response = NexusRepositoryIndexerImpl.this.searcher.searchGrouped(gsr, NexusRepositoryIndexerImpl.this.getContexts(slowrepos));
                        groups.addAll(response.getResults().keySet());
                    }
                    return groups;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptySet();
        }
    }

    @Override
    public List<NBVersionInfo> getRecords(final String groupId, final String artifactId, final String version, List<RepositoryInfo> repos) {
        final RepositoryInfo[] allrepos = repos.toArray(new RepositoryInfo[repos.size()]);
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<NBVersionInfo>>(){

                public List<NBVersionInfo> run() throws Exception {
                    ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(allrepos);
                    BooleanQuery bq = new BooleanQuery();
                    String id = groupId + "|" + artifactId + "|" + version + "|";
                    bq.add(new BooleanClause((Query)new PrefixQuery(new Term("u", id)), BooleanClause.Occur.MUST));
                    FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                    fsr.setAiCount(512);
                    FlatSearchResponse response = NexusRepositoryIndexerImpl.this.searcher.searchFlatPaged(fsr, NexusRepositoryIndexerImpl.this.getContexts(allrepos));
                    infos.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(response.getResults()));
                    return infos;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public Set<String> getArtifacts(final String groupId, final List<RepositoryInfo> repos) {
        try {
            return (Set)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Set<String>>(){

                public Set<String> run() throws Exception {
                    return NexusRepositoryIndexerImpl.this.doGetArtifacts(groupId, repos);
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptySet();
        }
    }

    private Set<String> doGetArtifacts(String groupId, List<RepositoryInfo> repos) throws IOException {
        RepositoryInfo[] allrepos = repos.toArray(new RepositoryInfo[repos.size()]);
        TreeSet<String> artifacts = new TreeSet<String>();
        BooleanQuery bq = new BooleanQuery();
        this.loadIndexingContext(allrepos);
        String id = groupId + "|";
        bq.add(new BooleanClause((Query)new PrefixQuery(new Term("u", id)), BooleanClause.Occur.MUST));
        FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
        FlatSearchResponse response = this.repeatedFlatSearch(fsr, this.getContexts(allrepos), false);
        if (response != null) {
            for (ArtifactInfo artifactInfo : response.getResults()) {
                artifacts.add(artifactInfo.artifactId);
            }
        }
        return artifacts;
    }

    @Override
    public List<NBVersionInfo> getVersions(final String groupId, final String artifactId, List<RepositoryInfo> repos) {
        final RepositoryInfo[] allrepos = repos.toArray(new RepositoryInfo[repos.size()]);
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<NBVersionInfo>>(){

                public List<NBVersionInfo> run() throws Exception {
                    ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(allrepos);
                    BooleanQuery bq = new BooleanQuery();
                    String id = groupId + "|" + artifactId + "|";
                    bq.add(new BooleanClause((Query)new PrefixQuery(new Term("u", id)), BooleanClause.Occur.MUST));
                    FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                    FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(allrepos), false);
                    if (response != null) {
                        infos.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(response.getResults()));
                    }
                    return infos;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public List<NBVersionInfo> findVersionsByClass(final String className, List<RepositoryInfo> repos) {
        final RepositoryInfo[] allrepos = repos.toArray(new RepositoryInfo[repos.size()]);
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<NBVersionInfo>>(){

                public List<NBVersionInfo> run() throws Exception {
                    ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(allrepos);
                    String clsname = className.replace(".", "/");
                    FlatSearchRequest fsr = new FlatSearchRequest(NexusRepositoryIndexerImpl.this.indexer.constructQuery("c", clsname.toLowerCase()), ArtifactInfo.VERSION_COMPARATOR);
                    fsr.setAiCount(512);
                    FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(allrepos), false);
                    if (response != null) {
                        infos.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(NexusRepositoryIndexerImpl.this.postProcessClasses(response.getResults(), clsname)));
                    }
                    return infos;
                }
            });
        }
        catch (MutexException ex) {
            this.rethrowTooManyClauses(ex);
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public List<NBVersionInfo> findDependencyUsage(final String groupId, final String artifactId, final String version, List<RepositoryInfo> repos) {
        final RepositoryInfo[] allrepos = repos.toArray(new RepositoryInfo[repos.size()]);
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<NBVersionInfo>>(){

                public List<NBVersionInfo> run() throws Exception {
                    ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(allrepos);
                    BooleanQuery bq = new BooleanQuery();
                    bq.add(new BooleanClause((Query)new TermQuery(new Term(NexusRepositoryIndexerImpl.NB_DEPENDENCY_GROUP, groupId)), BooleanClause.Occur.MUST));
                    bq.add(new BooleanClause((Query)new TermQuery(new Term(NexusRepositoryIndexerImpl.NB_DEPENDENCY_ARTIFACT, artifactId)), BooleanClause.Occur.MUST));
                    bq.add(new BooleanClause((Query)new TermQuery(new Term(NexusRepositoryIndexerImpl.NB_DEPENDENCY_VERSION, version)), BooleanClause.Occur.MUST));
                    FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                    fsr.setAiCount(512);
                    FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(allrepos), false);
                    if (response != null) {
                        infos.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(response.getResults()));
                    }
                    return infos;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public List<NBVersionInfo> findByMD5(String md5, List<RepositoryInfo> repos) {
        return Collections.emptyList();
    }

    @Override
    public List<NBVersionInfo> findBySHA1(final String sha1, List<RepositoryInfo> repos) {
        final RepositoryInfo[] allrepos = repos.toArray(new RepositoryInfo[repos.size()]);
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<NBVersionInfo>>(){

                public List<NBVersionInfo> run() throws Exception {
                    ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(allrepos);
                    BooleanQuery bq = new BooleanQuery();
                    bq.add(new BooleanClause(NexusRepositoryIndexerImpl.this.indexer.constructQuery("1", sha1), BooleanClause.Occur.SHOULD));
                    FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                    fsr.setAiCount(512);
                    FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(allrepos), false);
                    if (response != null) {
                        infos.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(response.getResults()));
                    }
                    return infos;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public List<NBVersionInfo> findArchetypes(List<RepositoryInfo> repos) {
        final RepositoryInfo[] allrepos = repos.toArray(new RepositoryInfo[repos.size()]);
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<NBVersionInfo>>(){

                public List<NBVersionInfo> run() throws Exception {
                    ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(allrepos);
                    BooleanQuery bq = new BooleanQuery();
                    bq.add(new BooleanClause((Query)new TermQuery(new Term("p", "maven-archetype")), BooleanClause.Occur.MUST));
                    FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                    fsr.setAiCount(512);
                    FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(allrepos), false);
                    if (response != null) {
                        infos.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(response.getResults()));
                    }
                    return infos;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public Set<String> filterPluginArtifactIds(final String groupId, final String prefix, List<RepositoryInfo> repos) {
        final RepositoryInfo[] allrepos = repos.toArray(new RepositoryInfo[repos.size()]);
        try {
            return (Set)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Set<String>>(){

                public Set<String> run() throws Exception {
                    TreeSet<String> artifacts = new TreeSet<String>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(allrepos);
                    BooleanQuery bq = new BooleanQuery();
                    String id = groupId + "|" + prefix;
                    bq.add(new BooleanClause((Query)new TermQuery(new Term("p", "maven-plugin")), BooleanClause.Occur.MUST));
                    bq.add(new BooleanClause((Query)new PrefixQuery(new Term("u", id)), BooleanClause.Occur.MUST));
                    FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                    fsr.setAiCount(512);
                    FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(allrepos), false);
                    if (response != null) {
                        for (ArtifactInfo artifactInfo : response.getResults()) {
                            artifacts.add(artifactInfo.artifactId);
                        }
                    }
                    return artifacts;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptySet();
        }
    }

    @Override
    public Set<String> filterPluginGroupIds(final String prefix, List<RepositoryInfo> repos) {
        final RepositoryInfo[] allrepos = repos.toArray(new RepositoryInfo[repos.size()]);
        try {
            return (Set)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Set<String>>(){

                public Set<String> run() throws Exception {
                    TreeSet<String> artifacts = new TreeSet<String>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(allrepos);
                    BooleanQuery bq = new BooleanQuery();
                    bq.add(new BooleanClause((Query)new TermQuery(new Term("p", "maven-plugin")), BooleanClause.Occur.MUST));
                    if (prefix.length() > 0) {
                        bq.add(new BooleanClause((Query)new PrefixQuery(new Term("g", prefix)), BooleanClause.Occur.MUST));
                    }
                    FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                    fsr.setAiCount(512);
                    FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(allrepos), false);
                    if (response != null) {
                        for (ArtifactInfo artifactInfo : response.getResults()) {
                            artifacts.add(artifactInfo.groupId);
                        }
                    }
                    return artifacts;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptySet();
        }
    }

    @Override
    public Set<String> filterArtifactIdForGroupId(final String groupId, final String prefix, List<RepositoryInfo> repos) {
        final RepositoryInfo[] allrepos = repos.toArray(new RepositoryInfo[repos.size()]);
        try {
            return (Set)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Set<String>>(){

                public Set<String> run() throws Exception {
                    TreeSet<String> artifacts = new TreeSet<String>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(allrepos);
                    BooleanQuery bq = new BooleanQuery();
                    String id = groupId + "|" + prefix;
                    bq.add(new BooleanClause((Query)new PrefixQuery(new Term("u", id)), BooleanClause.Occur.MUST));
                    FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                    fsr.setAiCount(512);
                    FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(allrepos), false);
                    if (response != null) {
                        for (ArtifactInfo artifactInfo : response.getResults()) {
                            artifacts.add(artifactInfo.artifactId);
                        }
                    }
                    return artifacts;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptySet();
        }
    }

    @Override
    public List<NBVersionInfo> find(final List<QueryField> fields, List<RepositoryInfo> repos) {
        final RepositoryInfo[] allrepos = repos.toArray(new RepositoryInfo[repos.size()]);
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<NBVersionInfo>>(){

                public List<NBVersionInfo> run() throws Exception {
                    ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>();
                    NexusRepositoryIndexerImpl.this.loadIndexingContext(allrepos);
                    BooleanQuery bq = new BooleanQuery();
                    for (QueryField field : fields) {
                        Object q;
                        BooleanClause.Occur occur;
                        BooleanClause.Occur occur2 = occur = field.getOccur() == 1 ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
                        String fieldName = NexusRepositoryIndexerImpl.this.toNexusField(field.getField());
                        if (fieldName == null) continue;
                        if ("c".equals(fieldName)) {
                            String clsname = field.getValue().replace(".", "/");
                            q = NexusRepositoryIndexerImpl.this.indexer.constructQuery("c", clsname.toLowerCase());
                        } else {
                            q = "a".equals(fieldName) ? NexusRepositoryIndexerImpl.this.indexer.constructQuery(fieldName, field.getValue()) : (field.getMatch() == 0 ? new TermQuery(new Term(fieldName, field.getValue())) : new PrefixQuery(new Term(fieldName, field.getValue())));
                        }
                        BooleanClause bc = new BooleanClause(q, occur);
                        bq.add(bc);
                    }
                    FlatSearchRequest fsr = new FlatSearchRequest((Query)bq, ArtifactInfo.VERSION_COMPARATOR);
                    fsr.setAiCount(512);
                    FlatSearchResponse response = NexusRepositoryIndexerImpl.this.repeatedFlatSearch(fsr, NexusRepositoryIndexerImpl.this.getContexts(allrepos), true);
                    infos.addAll(NexusRepositoryIndexerImpl.this.convertToNBVersionInfo(response.getResults()));
                    return infos;
                }
            });
        }
        catch (MutexException ex) {
            this.rethrowTooManyClauses(ex);
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public List<RepositoryInfo> getLoaded(final List<RepositoryInfo> repos) {
        try {
            return (List)MUTEX.writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<List<RepositoryInfo>>(){

                public List<RepositoryInfo> run() throws Exception {
                    if (!NexusRepositoryIndexerImpl.this.inited) {
                        return Collections.emptyList();
                    }
                    ArrayList<RepositoryInfo> toRet = new ArrayList<RepositoryInfo>(repos.size());
                    for (RepositoryInfo info : repos) {
                        if (NexusRepositoryIndexerImpl.this.indexer.getIndexingContexts().get(info.getId()) == null) continue;
                        toRet.add(info);
                    }
                    return toRet;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    private String toNexusField(String field) {
        if ("artifactId".equals(field)) {
            return "a";
        }
        if ("groupId".equals(field)) {
            return "g";
        }
        if ("version".equals(field)) {
            return "v";
        }
        if ("classes".equals(field)) {
            return "c";
        }
        if ("name".equals(field)) {
            return "n";
        }
        if ("description".equals(field)) {
            return "d";
        }
        if ("packaging".equals(field)) {
            return "p";
        }
        return field;
    }

    private void rethrowTooManyClauses(MutexException mutEx) {
        Exception cause = mutEx.getException();
        if (cause instanceof BooleanQuery.TooManyClauses) {
            throw (BooleanQuery.TooManyClauses)((Object)cause);
        }
    }

    private Collection<ArtifactInfo> postProcessClasses(Collection<ArtifactInfo> artifactInfos, String classname) {
        int patter = 40;
        boolean isPath = classname.contains("/");
        if (isPath) {
            return artifactInfos;
        }
        String pattStr = ".*/" + classname + "$.*";
        Pattern patt = Pattern.compile(pattStr, patter);
        Iterator<ArtifactInfo> it = artifactInfos.iterator();
        while (it.hasNext()) {
            ArtifactInfo ai = it.next();
            Matcher m = patt.matcher(ai.classNames);
            if (m.matches()) continue;
            it.remove();
        }
        return artifactInfos;
    }

    private List<NBVersionInfo> convertToNBVersionInfo(Collection<ArtifactInfo> artifactInfos) {
        ArrayList<NBVersionInfo> bVersionInfos = new ArrayList<NBVersionInfo>();
        for (ArtifactInfo ai : artifactInfos) {
            if ("javadoc".equals(ai.classifier) || "sources".equals(ai.classifier)) continue;
            NBVersionInfo nbvi = new NBVersionInfo(ai.repository, ai.groupId, ai.artifactId, ai.version, ai.packaging, ai.packaging, ai.name, ai.description, ai.classifier);
            nbvi.setJavadocExists(ai.javadocExists == ArtifactAvailablility.PRESENT);
            nbvi.setSourcesExists(ai.sourcesExists == ArtifactAvailablility.PRESENT);
            nbvi.setSignatureExists(ai.signatureExists == ArtifactAvailablility.PRESENT);
            nbvi.setLastModified(ai.lastModified);
            nbvi.setSize(ai.size);
            bVersionInfos.add(nbvi);
        }
        return bVersionInfos;
    }

    private static class NbIndexCreator
    extends AbstractIndexCreator {
        private WeakReference<MavenEmbedder> embedderRef = null;
        private WeakReference<ArtifactRepository> repositoryRef = null;

        private NbIndexCreator() {
        }

        private MavenEmbedder getEmbedder() {
            MavenEmbedder res;
            MavenEmbedder mavenEmbedder = res = null != this.embedderRef ? (MavenEmbedder)this.embedderRef.get() : null;
            if (null == res) {
                res = EmbedderFactory.getOnlineEmbedder();
                this.embedderRef = new WeakReference<MavenEmbedder>(res);
            }
            return res;
        }

        private ArtifactRepository getRepository() {
            ArtifactRepository res;
            ArtifactRepository artifactRepository = res = null != this.repositoryRef ? (ArtifactRepository)this.repositoryRef.get() : null;
            if (null == res) {
                res = this.getEmbedder().getLocalRepository();
                this.repositoryRef = new WeakReference<ArtifactRepository>(res);
            }
            return res;
        }

        public void updateDocument(ArtifactInfo context, Document doc) {
            ArtifactInfo ai = context;
            if (ai.classifier != null) {
                return;
            }
            try {
                MavenProject mp = this.load(ai, this.getRepository());
                if (mp != null) {
                    List dependencies = mp.getDependencies();
                    for (Dependency d : dependencies) {
                        doc.add((Fieldable)new Field(NexusRepositoryIndexerImpl.NB_DEPENDENCY_GROUP, d.getGroupId(), Field.Store.NO, Field.Index.UN_TOKENIZED));
                        doc.add((Fieldable)new Field(NexusRepositoryIndexerImpl.NB_DEPENDENCY_ARTIFACT, d.getArtifactId(), Field.Store.NO, Field.Index.UN_TOKENIZED));
                        doc.add((Fieldable)new Field(NexusRepositoryIndexerImpl.NB_DEPENDENCY_VERSION, d.getVersion(), Field.Store.NO, Field.Index.UN_TOKENIZED));
                    }
                }
            }
            catch (InvalidArtifactRTException ex) {
                ex.printStackTrace();
            }
        }

        private MavenProject load(ArtifactInfo ai, ArtifactRepository repository) {
            try {
                ArtifactFactory artifactFactory = (ArtifactFactory)this.getEmbedder().getPlexusContainer().lookup(ArtifactFactory.class);
                Artifact projectArtifact = artifactFactory.createProjectArtifact(ai.groupId, ai.artifactId, ai.version, null);
                MavenProjectBuilder builder = (MavenProjectBuilder)this.getEmbedder().getPlexusContainer().lookup(MavenProjectBuilder.class);
                return builder.buildFromRepository(projectArtifact, new ArrayList(), repository);
            }
            catch (InvalidProjectModelException ex) {
                LOGGER.log(Level.FINE, "Failed to load project model from repository.", ex);
            }
            catch (ProjectBuildingException ex) {
                LOGGER.log(Level.FINE, "Failed to load project model from repository.", ex);
            }
            catch (Exception exception) {
                LOGGER.log(Level.FINE, "Failed to load project model from repository.", exception);
            }
            return null;
        }

        public void populateArtifactInfo(ArtifactContext context) throws IOException {
        }

        public boolean updateArtifactInfo(Document arg0, ArtifactInfo arg1) {
            return false;
        }
    }
}

