/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar.bootstrap;

import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.sonar.runner.api.EmbeddedRunner;
import org.sonar.runner.api.LogOutput;

public class RunnerFactory {
    private final LogOutput logOutput;
    private final RuntimeInformation runtimeInformation;
    private final MavenSession session;
    private final boolean debugEnabled;

    public RunnerFactory(LogOutput logOutput, boolean debugEnabled, RuntimeInformation runtimeInformation, MavenSession session) {
        this.logOutput = logOutput;
        this.runtimeInformation = runtimeInformation;
        this.session = session;
        this.debugEnabled = debugEnabled;
    }

    public EmbeddedRunner create() {
        EmbeddedRunner runner = EmbeddedRunner.create((LogOutput)this.logOutput);
        runner.setApp("Maven", this.runtimeInformation.getMavenVersion());
        runner.addGlobalProperties(this.createGlobalProperties());
        runner.setGlobalProperty("sonar.mojoUseRunner", "true");
        if (this.debugEnabled) {
            runner.setGlobalProperty("sonar.verbose", "true");
        }
        return runner;
    }

    private Properties createGlobalProperties() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.session.getTopLevelProject().getProperties());
        p.putAll((Map<?, ?>)this.session.getSystemProperties());
        p.putAll((Map<?, ?>)this.session.getUserProperties());
        return p;
    }
}

