/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.docbkx.maven;

import com.agilejava.docbkx.maven.AbstractTransformerMojo;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractMojoBase
extends AbstractTransformerMojo {
    public void preProcess() throws MojoExecutionException {
        super.preProcess();
        this.configureXslthl();
    }

    private void configureXslthl() {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("docbook/highlighting/xslthl-config.xml");
        String config = this.getProperty("highlightXslthlConfig");
        String xslthlSysProp = System.getProperty("xslthl.config");
        if (config != null) {
            url = this.convertToUrl(config);
        } else if (xslthlSysProp != null) {
            url = this.convertToUrl(xslthlSysProp);
        }
        if (url == null) {
            this.getLog().error((CharSequence)"Error while converting XSLTHL config file");
        } else {
            this.setProperty("highlightXslthlConfig", url.toExternalForm());
        }
    }

    private URL convertToUrl(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Config file path must not be null");
        }
        String s = path.replace("file:///", "/");
        File file = new File(s);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            this.getLog().warn((CharSequence)("The given XSLTHL config file seems to not be legal: " + path));
        } else {
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                this.getLog().error((Throwable)e);
            }
        }
        return null;
    }
}

