/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.AbstractGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseGraph<V, E>
extends AbstractGraph<V, E>
implements Graph<V, E>,
Serializable {
    protected static final int INCOMING = 0;
    protected static final int OUTGOING = 1;
    protected static final int INCIDENT = 2;
    protected Map<V, Map<V, E>[]> vertex_maps = new HashMap<V, Map<V, E>[]>();
    protected Map<E, Pair<V>> directed_edges = new HashMap<E, Pair<V>>();
    protected Map<E, Pair<V>> undirected_edges = new HashMap<E, Pair<V>>();

    public static <V, E> Factory<Graph<V, E>> getFactory() {
        return new Factory<Graph<V, E>>(){

            public Graph<V, E> create() {
                return new SparseGraph();
            }
        };
    }

    @Override
    public E findEdge(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        E edge = this.vertex_maps.get(v1)[1].get(v2);
        if (edge == null) {
            edge = this.vertex_maps.get(v1)[2].get(v2);
        }
        return edge;
    }

    @Override
    public Collection<E> findEdgeSet(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        ArrayList<E> edges = new ArrayList<E>(2);
        E e1 = this.vertex_maps.get(v1)[1].get(v2);
        if (e1 != null) {
            edges.add(e1);
        }
        E e2 = this.vertex_maps.get(v1)[2].get(v2);
        if (e1 != null) {
            edges.add(e2);
        }
        return edges;
    }

    @Override
    public boolean addEdge(E edge, Pair<? extends V> endpoints, EdgeType edgeType) {
        Object v2;
        Pair<? extends V> new_endpoints = this.getValidatedEndpoints(edge, endpoints);
        if (new_endpoints == null) {
            return false;
        }
        Object v1 = new_endpoints.getFirst();
        E connection = this.findEdge(v1, v2 = new_endpoints.getSecond());
        if (connection != null && this.getEdgeType(connection) == edgeType) {
            return false;
        }
        if (!this.containsVertex(v1)) {
            this.addVertex(v1);
        }
        if (!this.containsVertex(v2)) {
            this.addVertex(v2);
        }
        if (edgeType == EdgeType.DIRECTED) {
            this.vertex_maps.get(v1)[1].put(v2, edge);
            this.vertex_maps.get(v2)[0].put(v1, edge);
            this.directed_edges.put(edge, new_endpoints);
        } else {
            this.vertex_maps.get(v1)[2].put(v2, edge);
            this.vertex_maps.get(v2)[2].put(v1, edge);
            this.undirected_edges.put(edge, new_endpoints);
        }
        return true;
    }

    public Collection<E> getInEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<E> in = new HashSet<E>(this.vertex_maps.get(vertex)[0].values());
        in.addAll(this.vertex_maps.get(vertex)[2].values());
        return Collections.unmodifiableCollection(in);
    }

    public Collection<E> getOutEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<E> out = new HashSet<E>(this.vertex_maps.get(vertex)[1].values());
        out.addAll(this.vertex_maps.get(vertex)[2].values());
        return Collections.unmodifiableCollection(out);
    }

    public Collection<V> getPredecessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<V> preds = new HashSet<V>(this.vertex_maps.get(vertex)[0].keySet());
        preds.addAll(this.vertex_maps.get(vertex)[2].keySet());
        return Collections.unmodifiableCollection(preds);
    }

    public Collection<V> getSuccessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<V> succs = new HashSet<V>(this.vertex_maps.get(vertex)[1].keySet());
        succs.addAll(this.vertex_maps.get(vertex)[2].keySet());
        return Collections.unmodifiableCollection(succs);
    }

    public Collection<E> getEdges(EdgeType edgeType) {
        if (edgeType == EdgeType.DIRECTED) {
            return Collections.unmodifiableCollection(this.directed_edges.keySet());
        }
        if (edgeType == EdgeType.UNDIRECTED) {
            return Collections.unmodifiableCollection(this.undirected_edges.keySet());
        }
        return null;
    }

    public Pair<V> getEndpoints(E edge) {
        Pair<V> endpoints = this.directed_edges.get(edge);
        if (endpoints == null) {
            return this.undirected_edges.get(edge);
        }
        return endpoints;
    }

    public EdgeType getEdgeType(E edge) {
        if (this.directed_edges.containsKey(edge)) {
            return EdgeType.DIRECTED;
        }
        if (this.undirected_edges.containsKey(edge)) {
            return EdgeType.UNDIRECTED;
        }
        return null;
    }

    public V getSource(E directed_edge) {
        if (this.getEdgeType(directed_edge) == EdgeType.DIRECTED) {
            return (V)this.directed_edges.get(directed_edge).getFirst();
        }
        return null;
    }

    public V getDest(E directed_edge) {
        if (this.getEdgeType(directed_edge) == EdgeType.DIRECTED) {
            return (V)this.directed_edges.get(directed_edge).getSecond();
        }
        return null;
    }

    public boolean isSource(V vertex, E edge) {
        if (!this.containsVertex(vertex) || !this.containsEdge(edge)) {
            return false;
        }
        V source = this.getSource(edge);
        if (source != null) {
            return source.equals(vertex);
        }
        return false;
    }

    public boolean isDest(V vertex, E edge) {
        if (!this.containsVertex(vertex) || !this.containsEdge(edge)) {
            return false;
        }
        V dest = this.getDest(edge);
        if (dest != null) {
            return dest.equals(vertex);
        }
        return false;
    }

    public Collection<E> getEdges() {
        ArrayList<E> edges = new ArrayList<E>(this.directed_edges.keySet());
        edges.addAll(this.undirected_edges.keySet());
        return Collections.unmodifiableCollection(edges);
    }

    public Collection<V> getVertices() {
        return Collections.unmodifiableCollection(this.vertex_maps.keySet());
    }

    public boolean containsVertex(V vertex) {
        return this.vertex_maps.containsKey(vertex);
    }

    public boolean containsEdge(E edge) {
        return this.directed_edges.containsKey(edge) || this.undirected_edges.containsKey(edge);
    }

    public int getEdgeCount() {
        return this.directed_edges.size() + this.undirected_edges.size();
    }

    public int getVertexCount() {
        return this.vertex_maps.size();
    }

    public Collection<V> getNeighbors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<V> neighbors = new HashSet<V>(this.vertex_maps.get(vertex)[0].keySet());
        neighbors.addAll(this.vertex_maps.get(vertex)[1].keySet());
        neighbors.addAll(this.vertex_maps.get(vertex)[2].keySet());
        return Collections.unmodifiableCollection(neighbors);
    }

    public Collection<E> getIncidentEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<E> incident = new HashSet<E>(this.vertex_maps.get(vertex)[0].values());
        incident.addAll(this.vertex_maps.get(vertex)[1].values());
        incident.addAll(this.vertex_maps.get(vertex)[2].values());
        return Collections.unmodifiableCollection(incident);
    }

    public boolean addVertex(V vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.containsVertex(vertex)) {
            this.vertex_maps.put((HashMap[])vertex, new HashMap[]{new HashMap(), new HashMap(), new HashMap()});
            return true;
        }
        return false;
    }

    public boolean removeVertex(V vertex) {
        if (!this.containsVertex(vertex)) {
            return false;
        }
        ArrayList<E> incident = new ArrayList<E>(this.getIncidentEdges(vertex));
        for (Object edge : incident) {
            this.removeEdge(edge);
        }
        this.vertex_maps.remove(vertex);
        return true;
    }

    public boolean removeEdge(E edge) {
        if (!this.containsEdge(edge)) {
            return false;
        }
        Pair<V> endpoints = this.getEndpoints(edge);
        Object v1 = endpoints.getFirst();
        Object v2 = endpoints.getSecond();
        if (this.getEdgeType(edge) == EdgeType.DIRECTED) {
            this.vertex_maps.get(v1)[1].remove(v2);
            this.vertex_maps.get(v2)[0].remove(v1);
            this.directed_edges.remove(edge);
        } else {
            this.vertex_maps.get(v1)[2].remove(v2);
            this.vertex_maps.get(v2)[2].remove(v1);
            this.undirected_edges.remove(edge);
        }
        return true;
    }

    public int getEdgeCount(EdgeType edge_type) {
        if (edge_type == EdgeType.DIRECTED) {
            return this.directed_edges.size();
        }
        if (edge_type == EdgeType.UNDIRECTED) {
            return this.undirected_edges.size();
        }
        return 0;
    }

    public EdgeType getDefaultEdgeType() {
        return EdgeType.UNDIRECTED;
    }
}

